/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ******************************************************************************
 *
 * Copyright (C) 1996-2005 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer
 *    unmodified other than the allowable addition of one or more
 *    copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 *
 * Version: Onyx 5.1.2
 *
 ******************************************************************************/

typedef int32_t cw_nxo_file_read_t (void *a_arg, cw_nxo_t *a_file,
				    uint32_t a_len, char *r_str);

typedef bool cw_nxo_file_write_t (void *a_arg, cw_nxo_t *a_file,
				  const char *a_str,
				  uint32_t a_len);

typedef cw_nxoe_t *cw_nxo_file_ref_iter_t (void *a_arg, bool a_reset);

typedef void cw_nxo_file_delete_t (void *a_arg);

void
nxo_file_new(cw_nxo_t *a_nxo, bool a_locking);

#ifdef CW_POSIX_FILE
void
nxo_file_fd_wrap(cw_nxo_t *a_nxo, uint32_t a_fd, bool a_close);
#endif

void
nxo_file_synthetic(cw_nxo_t *a_nxo, cw_nxo_file_read_t *a_read,
		   cw_nxo_file_write_t *a_write,
		   cw_nxo_file_ref_iter_t *a_ref_iter,
		   cw_nxo_file_delete_t *a_delete, void *a_arg);

#ifdef CW_POSIX_FILE
cw_nxn_t
nxo_file_open(cw_nxo_t *a_nxo, const char *a_filename, uint32_t a_nlen,
	      const char *a_flags, uint32_t a_flen, mode_t a_mode);
#endif

cw_nxn_t
nxo_file_close(cw_nxo_t *a_nxo);

void
nxo_file_origin_get(const cw_nxo_t *a_nxo, const char **r_origin,
		    uint32_t *r_olen);

void
nxo_file_origin_set(cw_nxo_t *a_nxo, const char *a_origin,
		    uint32_t a_olen);

#ifdef CW_POSIX_FILE
int32_t
nxo_file_fd_get(const cw_nxo_t *a_nxo);
#endif

bool
nxo_file_nonblocking_get(const cw_nxo_t *a_nxo);

bool
nxo_file_nonblocking_set(cw_nxo_t *a_nxo, bool a_nonblocking);

int32_t
nxo_file_read(cw_nxo_t *a_nxo, uint32_t a_len, char *r_str);

cw_nxn_t
nxo_file_readline(cw_nxo_t *a_nxo, bool a_locking, cw_nxo_t *r_string,
		  bool *r_eof);

cw_nxn_t
nxo_file_write(cw_nxo_t *a_nxo, const char *a_str, uint32_t a_len,
	       uint32_t *r_count);

#ifdef CW_POSIX_FILE
cw_nxn_t
nxo_file_truncate(cw_nxo_t *a_nxo, off_t a_length);
#endif

cw_nxoi_t
nxo_file_position_get(cw_nxo_t *a_nxo);

#ifdef CW_POSIX_FILE
cw_nxn_t
nxo_file_position_set(cw_nxo_t *a_nxo, cw_nxoi_t a_position);
#endif

uint32_t
nxo_file_buffer_size_get(const cw_nxo_t *a_nxo);

void
nxo_file_buffer_size_set(cw_nxo_t *a_nxo, uint32_t a_size);

cw_nxoi_t
nxo_file_buffer_count(const cw_nxo_t *a_nxo);

cw_nxn_t
nxo_file_buffer_flush(cw_nxo_t *a_nxo);
