/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGException;
import java.awt.color.ColorSpace;
import java.awt.image.IndexColorModel;

public class PNGPalette
extends PNGChunk {
    private int[] red;
    private int[] green;
    private int[] blue;

    protected PNGPalette(int n, byte[] byArray, int n2) throws PNGException {
        super(n, byArray, n2);
        double d = byArray.length;
        if ((d /= 3.0) - Math.floor(d) != 0.0) {
            throw new PNGException("Invalid size of palette chunk.");
        }
        int n3 = (int)d;
        this.red = new int[n3];
        this.green = new int[n3];
        this.blue = new int[n3];
        for (int i = 0; i < n3; ++i) {
            this.red[i] = byArray[i * 3] & 0xFF;
            this.green[i] = byArray[i * 3 + 1] & 0xFF;
            this.blue[i] = byArray[i * 3 + 2] & 0xFF;
        }
    }

    public PNGPalette(IndexColorModel indexColorModel) {
        super(1347179589);
        int n = indexColorModel.getMapSize();
        this.data = new byte[n * 3];
        this.red = new int[n];
        this.green = new int[n];
        this.blue = new int[n];
        for (int i = 0; i < n; ++i) {
            byte by = (byte)indexColorModel.getRed(i);
            this.data[i * 3] = by;
            this.red[i] = by;
            byte by2 = (byte)indexColorModel.getGreen(i);
            this.data[i * 3 + 1] = by2;
            this.green[i] = by2;
            byte by3 = (byte)indexColorModel.getBlue(i);
            this.data[i * 3 + 2] = by3;
            this.blue[i] = by3;
        }
    }

    public IndexColorModel getPalette(ColorSpace colorSpace) {
        int n = this.red.length;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        if (colorSpace == null) {
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)this.red[i];
                byArray2[i] = (byte)this.green[i];
                byArray3[i] = (byte)this.blue[i];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                float[] fArray = new float[]{(float)this.red[i] / 255.0f, (float)this.green[i] / 255.0f, (float)this.blue[i] / 255.0f};
                float[] fArray2 = colorSpace.toRGB(fArray);
                byArray[i] = (byte)Math.round((double)fArray2[0] * 255.0);
                byArray2[i] = (byte)Math.round((double)fArray2[1] * 255.0);
                byArray3[i] = (byte)Math.round((double)fArray2[2] * 255.0);
            }
        }
        return new IndexColorModel(8, n, byArray, byArray2, byArray3);
    }

    public String toString() {
        String string = "PNG Palette:\n";
        for (int i = 0; i < this.red.length; ++i) {
            string = string + "Index " + i + ": [" + this.red[i] + ", " + this.green[i] + ", " + this.blue[i] + "]\n";
        }
        return string;
    }
}

