/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print;

import gnu.javax.print.CupsPrintService;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppPrintService;
import gnu.javax.print.ipp.IppRequest;
import gnu.javax.print.ipp.IppResponse;
import gnu.javax.print.ipp.attribute.RequestedAttributes;
import gnu.javax.print.ipp.attribute.supported.PrinterUriSupported;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.print.attribute.Attribute;

public class CupsServer {
    private transient URI uri;
    private transient String username;
    private transient String password;

    public CupsServer(String string, String string2) {
        this.username = string;
        this.password = string2;
        this.uri = null;
        try {
            String string3 = System.getProperty("gnu.javax.print.server");
            if (string3 != null) {
                this.uri = new URI("http://" + string3 + ":631");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("gnu.javax.print.CupsServer value is not a valid hostname.");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            if (this.uri == null) {
                this.uri = new URI("http://localhost:631");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public CupsServer(URI uRI, String string, String string2) {
        this.uri = uRI;
        this.username = string;
        this.password = string2;
    }

    public IppPrintService getDefaultPrinter() throws IppException {
        Object object;
        Object object2;
        IppResponse ippResponse = null;
        try {
            object2 = new IppRequest(this.uri, this.username, this.password);
            ((IppRequest)object2).setOperationID((short)16385);
            ((IppRequest)object2).setOperationAttributeDefaults();
            object = new RequestedAttributes("printer-uri-supported");
            ((IppRequest)object2).addOperationAttribute((Attribute)object);
            ippResponse = ((IppRequest)object2).send();
        }
        catch (IOException iOException) {
            throw new IppException("IOException in IPP request/response.", iOException);
        }
        object2 = (Map)ippResponse.getPrinterAttributes().get(0);
        object = (Set)object2.get(CupsServer.class$("gnu.javax.print.ipp.attribute.supported.PrinterUriSupported"));
        PrinterUriSupported printerUriSupported = (PrinterUriSupported)object.toArray()[0];
        CupsPrintService cupsPrintService = new CupsPrintService(printerUriSupported.getURI(), this.username, this.password);
        return cupsPrintService;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public List getAllPrinters() throws IppException {
        Serializable serializable;
        Object object;
        IppResponse ippResponse = null;
        try {
            object = new IppRequest(this.uri, this.username, this.password);
            ((IppRequest)object).setOperationID((short)16386);
            ((IppRequest)object).setOperationAttributeDefaults();
            serializable = new RequestedAttributes("printer-uri-supported");
            ((IppRequest)object).addOperationAttribute((Attribute)serializable);
            ippResponse = ((IppRequest)object).send();
        }
        catch (IOException iOException) {
            throw new IppException("IOException in IPP request/response.", iOException);
        }
        object = ippResponse.getPrinterAttributes();
        serializable = new ArrayList();
        for (int i = 0; i < object.size(); ++i) {
            Map map = (Map)object.get(i);
            Set set = (Set)map.get(CupsServer.class$("gnu.javax.print.ipp.attribute.supported.PrinterUriSupported"));
            PrinterUriSupported printerUriSupported = (PrinterUriSupported)set.toArray()[0];
            try {
                CupsPrintService cupsPrintService = new CupsPrintService(printerUriSupported.getURI(), this.username, this.password);
                serializable.add(cupsPrintService);
                continue;
            }
            catch (IppException ippException) {
                // empty catch block
            }
        }
        return serializable;
    }

    public List getAllClasses() throws IppException {
        Serializable serializable;
        Object object;
        IppResponse ippResponse = null;
        try {
            object = new IppRequest(this.uri, this.username, this.password);
            ((IppRequest)object).setOperationID((short)16389);
            ((IppRequest)object).setOperationAttributeDefaults();
            serializable = new RequestedAttributes("printer-uri-supported");
            ((IppRequest)object).addOperationAttribute((Attribute)serializable);
            ippResponse = ((IppRequest)object).send();
        }
        catch (IOException iOException) {
            throw new IppException("IOException in IPP request/response.", iOException);
        }
        object = ippResponse.getPrinterAttributes();
        serializable = new ArrayList();
        for (int i = 0; i < object.size(); ++i) {
            Map map = (Map)object.get(i);
            Set set = (Set)map.get(CupsServer.class$("gnu.javax.print.ipp.attribute.supported.PrinterUriSupported"));
            PrinterUriSupported printerUriSupported = (PrinterUriSupported)set.toArray()[0];
            try {
                CupsPrintService cupsPrintService = new CupsPrintService(printerUriSupported.getURI(), this.username, this.password);
                serializable.add(cupsPrintService);
                continue;
            }
            catch (IppException ippException) {
                // empty catch block
            }
        }
        return serializable;
    }
}

