/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;

public class JFrame
extends Frame
implements WindowConstants,
RootPaneContainer,
Accessible {
    public static final int EXIT_ON_CLOSE = 3;
    private static final long serialVersionUID = -3362141868504252139L;
    private static boolean defaultLookAndFeelDecorated;
    private int closeAction;
    protected AccessibleContext accessibleContext;
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled;

    private /* synthetic */ void finit$() {
        this.closeAction = 1;
        this.rootPaneCheckingEnabled = false;
    }

    public JFrame() {
        super("");
        this.finit$();
        this.frameInit();
    }

    public JFrame(String string) {
        super(string);
        this.finit$();
        this.frameInit();
    }

    public JFrame(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.finit$();
        this.frameInit();
    }

    public JFrame(String string, GraphicsConfiguration graphicsConfiguration) {
        super(string, graphicsConfiguration);
        this.finit$();
        this.frameInit();
    }

    protected void frameInit() {
        super.setLayout(new BorderLayout());
        this.setBackground(UIManager.getDefaults().getColor("control"));
        this.enableEvents(64);
        this.getRootPane();
        if (JFrame.isDefaultLookAndFeelDecorated() && UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        this.setRootPaneCheckingEnabled(true);
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setJMenuBar(jMenuBar);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JRootPane getRootPane() {
        if (this.rootPane == null) {
            this.setRootPane(this.createRootPane());
        }
        return this.rootPane;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        this.add((Component)this.rootPane, "Center");
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(this.rootPane);
        } else {
            this.getContentPane().remove(component);
        }
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
    }

    public static void setDefaultLookAndFeelDecorated(boolean bl) {
        defaultLookAndFeelDecorated = bl;
    }

    public static boolean isDefaultLookAndFeelDecorated() {
        return defaultLookAndFeelDecorated;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJFrame(this);
        }
        return this.accessibleContext;
    }

    public int getDefaultCloseOperation() {
        return this.closeAction;
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer(super.paramString());
        stringBuffer.append(",defaultCloseOperation=");
        stringBuffer.append(SwingUtilities.convertWindowConstantToString(this.getDefaultCloseOperation()));
        stringBuffer.append(",rootPane=");
        if (this.rootPane != null) {
            stringBuffer.append(this.rootPane);
        }
        stringBuffer.append(",rootPaneCheckingEnabled=").append(this.rootPaneCheckingEnabled);
        return stringBuffer.toString();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        block0 : switch (windowEvent.getID()) {
            case 201: {
                switch (this.closeAction) {
                    case 3: {
                        System.exit(0);
                        break block0;
                    }
                    case 2: {
                        this.dispose();
                        break block0;
                    }
                    case 1: {
                        this.setVisible(false);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void setDefaultCloseOperation(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && n == 3) {
            securityManager.checkExit(0);
        }
        if (n != 3 && n != 2 && n != 1 && n != 0) {
            throw new IllegalArgumentException("operation must be EXIT_ON_CLOSE, HIDE_ON_CLOSE, DISPOSE_ON_CLOSE, or DO_NOTHING_ON_CLOSE");
        }
        this.closeAction = n;
    }

    protected class AccessibleJFrame
    extends Frame.AccessibleAWTFrame {
        private /* synthetic */ JFrame this$0;

        protected AccessibleJFrame(JFrame jFrame) {
            this.this$0 = jFrame;
            super(jFrame);
        }
    }
}

