/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.structure.link;

import br.arca.morcego.physics.PunctualBody;
import br.arca.morcego.physics.Vector3D;
import br.arca.morcego.run.Renderer;
import br.arca.morcego.structure.Link;
import br.arca.morcego.structure.Node;
import java.awt.Graphics;

public class DirectionalLink
extends Link {
    private static final long serialVersionUID = -5189503975335282448L;

    public DirectionalLink() {
    }

    public DirectionalLink(Node n1, Node n2) {
        super(n1, n2);
    }

    public void paint(Graphics g) {
        PunctualBody body1 = this.node1.getBody();
        PunctualBody body2 = this.node2.getBody();
        g.setColor(Renderer.fadeColor(this.color, Math.min(body1.getScale(), body2.getScale())));
        Vector3D start = new Vector3D(body1.projection.x, body1.projection.y, 0.0f);
        Vector3D inc = new Vector3D(body2.projection.x, body2.projection.y, 0.0f).getVectorFrom(start);
        Vector3D end = start.makeClone();
        end.add(inc.multiplyByScalar(0.9f));
        g.drawLine((int)start.x, (int)start.y, (int)end.x, (int)end.y);
        Vector3D arrow = inc.opposite().multiplyByScalar(0.06f);
        double angle = 0.5235987755982988;
        float newX = (float)((double)arrow.x * Math.cos(angle) + (double)arrow.y * Math.sin(angle));
        float newY = (float)((double)arrow.y * Math.cos(angle) - (double)arrow.x * Math.sin(angle));
        g.drawLine((int)end.x, (int)end.y, (int)(end.x + newX), (int)(end.y + newY));
        newX = (float)((double)arrow.x * Math.cos(angle *= -1.0) + (double)arrow.y * Math.sin(angle));
        newY = (float)((double)arrow.y * Math.cos(angle) - (double)arrow.x * Math.sin(angle));
        g.drawLine((int)end.x, (int)end.y, (int)(end.x + newX), (int)(end.y + newY));
    }
}

