.\" Copyright 2004 Red Hat Inc., Durham, North Carolina.
.\" All Rights Reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation on the rights to use, copy, modify, merge,
.\" publish, distribute, sublicense, and/or sell copies of the Software,
.\" and to permit persons to whom the Software is furnished to do so,
.\" subject to the following conditions:
.\"
.\" he above copyright notice and this permission notice (including the
.\" next paragraph) shall be included in all copies or substantial
.\" portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NON-INFRINGEMENT.  IN NO EVENT SHALL RED HAT AND/OR THEIR SUPPLIERS
.\" BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
.\" ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.TH DMXChangeScreensAttributes __libmansuffix__ __vendorversion__
.SH NAME
DMXChangeScreensAttributes \- change back-end screen attributes
.SH SYNOPSIS
.B #include <X11/extensions/dmxext.h>
.sp
.nf
.BI "int DMXChangeScreensAttributes(Display " *dpy ,
.BI "                               int " screen_count ,
.BI "                               int " *screens ,
.BI "                               int " mask_count ,
.BI "                               unsigned int " *masks ,
.BI "                               DMXScreenAttributes " *attr ,
.BI "                               int *" error_screen );
.fi
.SH DESCRIPTION
.B DMXChangeScreensAttributes()
changes the geometries and positions of the DMX screen and DMX root
windows on the back-end X servers.
.I screen_count
specifies the number of screens to be changed.  For each screen, the
screen number is placed in
.IR screens ,
an attribute mask is placed in
.IR masks ,
and a
.I DMXScreenAttributes
structure is included in
.IR attr .
.PP
An explanation of the
.I DMXScreenAttributes
structure is given in
.BR DMXGetScreenAttributes (__libmansuffix__).
.PP
The values that are used to compute each value in
.I masks
are as follows
.sp
.nf
DMXScreenWindowWidth
DMXScreenWindowHeight
DMXScreenWindowXoffset
DMXScreenWindowYoffset
DMXRootWindowWidth
DMXRootWindowHeight
DMXRootWindowXoffset
DMXRootWindowYoffset
DMXRootWindowXorigin
DMXRootWindowYorigin
.fi
.PP
In general,
.I mask_count
should be equal to
.IR screen_count .
However, as a convenience,
.I mask_count
may be less than
.IR screen_count ,
and the last entry in
.I masks
will then be used for all of the remaining screens.  For example, this
allows identical changes to be made to several screens using only one
mask.
.SH "RETURN VALUE"
On success, 0 is returned.  Otherwise,
.I error_screen
is set to the value of the first screen in the list that caused the
error and a non-zero value is returned.  If
.I screen_count
or
.I mask_count
is less than 1, or if any of the attribute values are not within the
appropriate bounding boxes,
.B DmxBadValue
is returned.  If a protocol error occurs,
.B DmxBadReply
is returned.
.PP
.B DMXChangeScreensAttributes()
can generate
.B BadLength
(if the data provided does not match the data implicitly required by the
.I screen_count
and
.I mask_count
values),
.B BadValue
(if the values in
.I screens
are not valid), and
.B BadAlloc
errors.
.SH "SEE ALSO"
.BR DMXGetScreenCount "(__libmansuffix__), "
.BR DMXGetScreenAttributes "(__libmansuffix__), "
.BR DMX "(__libmansuffix__), " Xdmx (1)
