require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&FXP_NTXCB)) {
    sub FXP_NTXCB () {	128;}
}
unless(defined(&FXP_NRFABUFS_MIN)) {
    sub FXP_NRFABUFS_MIN () {	4;}
}
unless(defined(&FXP_NRFABUFS_MAX)) {
    sub FXP_NRFABUFS_MAX () {	64;}
}
unless(defined(&FXP_INT_DELAY)) {
    eval 'sub FXP_INT_DELAY () {128;}' unless defined(&FXP_INT_DELAY);
}
unless(defined(&FXP_BUNDLE_MAX)) {
    eval 'sub FXP_BUNDLE_MAX () {16;}' unless defined(&FXP_BUNDLE_MAX);
}
unless(defined(&FXP_MIN_SIZE_MASK)) {
    eval 'sub FXP_MIN_SIZE_MASK () {0xffff;}' unless defined(&FXP_MIN_SIZE_MASK);
}
unless(defined(&FXPF_MWI_ENABLE)) {
    sub FXPF_MWI_ENABLE () {	0x10;}
}
unless(defined(&FXPF_DISABLE_STANDBY)) {
    sub FXPF_DISABLE_STANDBY () {	0x20;}
}
unless(defined(&FXPF_UCODELOADED)) {
    sub FXPF_UCODELOADED () {	0x40;}
}
unless(defined(&FXPF_NOUCODE)) {
    sub FXPF_NOUCODE () {	0x80;}
}
unless(defined(&FXPF_RECV_WORKAROUND)) {
    sub FXPF_RECV_WORKAROUND () {	0x100;}
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&FXP_RXMAP_GET)) {
    sub FXP_RXMAP_GET {
	my($sc) = @_;
	eval q((($sc)-> $sc_rxmaps[($sc)-> &sc_rxfree++]));
    }
}
unless(defined(&FXP_RXMAP_PUT)) {
    sub FXP_RXMAP_PUT {
	my($sc,$map) = @_;
	eval q((($sc)-> $sc_rxmaps[--($sc)-> &sc_rxfree] = ($map)));
    }
}
unless(defined(&FXP_TXCB_SYNC)) {
    sub FXP_TXCB_SYNC {
	my($sc, $txs, $p) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &tx_cb_map, ($txs)-> &tx_off, $sizeof{'struct fxp_cb_tx'}, ($p)));
    }
}
unless(defined(&FXP_MCS_SYNC)) {
    sub FXP_MCS_SYNC {
	my($sc, $p) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &tx_cb_map,  &offsetof('struct fxp_ctrl',  ($u->{mcs})), $sizeof{'struct fxp_cb_mcs'}, ($p)));
    }
}
unless(defined(&FXP_IAS_SYNC)) {
    sub FXP_IAS_SYNC {
	my($sc, $p) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &tx_cb_map,  &offsetof('struct fxp_ctrl',  ($u->{ias})), $sizeof{'struct fxp_cb_ias'}, ($p)));
    }
}
unless(defined(&FXP_CFG_SYNC)) {
    sub FXP_CFG_SYNC {
	my($sc, $p) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &tx_cb_map,  &offsetof('struct fxp_ctrl',  ($u->{cfg})), $sizeof{'struct fxp_cb_config'}, ($p)));
    }
}
unless(defined(&FXP_UCODE_SYNC)) {
    sub FXP_UCODE_SYNC {
	my($sc, $p) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &tx_cb_map,  &offsetof('struct fxp_ctrl',  ($u->{code})), $sizeof{'struct fxp_cb_ucode'}, ($p)));
    }
}
unless(defined(&FXP_STATS_SYNC)) {
    sub FXP_STATS_SYNC {
	my($sc, $p) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &tx_cb_map,  &offsetof('struct fxp_ctrl',  &stats), $sizeof{'struct fxp_stats'}, ($p)));
    }
}
unless(defined(&FXP_MBUF_SYNC)) {
    sub FXP_MBUF_SYNC {
	my($sc, $m, $p) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($m), 0, ($m)-> &dm_mapsize, ($p)));
    }
}
1;
