require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NETINET_ICMP6_H_)) {
    eval 'sub _NETINET_ICMP6_H_ () {1;}' unless defined(&_NETINET_ICMP6_H_);
    eval 'sub ICMPV6_PLD_MAXLEN () {1232;}' unless defined(&ICMPV6_PLD_MAXLEN);
    eval 'sub icmp6_data32 () { ($icmp6_dataun->{icmp6_un_data32});}' unless defined(&icmp6_data32);
    eval 'sub icmp6_data16 () { ($icmp6_dataun->{icmp6_un_data16});}' unless defined(&icmp6_data16);
    eval 'sub icmp6_data8 () { ($icmp6_dataun->{icmp6_un_data8});}' unless defined(&icmp6_data8);
    eval 'sub icmp6_pptr () { $icmp6_data32[0];}' unless defined(&icmp6_pptr);
    eval 'sub icmp6_mtu () { $icmp6_data32[0];}' unless defined(&icmp6_mtu);
    eval 'sub icmp6_id () { $icmp6_data16[0];}' unless defined(&icmp6_id);
    eval 'sub icmp6_seq () { $icmp6_data16[1];}' unless defined(&icmp6_seq);
    eval 'sub icmp6_maxdelay () { $icmp6_data16[0];}' unless defined(&icmp6_maxdelay);
    eval 'sub ICMP6_DST_UNREACH () {1;}' unless defined(&ICMP6_DST_UNREACH);
    eval 'sub ICMP6_PACKET_TOO_BIG () {2;}' unless defined(&ICMP6_PACKET_TOO_BIG);
    eval 'sub ICMP6_TIME_EXCEEDED () {3;}' unless defined(&ICMP6_TIME_EXCEEDED);
    eval 'sub ICMP6_PARAM_PROB () {4;}' unless defined(&ICMP6_PARAM_PROB);
    eval 'sub ICMP6_ECHO_REQUEST () {128;}' unless defined(&ICMP6_ECHO_REQUEST);
    eval 'sub ICMP6_ECHO_REPLY () {129;}' unless defined(&ICMP6_ECHO_REPLY);
    eval 'sub MLD_LISTENER_QUERY () {130;}' unless defined(&MLD_LISTENER_QUERY);
    eval 'sub MLD_LISTENER_REPORT () {131;}' unless defined(&MLD_LISTENER_REPORT);
    eval 'sub MLD_LISTENER_DONE () {132;}' unless defined(&MLD_LISTENER_DONE);
    eval 'sub ICMP6_MEMBERSHIP_QUERY () {130;}' unless defined(&ICMP6_MEMBERSHIP_QUERY);
    eval 'sub ICMP6_MEMBERSHIP_REPORT () {131;}' unless defined(&ICMP6_MEMBERSHIP_REPORT);
    eval 'sub ICMP6_MEMBERSHIP_REDUCTION () {132;}' unless defined(&ICMP6_MEMBERSHIP_REDUCTION);
    unless(defined(&_KERNEL)) {
	eval 'sub MLD6_LISTENER_QUERY () { &MLD_LISTENER_QUERY;}' unless defined(&MLD6_LISTENER_QUERY);
	eval 'sub MLD6_LISTENER_REPORT () { &MLD_LISTENER_REPORT;}' unless defined(&MLD6_LISTENER_REPORT);
	eval 'sub MLD6_LISTENER_DONE () { &MLD_LISTENER_DONE;}' unless defined(&MLD6_LISTENER_DONE);
    }
    eval 'sub ND_ROUTER_SOLICIT () {133;}' unless defined(&ND_ROUTER_SOLICIT);
    eval 'sub ND_ROUTER_ADVERT () {134;}' unless defined(&ND_ROUTER_ADVERT);
    eval 'sub ND_NEIGHBOR_SOLICIT () {135;}' unless defined(&ND_NEIGHBOR_SOLICIT);
    eval 'sub ND_NEIGHBOR_ADVERT () {136;}' unless defined(&ND_NEIGHBOR_ADVERT);
    eval 'sub ND_REDIRECT () {137;}' unless defined(&ND_REDIRECT);
    eval 'sub ICMP6_ROUTER_RENUMBERING () {138;}' unless defined(&ICMP6_ROUTER_RENUMBERING);
    eval 'sub ICMP6_WRUREQUEST () {139;}' unless defined(&ICMP6_WRUREQUEST);
    eval 'sub ICMP6_WRUREPLY () {140;}' unless defined(&ICMP6_WRUREPLY);
    eval 'sub ICMP6_FQDN_QUERY () {139;}' unless defined(&ICMP6_FQDN_QUERY);
    eval 'sub ICMP6_FQDN_REPLY () {140;}' unless defined(&ICMP6_FQDN_REPLY);
    eval 'sub ICMP6_NI_QUERY () {139;}' unless defined(&ICMP6_NI_QUERY);
    eval 'sub ICMP6_NI_REPLY () {140;}' unless defined(&ICMP6_NI_REPLY);
    eval 'sub MLDV2_LISTENER_REPORT () {143;}' unless defined(&MLDV2_LISTENER_REPORT);
    eval 'sub MLD_MTRACE_RESP () {200;}' unless defined(&MLD_MTRACE_RESP);
    eval 'sub MLD_MTRACE () {201;}' unless defined(&MLD_MTRACE);
    unless(defined(&_KERNEL)) {
	eval 'sub MLD6_MTRACE_RESP () { &MLD_MTRACE_RESP;}' unless defined(&MLD6_MTRACE_RESP);
	eval 'sub MLD6_MTRACE () { &MLD_MTRACE;}' unless defined(&MLD6_MTRACE);
    }
    eval 'sub ICMP6_MAXTYPE () {201;}' unless defined(&ICMP6_MAXTYPE);
    eval 'sub ICMP6_DST_UNREACH_NOROUTE () {0;}' unless defined(&ICMP6_DST_UNREACH_NOROUTE);
    eval 'sub ICMP6_DST_UNREACH_ADMIN () {1;}' unless defined(&ICMP6_DST_UNREACH_ADMIN);
    eval 'sub ICMP6_DST_UNREACH_NOTNEIGHBOR () {2;}' unless defined(&ICMP6_DST_UNREACH_NOTNEIGHBOR);
    eval 'sub ICMP6_DST_UNREACH_BEYONDSCOPE () {2;}' unless defined(&ICMP6_DST_UNREACH_BEYONDSCOPE);
    eval 'sub ICMP6_DST_UNREACH_ADDR () {3;}' unless defined(&ICMP6_DST_UNREACH_ADDR);
    eval 'sub ICMP6_DST_UNREACH_NOPORT () {4;}' unless defined(&ICMP6_DST_UNREACH_NOPORT);
    eval 'sub ICMP6_TIME_EXCEED_TRANSIT () {0;}' unless defined(&ICMP6_TIME_EXCEED_TRANSIT);
    eval 'sub ICMP6_TIME_EXCEED_REASSEMBLY () {1;}' unless defined(&ICMP6_TIME_EXCEED_REASSEMBLY);
    eval 'sub ICMP6_PARAMPROB_HEADER () {0;}' unless defined(&ICMP6_PARAMPROB_HEADER);
    eval 'sub ICMP6_PARAMPROB_NEXTHEADER () {1;}' unless defined(&ICMP6_PARAMPROB_NEXTHEADER);
    eval 'sub ICMP6_PARAMPROB_OPTION () {2;}' unless defined(&ICMP6_PARAMPROB_OPTION);
    eval 'sub ICMP6_INFOMSG_MASK () {0x80;}' unless defined(&ICMP6_INFOMSG_MASK);
    eval 'sub ICMP6_NI_SUBJ_IPV6 () {0;}' unless defined(&ICMP6_NI_SUBJ_IPV6);
    eval 'sub ICMP6_NI_SUBJ_FQDN () {1;}' unless defined(&ICMP6_NI_SUBJ_FQDN);
    eval 'sub ICMP6_NI_SUBJ_IPV4 () {2;}' unless defined(&ICMP6_NI_SUBJ_IPV4);
    eval 'sub ICMP6_NI_SUCCESS () {0;}' unless defined(&ICMP6_NI_SUCCESS);
    eval 'sub ICMP6_NI_REFUSED () {1;}' unless defined(&ICMP6_NI_REFUSED);
    eval 'sub ICMP6_NI_UNKNOWN () {2;}' unless defined(&ICMP6_NI_UNKNOWN);
    eval 'sub ICMP6_ROUTER_RENUMBERING_COMMAND () {0;}' unless defined(&ICMP6_ROUTER_RENUMBERING_COMMAND);
    eval 'sub ICMP6_ROUTER_RENUMBERING_RESULT () {1;}' unless defined(&ICMP6_ROUTER_RENUMBERING_RESULT);
    eval 'sub ICMP6_ROUTER_RENUMBERING_SEQNUM_RESET () {255;}' unless defined(&ICMP6_ROUTER_RENUMBERING_SEQNUM_RESET);
    eval 'sub ND_REDIRECT_ONLINK () {0;}' unless defined(&ND_REDIRECT_ONLINK);
    eval 'sub ND_REDIRECT_ROUTER () {1;}' unless defined(&ND_REDIRECT_ROUTER);
    unless(defined(&_KERNEL)) {
	eval 'sub mld6_hdr () { &mld_hdr;}' unless defined(&mld6_hdr);
	eval 'sub mld6_type () { &mld_type;}' unless defined(&mld6_type);
	eval 'sub mld6_code () { &mld_code;}' unless defined(&mld6_code);
	eval 'sub mld6_cksum () { &mld_cksum;}' unless defined(&mld6_cksum);
	eval 'sub mld6_maxdelay () { &mld_maxdelay;}' unless defined(&mld6_maxdelay);
	eval 'sub mld6_reserved () { &mld_reserved;}' unless defined(&mld6_reserved);
	eval 'sub mld6_addr () { &mld_addr;}' unless defined(&mld6_addr);
    }
    eval 'sub mld_type () { ($mld_icmp6_hdr->{icmp6_type});}' unless defined(&mld_type);
    eval 'sub mld_code () { ($mld_icmp6_hdr->{icmp6_code});}' unless defined(&mld_code);
    eval 'sub mld_cksum () { ($mld_icmp6_hdr->{icmp6_cksum});}' unless defined(&mld_cksum);
    eval 'sub mld_maxdelay () { ($mld_icmp6_hdr->{icmp6_data16[0]});}' unless defined(&mld_maxdelay);
    eval 'sub mld_reserved () { ($mld_icmp6_hdr->{icmp6_data16[1]});}' unless defined(&mld_reserved);
    eval 'sub nd_rs_type () { ($nd_rs_hdr->{icmp6_type});}' unless defined(&nd_rs_type);
    eval 'sub nd_rs_code () { ($nd_rs_hdr->{icmp6_code});}' unless defined(&nd_rs_code);
    eval 'sub nd_rs_cksum () { ($nd_rs_hdr->{icmp6_cksum});}' unless defined(&nd_rs_cksum);
    eval 'sub nd_rs_reserved () { ($nd_rs_hdr->{icmp6_data32[0]});}' unless defined(&nd_rs_reserved);
    eval 'sub nd_ra_type () { ($nd_ra_hdr->{icmp6_type});}' unless defined(&nd_ra_type);
    eval 'sub nd_ra_code () { ($nd_ra_hdr->{icmp6_code});}' unless defined(&nd_ra_code);
    eval 'sub nd_ra_cksum () { ($nd_ra_hdr->{icmp6_cksum});}' unless defined(&nd_ra_cksum);
    eval 'sub nd_ra_curhoplimit () { ($nd_ra_hdr->{icmp6_data8[0]});}' unless defined(&nd_ra_curhoplimit);
    eval 'sub nd_ra_flags_reserved () { ($nd_ra_hdr->{icmp6_data8[1]});}' unless defined(&nd_ra_flags_reserved);
    eval 'sub ND_RA_FLAG_MANAGED () {0x80;}' unless defined(&ND_RA_FLAG_MANAGED);
    eval 'sub ND_RA_FLAG_OTHER () {0x40;}' unless defined(&ND_RA_FLAG_OTHER);
    eval 'sub nd_ra_router_lifetime () { ($nd_ra_hdr->{icmp6_data16[1]});}' unless defined(&nd_ra_router_lifetime);
    eval 'sub nd_ns_type () { ($nd_ns_hdr->{icmp6_type});}' unless defined(&nd_ns_type);
    eval 'sub nd_ns_code () { ($nd_ns_hdr->{icmp6_code});}' unless defined(&nd_ns_code);
    eval 'sub nd_ns_cksum () { ($nd_ns_hdr->{icmp6_cksum});}' unless defined(&nd_ns_cksum);
    eval 'sub nd_ns_reserved () { ($nd_ns_hdr->{icmp6_data32[0]});}' unless defined(&nd_ns_reserved);
    eval 'sub nd_na_type () { ($nd_na_hdr->{icmp6_type});}' unless defined(&nd_na_type);
    eval 'sub nd_na_code () { ($nd_na_hdr->{icmp6_code});}' unless defined(&nd_na_code);
    eval 'sub nd_na_cksum () { ($nd_na_hdr->{icmp6_cksum});}' unless defined(&nd_na_cksum);
    eval 'sub nd_na_flags_reserved () { ($nd_na_hdr->{icmp6_data32[0]});}' unless defined(&nd_na_flags_reserved);
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
	eval 'sub ND_NA_FLAG_ROUTER () {0x80000000;}' unless defined(&ND_NA_FLAG_ROUTER);
	eval 'sub ND_NA_FLAG_SOLICITED () {0x40000000;}' unless defined(&ND_NA_FLAG_SOLICITED);
	eval 'sub ND_NA_FLAG_OVERRIDE () {0x20000000;}' unless defined(&ND_NA_FLAG_OVERRIDE);
    } else {
	if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
	    eval 'sub ND_NA_FLAG_ROUTER () {0x80;}' unless defined(&ND_NA_FLAG_ROUTER);
	    eval 'sub ND_NA_FLAG_SOLICITED () {0x40;}' unless defined(&ND_NA_FLAG_SOLICITED);
	    eval 'sub ND_NA_FLAG_OVERRIDE () {0x20;}' unless defined(&ND_NA_FLAG_OVERRIDE);
	}
    }
    eval 'sub nd_rd_type () { ($nd_rd_hdr->{icmp6_type});}' unless defined(&nd_rd_type);
    eval 'sub nd_rd_code () { ($nd_rd_hdr->{icmp6_code});}' unless defined(&nd_rd_code);
    eval 'sub nd_rd_cksum () { ($nd_rd_hdr->{icmp6_cksum});}' unless defined(&nd_rd_cksum);
    eval 'sub nd_rd_reserved () { ($nd_rd_hdr->{icmp6_data32[0]});}' unless defined(&nd_rd_reserved);
    eval 'sub ND_OPT_SOURCE_LINKADDR () {1;}' unless defined(&ND_OPT_SOURCE_LINKADDR);
    eval 'sub ND_OPT_TARGET_LINKADDR () {2;}' unless defined(&ND_OPT_TARGET_LINKADDR);
    eval 'sub ND_OPT_PREFIX_INFORMATION () {3;}' unless defined(&ND_OPT_PREFIX_INFORMATION);
    eval 'sub ND_OPT_REDIRECTED_HEADER () {4;}' unless defined(&ND_OPT_REDIRECTED_HEADER);
    eval 'sub ND_OPT_MTU () {5;}' unless defined(&ND_OPT_MTU);
    eval 'sub ND_OPT_RDNSS () {25;}' unless defined(&ND_OPT_RDNSS);
    eval 'sub ND_OPT_DNSSL () {31;}' unless defined(&ND_OPT_DNSSL);
    eval 'sub ND_OPT_PI_FLAG_ONLINK () {0x80;}' unless defined(&ND_OPT_PI_FLAG_ONLINK);
    eval 'sub ND_OPT_PI_FLAG_AUTO () {0x40;}' unless defined(&ND_OPT_PI_FLAG_AUTO);
    if(0) {
    }
    eval 'sub ni_type () { ($icmp6_ni_hdr->{icmp6_type});}' unless defined(&ni_type);
    eval 'sub ni_code () { ($icmp6_ni_hdr->{icmp6_code});}' unless defined(&ni_code);
    eval 'sub ni_cksum () { ($icmp6_ni_hdr->{icmp6_cksum});}' unless defined(&ni_cksum);
    eval 'sub ni_qtype () { ($icmp6_ni_hdr->{icmp6_data16[0]});}' unless defined(&ni_qtype);
    eval 'sub ni_flags () { ($icmp6_ni_hdr->{icmp6_data16[1]});}' unless defined(&ni_flags);
    eval 'sub NI_QTYPE_NOOP () {0;}' unless defined(&NI_QTYPE_NOOP);
    eval 'sub NI_QTYPE_SUPTYPES () {1;}' unless defined(&NI_QTYPE_SUPTYPES);
    eval 'sub NI_QTYPE_FQDN () {2;}' unless defined(&NI_QTYPE_FQDN);
    eval 'sub NI_QTYPE_DNSNAME () {2;}' unless defined(&NI_QTYPE_DNSNAME);
    eval 'sub NI_QTYPE_NODEADDR () {3;}' unless defined(&NI_QTYPE_NODEADDR);
    eval 'sub NI_QTYPE_IPV4ADDR () {4;}' unless defined(&NI_QTYPE_IPV4ADDR);
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
	eval 'sub NI_SUPTYPE_FLAG_COMPRESS () {0x1;}' unless defined(&NI_SUPTYPE_FLAG_COMPRESS);
	eval 'sub NI_FQDN_FLAG_VALIDTTL () {0x1;}' unless defined(&NI_FQDN_FLAG_VALIDTTL);
    }
 elsif((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
	eval 'sub NI_SUPTYPE_FLAG_COMPRESS () {0x100;}' unless defined(&NI_SUPTYPE_FLAG_COMPRESS);
	eval 'sub NI_FQDN_FLAG_VALIDTTL () {0x100;}' unless defined(&NI_FQDN_FLAG_VALIDTTL);
    }
    if(defined(&NAME_LOOKUPS_04)) {
	if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
	    eval 'sub NI_NODEADDR_FLAG_LINKLOCAL () {0x1;}' unless defined(&NI_NODEADDR_FLAG_LINKLOCAL);
	    eval 'sub NI_NODEADDR_FLAG_SITELOCAL () {0x2;}' unless defined(&NI_NODEADDR_FLAG_SITELOCAL);
	    eval 'sub NI_NODEADDR_FLAG_GLOBAL () {0x4;}' unless defined(&NI_NODEADDR_FLAG_GLOBAL);
	    eval 'sub NI_NODEADDR_FLAG_ALL () {0x8;}' unless defined(&NI_NODEADDR_FLAG_ALL);
	    eval 'sub NI_NODEADDR_FLAG_TRUNCATE () {0x10;}' unless defined(&NI_NODEADDR_FLAG_TRUNCATE);
	    eval 'sub NI_NODEADDR_FLAG_ANYCAST () {0x20;}' unless defined(&NI_NODEADDR_FLAG_ANYCAST);
	}
 elsif((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
	    eval 'sub NI_NODEADDR_FLAG_LINKLOCAL () {0x100;}' unless defined(&NI_NODEADDR_FLAG_LINKLOCAL);
	    eval 'sub NI_NODEADDR_FLAG_SITELOCAL () {0x200;}' unless defined(&NI_NODEADDR_FLAG_SITELOCAL);
	    eval 'sub NI_NODEADDR_FLAG_GLOBAL () {0x400;}' unless defined(&NI_NODEADDR_FLAG_GLOBAL);
	    eval 'sub NI_NODEADDR_FLAG_ALL () {0x800;}' unless defined(&NI_NODEADDR_FLAG_ALL);
	    eval 'sub NI_NODEADDR_FLAG_TRUNCATE () {0x1000;}' unless defined(&NI_NODEADDR_FLAG_TRUNCATE);
	    eval 'sub NI_NODEADDR_FLAG_ANYCAST () {0x2000;}' unless defined(&NI_NODEADDR_FLAG_ANYCAST);
	}
    } else {
	if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
	    eval 'sub NI_NODEADDR_FLAG_TRUNCATE () {0x1;}' unless defined(&NI_NODEADDR_FLAG_TRUNCATE);
	    eval 'sub NI_NODEADDR_FLAG_ALL () {0x2;}' unless defined(&NI_NODEADDR_FLAG_ALL);
	    eval 'sub NI_NODEADDR_FLAG_COMPAT () {0x4;}' unless defined(&NI_NODEADDR_FLAG_COMPAT);
	    eval 'sub NI_NODEADDR_FLAG_LINKLOCAL () {0x8;}' unless defined(&NI_NODEADDR_FLAG_LINKLOCAL);
	    eval 'sub NI_NODEADDR_FLAG_SITELOCAL () {0x10;}' unless defined(&NI_NODEADDR_FLAG_SITELOCAL);
	    eval 'sub NI_NODEADDR_FLAG_GLOBAL () {0x20;}' unless defined(&NI_NODEADDR_FLAG_GLOBAL);
	    eval 'sub NI_NODEADDR_FLAG_ANYCAST () {0x40;}' unless defined(&NI_NODEADDR_FLAG_ANYCAST);
	}
 elsif((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
	    eval 'sub NI_NODEADDR_FLAG_TRUNCATE () {0x100;}' unless defined(&NI_NODEADDR_FLAG_TRUNCATE);
	    eval 'sub NI_NODEADDR_FLAG_ALL () {0x200;}' unless defined(&NI_NODEADDR_FLAG_ALL);
	    eval 'sub NI_NODEADDR_FLAG_COMPAT () {0x400;}' unless defined(&NI_NODEADDR_FLAG_COMPAT);
	    eval 'sub NI_NODEADDR_FLAG_LINKLOCAL () {0x800;}' unless defined(&NI_NODEADDR_FLAG_LINKLOCAL);
	    eval 'sub NI_NODEADDR_FLAG_SITELOCAL () {0x1000;}' unless defined(&NI_NODEADDR_FLAG_SITELOCAL);
	    eval 'sub NI_NODEADDR_FLAG_GLOBAL () {0x2000;}' unless defined(&NI_NODEADDR_FLAG_GLOBAL);
	    eval 'sub NI_NODEADDR_FLAG_ANYCAST () {0x4000;}' unless defined(&NI_NODEADDR_FLAG_ANYCAST);
	}
    }
    eval 'sub ICMP6_RR_FLAGS_TEST () {0x80;}' unless defined(&ICMP6_RR_FLAGS_TEST);
    eval 'sub ICMP6_RR_FLAGS_REQRESULT () {0x40;}' unless defined(&ICMP6_RR_FLAGS_REQRESULT);
    eval 'sub ICMP6_RR_FLAGS_FORCEAPPLY () {0x20;}' unless defined(&ICMP6_RR_FLAGS_FORCEAPPLY);
    eval 'sub ICMP6_RR_FLAGS_SPECSITE () {0x10;}' unless defined(&ICMP6_RR_FLAGS_SPECSITE);
    eval 'sub ICMP6_RR_FLAGS_PREVDONE () {0x8;}' unless defined(&ICMP6_RR_FLAGS_PREVDONE);
    eval 'sub rr_type () { ($rr_hdr->{icmp6_type});}' unless defined(&rr_type);
    eval 'sub rr_code () { ($rr_hdr->{icmp6_code});}' unless defined(&rr_code);
    eval 'sub rr_cksum () { ($rr_hdr->{icmp6_cksum});}' unless defined(&rr_cksum);
    eval 'sub rr_seqnum () { ($rr_hdr->{icmp6_data32[0]});}' unless defined(&rr_seqnum);
    eval 'sub RPM_PCO_ADD () {1;}' unless defined(&RPM_PCO_ADD);
    eval 'sub RPM_PCO_CHANGE () {2;}' unless defined(&RPM_PCO_CHANGE);
    eval 'sub RPM_PCO_SETGLOBAL () {3;}' unless defined(&RPM_PCO_SETGLOBAL);
    eval 'sub RPM_PCO_MAX () {4;}' unless defined(&RPM_PCO_MAX);
    eval 'sub ICMP6_RR_PCOUSE_RAFLAGS_ONLINK () {0x80;}' unless defined(&ICMP6_RR_PCOUSE_RAFLAGS_ONLINK);
    eval 'sub ICMP6_RR_PCOUSE_RAFLAGS_AUTO () {0x40;}' unless defined(&ICMP6_RR_PCOUSE_RAFLAGS_AUTO);
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
	eval 'sub ICMP6_RR_PCOUSE_FLAGS_DECRVLTIME () {0x80000000;}' unless defined(&ICMP6_RR_PCOUSE_FLAGS_DECRVLTIME);
	eval 'sub ICMP6_RR_PCOUSE_FLAGS_DECRPLTIME () {0x40000000;}' unless defined(&ICMP6_RR_PCOUSE_FLAGS_DECRPLTIME);
    }
 elsif((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
	eval 'sub ICMP6_RR_PCOUSE_FLAGS_DECRVLTIME () {0x80;}' unless defined(&ICMP6_RR_PCOUSE_FLAGS_DECRVLTIME);
	eval 'sub ICMP6_RR_PCOUSE_FLAGS_DECRPLTIME () {0x40;}' unless defined(&ICMP6_RR_PCOUSE_FLAGS_DECRPLTIME);
    }
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
	eval 'sub ICMP6_RR_RESULT_FLAGS_OOB () {0x2;}' unless defined(&ICMP6_RR_RESULT_FLAGS_OOB);
	eval 'sub ICMP6_RR_RESULT_FLAGS_FORBIDDEN () {0x1;}' unless defined(&ICMP6_RR_RESULT_FLAGS_FORBIDDEN);
    }
 elsif((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
	eval 'sub ICMP6_RR_RESULT_FLAGS_OOB () {0x200;}' unless defined(&ICMP6_RR_RESULT_FLAGS_OOB);
	eval 'sub ICMP6_RR_RESULT_FLAGS_FORBIDDEN () {0x100;}' unless defined(&ICMP6_RR_RESULT_FLAGS_FORBIDDEN);
    }
    if(defined(&_KERNEL)) {
	eval 'sub ICMP6_FILTER_SETPASSALL {
	    my($filterp) = @_;
    	    eval q( &do { \'int\'  &i; \'u_char\' * &p;  &p = $filterp;  &for ( &i = 0;  &i < $sizeof{\'struct icmp6_filter\'};  &i++)  $p[ &i] = 0xff; }  &while (0));
	}' unless defined(&ICMP6_FILTER_SETPASSALL);
	eval 'sub ICMP6_FILTER_SETBLOCKALL {
	    my($filterp) = @_;
    	    eval q( &bzero($filterp, $sizeof{\'struct icmp6_filter\'}));
	}' unless defined(&ICMP6_FILTER_SETBLOCKALL);
    } else {
	eval 'sub ICMP6_FILTER_SETPASSALL {
	    my($filterp) = @_;
    	    eval q( &memset($filterp, 0xff, $sizeof{\'struct icmp6_filter\'}));
	}' unless defined(&ICMP6_FILTER_SETPASSALL);
	eval 'sub ICMP6_FILTER_SETBLOCKALL {
	    my($filterp) = @_;
    	    eval q( &memset($filterp, 0x, $sizeof{\'struct icmp6_filter\'}));
	}' unless defined(&ICMP6_FILTER_SETBLOCKALL);
    }
    eval 'sub ICMP6_FILTER_SETPASS {
        my($type, $filterp) = @_;
	    eval q(((($filterp)-> $icmp6_filt[($type) >> 5]) |= (1<< (($type) & 31))));
    }' unless defined(&ICMP6_FILTER_SETPASS);
    eval 'sub ICMP6_FILTER_SETBLOCK {
        my($type, $filterp) = @_;
	    eval q(((($filterp)-> $icmp6_filt[($type) >> 5]) &= ~(1<< (($type) & 31))));
    }' unless defined(&ICMP6_FILTER_SETBLOCK);
    eval 'sub ICMP6_FILTER_WILLPASS {
        my($type, $filterp) = @_;
	    eval q((((($filterp)-> $icmp6_filt[($type) >> 5]) & (1<< (($type) & 31))) != 0));
    }' unless defined(&ICMP6_FILTER_WILLPASS);
    eval 'sub ICMP6_FILTER_WILLBLOCK {
        my($type, $filterp) = @_;
	    eval q((((($filterp)-> $icmp6_filt[($type) >> 5]) & (1<< (($type) & 31))) == 0));
    }' unless defined(&ICMP6_FILTER_WILLBLOCK);
    eval 'sub icp6s_odst_unreach_noroute () { ($icp6s_outerrhist->{icp6errs_dst_unreach_noroute});}' unless defined(&icp6s_odst_unreach_noroute);
    eval 'sub icp6s_odst_unreach_admin () { ($icp6s_outerrhist->{icp6errs_dst_unreach_admin});}' unless defined(&icp6s_odst_unreach_admin);
    eval 'sub icp6s_odst_unreach_beyondscope () { ($icp6s_outerrhist->{icp6errs_dst_unreach_beyondscope});}' unless defined(&icp6s_odst_unreach_beyondscope);
    eval 'sub icp6s_odst_unreach_addr () { ($icp6s_outerrhist->{icp6errs_dst_unreach_addr});}' unless defined(&icp6s_odst_unreach_addr);
    eval 'sub icp6s_odst_unreach_noport () { ($icp6s_outerrhist->{icp6errs_dst_unreach_noport});}' unless defined(&icp6s_odst_unreach_noport);
    eval 'sub icp6s_opacket_too_big () { ($icp6s_outerrhist->{icp6errs_packet_too_big});}' unless defined(&icp6s_opacket_too_big);
    eval 'sub icp6s_otime_exceed_transit () { ($icp6s_outerrhist->{icp6errs_time_exceed_transit});}' unless defined(&icp6s_otime_exceed_transit);
    eval 'sub icp6s_otime_exceed_reassembly () { ($icp6s_outerrhist->{icp6errs_time_exceed_reassembly});}' unless defined(&icp6s_otime_exceed_reassembly);
    eval 'sub icp6s_oparamprob_header () { ($icp6s_outerrhist->{icp6errs_paramprob_header});}' unless defined(&icp6s_oparamprob_header);
    eval 'sub icp6s_oparamprob_nextheader () { ($icp6s_outerrhist->{icp6errs_paramprob_nextheader});}' unless defined(&icp6s_oparamprob_nextheader);
    eval 'sub icp6s_oparamprob_option () { ($icp6s_outerrhist->{icp6errs_paramprob_option});}' unless defined(&icp6s_oparamprob_option);
    eval 'sub icp6s_oredirect () { ($icp6s_outerrhist->{icp6errs_redirect});}' unless defined(&icp6s_oredirect);
    eval 'sub icp6s_ounknown () { ($icp6s_outerrhist->{icp6errs_unknown});}' unless defined(&icp6s_ounknown);
    eval 'sub ICMPV6CTL_STATS () {1;}' unless defined(&ICMPV6CTL_STATS);
    eval 'sub ICMPV6CTL_REDIRACCEPT () {2;}' unless defined(&ICMPV6CTL_REDIRACCEPT);
    eval 'sub ICMPV6CTL_REDIRTIMEOUT () {3;}' unless defined(&ICMPV6CTL_REDIRTIMEOUT);
    if(0) {
	eval 'sub ICMPV6CTL_ERRRATELIMIT () {5;}' unless defined(&ICMPV6CTL_ERRRATELIMIT);
    }
    eval 'sub ICMPV6CTL_ND6_PRUNE () {6;}' unless defined(&ICMPV6CTL_ND6_PRUNE);
    eval 'sub ICMPV6CTL_ND6_DELAY () {8;}' unless defined(&ICMPV6CTL_ND6_DELAY);
    eval 'sub ICMPV6CTL_ND6_UMAXTRIES () {9;}' unless defined(&ICMPV6CTL_ND6_UMAXTRIES);
    eval 'sub ICMPV6CTL_ND6_MMAXTRIES () {10;}' unless defined(&ICMPV6CTL_ND6_MMAXTRIES);
    eval 'sub ICMPV6CTL_ND6_USELOOPBACK () {11;}' unless defined(&ICMPV6CTL_ND6_USELOOPBACK);
    eval 'sub ICMPV6CTL_NODEINFO () {13;}' unless defined(&ICMPV6CTL_NODEINFO);
    eval 'sub ICMPV6CTL_ERRPPSLIMIT () {14;}' unless defined(&ICMPV6CTL_ERRPPSLIMIT);
    eval 'sub ICMPV6CTL_ND6_MAXNUDHINT () {15;}' unless defined(&ICMPV6CTL_ND6_MAXNUDHINT);
    eval 'sub ICMPV6CTL_MTUDISC_HIWAT () {16;}' unless defined(&ICMPV6CTL_MTUDISC_HIWAT);
    eval 'sub ICMPV6CTL_MTUDISC_LOWAT () {17;}' unless defined(&ICMPV6CTL_MTUDISC_LOWAT);
    eval 'sub ICMPV6CTL_ND6_DEBUG () {18;}' unless defined(&ICMPV6CTL_ND6_DEBUG);
    eval 'sub ICMPV6CTL_ND6_DRLIST () {19;}' unless defined(&ICMPV6CTL_ND6_DRLIST);
    eval 'sub ICMPV6CTL_ND6_PRLIST () {20;}' unless defined(&ICMPV6CTL_ND6_PRLIST);
    eval 'sub ICMPV6CTL_MAXID () {21;}' unless defined(&ICMPV6CTL_MAXID);
    eval 'sub ICMPV6CTL_NAMES () {{ { 0, 0}, { 0, 0}, { "rediraccept",  &CTLTYPE_INT }, { "redirtimeout",  &CTLTYPE_INT }, { 0, 0}, { 0, 0}, { "nd6_prune",  &CTLTYPE_INT }, { 0, 0}, { "nd6_delay",  &CTLTYPE_INT }, { "nd6_umaxtries",  &CTLTYPE_INT }, { "nd6_mmaxtries",  &CTLTYPE_INT }, { "nd6_useloopback",  &CTLTYPE_INT }, { 0, 0}, { "nodeinfo",  &CTLTYPE_INT }, { "errppslimit",  &CTLTYPE_INT }, { "nd6_maxnudhint",  &CTLTYPE_INT }, { "mtudisc_hiwat",  &CTLTYPE_INT }, { "mtudisc_lowat",  &CTLTYPE_INT }, { "nd6_debug",  &CTLTYPE_INT }, { 0, 0}, { 0, 0}, };}' unless defined(&ICMPV6CTL_NAMES);
    eval 'sub ICMPV6CTL_VARS () {{  &NULL,  &NULL,  &icmp6_rediraccept,  &icmp6_redirtimeout,  &NULL,  &NULL,  &nd6_prune,  &NULL,  &nd6_delay,  &nd6_umaxtries,  &nd6_mmaxtries,  &nd6_useloopback,  &NULL,  &icmp6_nodeinfo,  &icmp6errppslim,  &nd6_maxnudhint,  &icmp6_mtudisc_hiwat,  &icmp6_mtudisc_lowat,  &nd6_debug,  &NULL,  &NULL, };}' unless defined(&ICMPV6CTL_VARS);
    eval 'sub RTF_PROBEMTU () { &RTF_PROTO1;}' unless defined(&RTF_PROBEMTU);
    if(defined(&_KERNEL)) {
	if(defined(&__STDC__)) {
	}
	eval 'sub icmp6_ifstat_inc {
	    my($ifp, $tag) = @_;
    	    eval q( &do {  &if ($ifp) ((($ifp)-> $if_afdata[ &AF_INET6]))-> ($icmp6_ifstat->{tag})++; }  &while (0));
	}' unless defined(&icmp6_ifstat_inc);
	eval 'sub icmp6_ifoutstat_inc {
	    my($ifp, $type, $code) = @_;
    	    eval q( &do {  &icmp6_ifstat_inc($ifp,  &ifs6_out_msg);  &switch($type) {  &case  &ICMP6_DST_UNREACH:  &icmp6_ifstat_inc($ifp,  &ifs6_out_dstunreach);  &if ($code ==  &ICMP6_DST_UNREACH_ADMIN)  &icmp6_ifstat_inc($ifp,  &ifs6_out_adminprohib);  &break;  &case  &ICMP6_PACKET_TOO_BIG:  &icmp6_ifstat_inc($ifp,  &ifs6_out_pkttoobig);  &break;  &case  &ICMP6_TIME_EXCEEDED:  &icmp6_ifstat_inc($ifp,  &ifs6_out_timeexceed);  &break;  &case  &ICMP6_PARAM_PROB:  &icmp6_ifstat_inc($ifp,  &ifs6_out_paramprob);  &break;  &case  &ICMP6_ECHO_REQUEST:  &icmp6_ifstat_inc($ifp,  &ifs6_out_echo);  &break;  &case  &ICMP6_ECHO_REPLY:  &icmp6_ifstat_inc($ifp,  &ifs6_out_echoreply);  &break;  &case  &MLD_LISTENER_QUERY:  &icmp6_ifstat_inc($ifp,  &ifs6_out_mldquery);  &break;  &case  &MLD_LISTENER_REPORT:  &icmp6_ifstat_inc($ifp,  &ifs6_out_mldreport);  &break;  &case  &MLD_LISTENER_DONE:  &icmp6_ifstat_inc($ifp,  &ifs6_out_mlddone);  &break;  &case  &ND_ROUTER_SOLICIT:  &icmp6_ifstat_inc($ifp,  &ifs6_out_routersolicit);  &break;  &case  &ND_ROUTER_ADVERT:  &icmp6_ifstat_inc($ifp,  &ifs6_out_routeradvert);  &break;  &case  &ND_NEIGHBOR_SOLICIT:  &icmp6_ifstat_inc($ifp,  &ifs6_out_neighborsolicit);  &break;  &case  &ND_NEIGHBOR_ADVERT:  &icmp6_ifstat_inc($ifp,  &ifs6_out_neighboradvert);  &break;  &case  &ND_REDIRECT:  &icmp6_ifstat_inc($ifp,  &ifs6_out_redirect);  &break; } }  &while (0));
	}' unless defined(&icmp6_ifoutstat_inc);
    }
}
1;
