/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.services.messaging.ThrottleManagerControl;
import flex.messaging.MessageException;
import flex.messaging.config.ThrottleSettings;
import flex.messaging.messages.Message;
import java.util.HashMap;
import java.util.Map;

public class ThrottleManager
extends ManageableComponent {
    public static final String LOG_CATEGORY = "Service.Message";
    public static final String TYPE = "ThrottleManager";
    private static final Object classMutex = new Object();
    private static int instanceCount = 0;
    private Map inboundClientMarks;
    private Map outboundClientMarks;
    private ThrottleMark inboundDestinationMark;
    private ThrottleMark outboundDestinationMark;
    private ThrottleSettings settings;
    public static final int RESULT_OK = 0;
    public static final int RESULT_IGNORE = 1;
    public static final int RESULT_REPLACE = 2;
    public static final int RESULT_ERROR = 3;
    static final int MESSAGE_HISTORY_SIZE = 15;

    public ThrottleManager() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThrottleManager(boolean enableManagement) {
        super(enableManagement);
        Object object = classMutex;
        synchronized (object) {
            super.setId(TYPE + ++instanceCount);
        }
        this.settings = new ThrottleSettings();
    }

    public void setId(String id) {
    }

    public void setThrottleSettings(ThrottleSettings throttleSettings) {
        this.settings = throttleSettings;
        if (this.settings.isDestinationThrottleEnabled()) {
            this.inboundDestinationMark = new ThrottleMark(this.settings.getDestinationName());
            this.outboundDestinationMark = new ThrottleMark(this.settings.getDestinationName());
        }
        if (this.settings.isClientThrottleEnabled()) {
            this.inboundClientMarks = new HashMap();
            this.outboundClientMarks = new HashMap();
        }
    }

    public int throttleIncomingMessage(Message msg) {
        int n = 0;
        if (this.settings.getInboundPolicy() != 0 && (n = this.throttleDestinationLevel(msg, true)) == 0) {
            n = this.throttleClientLevel(msg, msg.getClientId(), true);
        }
        return n;
    }

    public int throttleOutgoingMessage(Message msg, Object clientId) {
        int n = 0;
        if (this.settings.getOutboundPolicy() != 0) {
            n = clientId == null ? this.throttleDestinationLevel(msg, false) : this.throttleClientLevel(msg, clientId, false);
        }
        return n;
    }

    private int throttleDestinationLevel(Message msg, boolean incoming) {
        int throttleResult = 0;
        if (this.settings.isDestinationThrottleEnabled()) {
            if (incoming) {
                try {
                    this.inboundDestinationMark.assertValid(msg, this.settings.getIncomingDestinationFrequency());
                }
                catch (RuntimeException e) {
                    String s = "Message throttled: Too many messages sent to destination " + this.inboundDestinationMark.id + " in too small of a time interval.  " + e.getMessage();
                    MessageException me = new MessageException(s);
                    try {
                        throttleResult = this.handleError(this.settings.getInboundPolicy(), me);
                    }
                    catch (MessageException m) {
                        throttleResult = 3;
                        throw m;
                    }
                    finally {
                        if (throttleResult != 0 && this.isManaged()) {
                            ((ThrottleManagerControl)this.getControl()).incrementDestinationIncomingMessageThrottleCount();
                        }
                    }
                }
            } else {
                try {
                    this.outboundDestinationMark.assertValid(msg, this.settings.getOutgoingDestinationFrequency());
                }
                catch (RuntimeException e) {
                    String s = "Message throttled: Too many messages routed by destination " + this.outboundDestinationMark.id + " in too small of a time interval";
                    MessageException me = new MessageException(s);
                    try {
                        throttleResult = this.handleError(this.settings.getOutboundPolicy(), me);
                    }
                    catch (MessageException m) {
                        throttleResult = 3;
                        throw m;
                    }
                    finally {
                        if (throttleResult != 0 && this.isManaged()) {
                            ((ThrottleManagerControl)this.getControl()).incrementDestinationOutgoingMessageThrottleCount();
                        }
                    }
                }
            }
        }
        return throttleResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int throttleClientLevel(Message msg, Object clientId, boolean incoming) {
        int throttleResult = 0;
        if (this.settings.isClientThrottleEnabled()) {
            ThrottleMark clientLevelMark = null;
            if (incoming) {
                clientLevelMark = this.inboundClientMarks.get(clientId) != null ? (ThrottleMark)this.inboundClientMarks.get(clientId) : new ThrottleMark(clientId);
                try {
                    clientLevelMark.assertValid(msg, this.settings.getIncomingClientFrequency());
                }
                catch (RuntimeException e) {
                    String s = "Message throttled: Too many messages sent by client " + clientId + " in too small of a time interval";
                    MessageException me = new MessageException(s);
                    try {
                        throttleResult = this.handleError(this.settings.getInboundPolicy(), me);
                    }
                    catch (MessageException m) {
                        throttleResult = 3;
                        throw m;
                    }
                    finally {
                        if (throttleResult != 0 && this.isManaged()) {
                            ((ThrottleManagerControl)this.getControl()).incrementClientIncomingMessageThrottleCount();
                        }
                    }
                }
                finally {
                    this.inboundClientMarks.put(clientId, clientLevelMark);
                }
            } else {
                clientLevelMark = this.outboundClientMarks.get(clientId) != null ? (ThrottleMark)this.outboundClientMarks.get(clientId) : new ThrottleMark(clientId);
                try {
                    clientLevelMark.assertValid(msg, this.settings.getOutgoingClientFrequency());
                }
                catch (RuntimeException e) {
                    String s = "Message throttled: Too many messages sent to client " + clientId + " in too small of a time interval";
                    MessageException me = new MessageException(s);
                    try {
                        throttleResult = this.handleError(this.settings.getOutboundPolicy(), me);
                    }
                    catch (MessageException m) {
                        throttleResult = 3;
                        throw m;
                    }
                    finally {
                        if (throttleResult != 0 && this.isManaged()) {
                            ((ThrottleManagerControl)this.getControl()).incrementClientOutgoingMessageThrottleCount();
                        }
                    }
                }
                finally {
                    this.outboundClientMarks.put(clientId, clientLevelMark);
                }
            }
        }
        return throttleResult;
    }

    private int handleError(int policy, MessageException e) {
        int n = 0;
        switch (policy) {
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 1: {
                throw e;
            }
        }
        return n;
    }

    public void removeClientThrottleMark(Object clientId) {
        if (this.inboundClientMarks != null) {
            this.inboundClientMarks.remove(clientId);
        }
        if (this.outboundClientMarks != null) {
            this.outboundClientMarks.remove(clientId);
        }
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    class ThrottleMark {
        Object id;
        int messageCount;
        String lastMessageId;
        long[] lastMessageTimes;

        ThrottleMark(Object identifier) {
            this.id = identifier;
            this.messageCount = 0;
            this.lastMessageId = "-1";
            this.lastMessageTimes = new long[15];
        }

        void assertValid(Message msg, int frequency) {
            if (frequency > 0) {
                long interval;
                long rate;
                int len = this.lastMessageTimes.length;
                if (this.messageCount >= len && (rate = (long)(1000 * len) / (interval = msg.getTimestamp() - this.lastMessageTimes[(this.messageCount - len) % len])) > (long)frequency) {
                    throw new RuntimeException("actual frequency=" + rate + " max frequency=" + frequency);
                }
                this.lastMessageId = msg.getMessageId();
                this.lastMessageTimes[this.messageCount++ % len] = msg.getTimestamp();
            }
        }
    }
}

