/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.util.HashSet;
import org.h2.constraint.Constraint;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Schema;
import org.h2.engine.Session;
import org.h2.index.BtreeIndex;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinearHashIndex;
import org.h2.index.ScanIndex;
import org.h2.index.TreeIndex;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.store.DataPage;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class TableData
extends Table
implements RecordReader {
    private ScanIndex scanIndex;
    private int rowCount;
    private Session lockExclusive;
    private HashSet lockShared = new HashSet();
    private Trace traceLock;
    private boolean globalTemporary;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private ObjectArray indexes = new ObjectArray();

    public TableData(Schema schema, String tableName, int id, ObjectArray columns, boolean persistent) throws SQLException {
        super(schema, id, tableName, persistent);
        Object[] cols = new Column[columns.size()];
        columns.toArray(cols);
        this.setColumns((Column[])cols);
        this.scanIndex = new ScanIndex(this, id, (Column[])cols, IndexType.createScan(persistent));
        this.indexes.add(this.scanIndex);
        this.traceLock = this.database.getTrace("lock");
    }

    public void close(Session session) throws SQLException {
        for (int i = 0; i < this.indexes.size(); ++i) {
            Index index = (Index)this.indexes.get(i);
            index.close(session);
        }
    }

    public Row getRow(int key) throws SQLException {
        return this.scanIndex.getRow(key);
    }

    public void addRow(Session session, Row row) throws SQLException {
        int i;
        try {
            for (i = 0; i < this.indexes.size(); ++i) {
                int rc;
                Index index = (Index)this.indexes.get(i);
                index.add(session, row);
                if (!Constants.CHECK || (rc = index.getRowCount()) == this.rowCount + 1) continue;
                throw Message.internal("rowCount expected " + (this.rowCount + 1) + " got " + rc);
            }
            ++this.rowCount;
        }
        catch (SQLException e) {
            while (--i >= 0) {
                int rc;
                Index index = (Index)this.indexes.get(i);
                index.remove(session, row);
                if (!Constants.CHECK || (rc = index.getRowCount()) == this.rowCount) continue;
                throw Message.internal("rowCount expected " + this.rowCount + " got " + rc);
            }
            throw e;
        }
    }

    public Index getScanIndex(Session session) {
        return (Index)this.indexes.get(0);
    }

    public ObjectArray getIndexes() {
        return this.indexes;
    }

    public Index addIndex(Session session, String indexName, int indexId, Column[] cols, IndexType indexType, int headPos) throws SQLException {
        if (indexType.isPrimaryKey()) {
            indexName = this.getSchema().getUniqueIndexName("PRIMARY_KEY_");
            for (int i = 0; i < cols.length; ++i) {
                Column column = cols[i];
                if (!column.isNullable()) continue;
                throw Message.getSQLException(90023, column.getName());
            }
        }
        Index index = this.isPersistent() && indexType.isPersistent() ? (indexType.isHash() ? new LinearHashIndex(session, this, indexId, indexName, cols, indexType) : new BtreeIndex(session, this, indexId, indexName, cols, indexType, headPos)) : (indexType.isHash() ? new HashIndex(this, indexId, indexName, cols, indexType) : new TreeIndex(this, indexId, indexName, cols, indexType));
        if (index.needRebuild()) {
            try {
                int remaining;
                Index scan = this.getScanIndex(session);
                int total = remaining = scan.getRowCount();
                Cursor cursor = scan.find(session, null, null);
                int i = 0;
                while (cursor.next()) {
                    this.database.setProgress(1, this.getName(), i++, total);
                    Row row = cursor.get();
                    index.add(session, row);
                    --remaining;
                }
                if (Constants.CHECK && remaining != 0) {
                    throw Message.internal("rowcount remaining=" + remaining);
                }
            }
            catch (SQLException e) {
                index.remove(session);
                throw e;
            }
        }
        boolean temporary = this.getTemporary();
        index.setTemporary(temporary);
        if (index.getCreateSQL() != null) {
            this.database.addSchemaObject(session, index);
        }
        this.indexes.add(index);
        this.setModified();
        return index;
    }

    public boolean canGetRowCount() {
        return true;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void removeRow(Session session, Row row) throws SQLException {
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            int rc;
            Index index = (Index)this.indexes.get(i);
            index.remove(session, row);
            if (!Constants.CHECK || (rc = index.getRowCount()) == this.rowCount - 1) continue;
            throw Message.internal("rowCount expected " + (this.rowCount - 1) + " got " + rc);
        }
        --this.rowCount;
    }

    public void truncate(Session session) throws SQLException {
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            int rc;
            Index index = (Index)this.indexes.get(i);
            index.truncate(session);
            if (!Constants.CHECK || (rc = index.getRowCount()) == 0) continue;
            throw Message.internal("rowCount expected 0 got " + rc);
        }
        this.rowCount = 0;
    }

    public void lock(Session session, boolean exclusive) throws SQLException {
        if (this.database.getLockMode() == 0) {
            return;
        }
        long max = System.currentTimeMillis() + (long)session.getLockTimeout();
        Database database = this.database;
        synchronized (database) {
            block5: while (true) {
                while (true) {
                    long now;
                    if (this.lockExclusive == session) {
                        return;
                    }
                    if (exclusive) {
                        if (this.lockExclusive == null) {
                            if (this.lockShared.isEmpty()) {
                                this.traceLock(session, exclusive, "ok");
                                session.addLock(this);
                                this.lockExclusive = session;
                                return;
                            }
                            if (this.lockShared.size() == 1 && this.lockShared.contains(session)) {
                                this.traceLock(session, exclusive, "ok (upgrade)");
                                this.lockExclusive = session;
                                return;
                            }
                        }
                    } else if (this.lockExclusive == null) {
                        if (!this.lockShared.contains(session)) {
                            this.traceLock(session, exclusive, "ok");
                            session.addLock(this);
                            this.lockShared.add(session);
                        }
                        return;
                    }
                    if ((now = System.currentTimeMillis()) >= max) {
                        this.traceLock(session, exclusive, "timeout " + session.getLockTimeout());
                        throw Message.getSQLException(50200, this.getName());
                    }
                    try {
                        this.traceLock(session, exclusive, "waiting");
                        if (this.database.getLockMode() == 2) {
                            for (int i = 0; i < 20; ++i) {
                                long free = Runtime.getRuntime().freeMemory();
                                System.gc();
                                long free2 = Runtime.getRuntime().freeMemory();
                                if (free == free2) break;
                            }
                        }
                        this.database.wait(max - now);
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private void traceLock(Session session, boolean exclusive, String s) {
        if (this.traceLock.debug()) {
            this.traceLock.debug(session.getId() + " " + (exclusive ? "xlock" : "slock") + " " + s + " " + this.getName());
        }
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE ");
        if (this.getTemporary()) {
            if (this.globalTemporary) {
                buff.append("GLOBAL ");
            }
            buff.append("TEMPORARY ");
        } else if (this.isPersistent()) {
            buff.append("CACHED ");
        } else {
            buff.append("MEMORY ");
        }
        buff.append("TABLE ");
        buff.append(this.getSQL());
        buff.append('(');
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(column.getCreateSQL());
        }
        buff.append(")");
        return buff.toString();
    }

    public boolean isLockedExclusively() {
        return this.lockExclusive != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Session s) {
        if (this.database != null) {
            this.traceLock(s, this.lockExclusive == s, "unlock");
            if (this.lockExclusive == s) {
                this.lockExclusive = null;
            }
            this.lockShared.remove(s);
            Database database = this.database;
            synchronized (database) {
                this.database.notifyAll();
            }
        }
    }

    public Record read(DataPage s) throws SQLException {
        int len = s.readInt();
        Value[] data = new Value[len];
        for (int i = 0; i < len; ++i) {
            data[i] = s.readValue();
        }
        return new Row(data);
    }

    public void setRowCount(int count) {
        this.rowCount = count;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = (Index)this.indexes.get(1);
            if (index.getName() == null) continue;
            this.database.removeSchemaObject(session, index);
        }
        if (Constants.CHECK) {
            ObjectArray list = this.database.getAllSchemaObjects(1);
            for (int i = 0; i < list.size(); ++i) {
                Index index = (Index)list.get(i);
                if (index.getTable() != this) continue;
                throw Message.internal("index not dropped: " + index.getName());
            }
        }
        this.scanIndex.remove(session);
        this.scanIndex = null;
        this.lockExclusive = null;
        this.lockShared = null;
        this.invalidate();
    }

    public void checkRename() throws SQLException {
    }

    public void checkSupportAlter() throws SQLException {
    }

    public boolean canTruncate() {
        ObjectArray constraints = this.getConstraints();
        for (int i = 0; constraints != null && i < constraints.size(); ++i) {
            Constraint c = (Constraint)constraints.get(i);
            if (!c.getConstraintType().equals("REFERENTIAL")) continue;
            return false;
        }
        return true;
    }

    public String getTableType() {
        return "TABLE";
    }

    public void setGlobalTemporary(boolean globalTemporary) {
        this.globalTemporary = globalTemporary;
    }

    public boolean getGlobalTemporary() {
        return this.globalTemporary;
    }

    public boolean isOnCommitDrop() {
        return this.onCommitDrop;
    }

    public void setOnCommitDrop(boolean onCommitDrop) {
        this.onCommitDrop = onCommitDrop;
    }

    public boolean isOnCommitTruncate() {
        return this.onCommitTruncate;
    }

    public void setOnCommitTruncate(boolean onCommitTruncate) {
        this.onCommitTruncate = onCommitTruncate;
    }
}

