/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.text.extraction;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hwpf.model.CHPBinTable;
import org.apache.poi.hwpf.model.CHPX;
import org.apache.poi.hwpf.model.ComplexFileTable;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;
import org.textmining.text.extraction.FastSavedException;
import org.textmining.text.extraction.PasswordProtectedException;
import org.textmining.text.extraction.Word6Extractor;
import org.textmining.text.extraction.WordTextBuffer;
import org.textmining.text.extraction.sprm.SprmIterator;
import org.textmining.text.extraction.sprm.SprmOperation;

public class WordExtractor {
    public String extractText(InputStream inputStream) throws Exception {
        ArrayList arrayList = new ArrayList();
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(inputStream);
        DocumentEntry documentEntry = (DocumentEntry)pOIFSFileSystem.getRoot().getEntry("WordDocument");
        DocumentInputStream documentInputStream = pOIFSFileSystem.createDocumentInputStream("WordDocument");
        byte[] byArray = new byte[documentEntry.getSize()];
        documentInputStream.read(byArray);
        documentInputStream.close();
        short s = LittleEndian.getShort(byArray, 10);
        if ((s & 4) != 0) {
            throw new FastSavedException("Fast-saved files are unsupported at this time");
        }
        if ((s & 0x100) != 0) {
            throw new PasswordProtectedException("This document is password protected");
        }
        short s2 = LittleEndian.getShort(byArray, 2);
        switch (s2) {
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                Word6Extractor word6Extractor = new Word6Extractor();
                return word6Extractor.extractText(byArray);
            }
        }
        boolean bl = (s & 0x200) != 0;
        int n = LittleEndian.getInt(byArray, 418);
        String string = null;
        string = bl ? "1Table" : "0Table";
        DocumentEntry documentEntry2 = (DocumentEntry)pOIFSFileSystem.getRoot().getEntry(string);
        byte[] byArray2 = new byte[documentEntry2.getSize()];
        documentInputStream = pOIFSFileSystem.createDocumentInputStream(string);
        documentInputStream.read(byArray2);
        documentInputStream.close();
        int n2 = LittleEndian.getInt(byArray, 250);
        int n3 = LittleEndian.getInt(byArray, 254);
        int n4 = LittleEndian.getInt(byArray, 24);
        CHPBinTable cHPBinTable = new CHPBinTable(byArray, byArray2, n2, n3, n4);
        ComplexFileTable complexFileTable = new ComplexFileTable(byArray, byArray2, n, n4);
        TextPieceTable textPieceTable = complexFileTable.getTextPieceTable();
        List list = textPieceTable.getTextPieces();
        documentInputStream = null;
        pOIFSFileSystem = null;
        documentEntry2 = null;
        documentEntry = null;
        List list2 = cHPBinTable.getTextRuns();
        Iterator iterator = list2.iterator();
        Iterator iterator2 = list.iterator();
        TextPiece textPiece = (TextPiece)iterator2.next();
        int n5 = textPiece.getStart();
        int n6 = textPiece.getEnd();
        WordTextBuffer wordTextBuffer = new WordTextBuffer();
        while (iterator.hasNext()) {
            String string2;
            CHPX cHPX = (CHPX)iterator.next();
            boolean bl2 = this.isDeleted(cHPX.getGrpprl());
            if (bl2) continue;
            int n7 = cHPX.getStart();
            int n8 = cHPX.getEnd();
            while (n7 >= n6) {
                textPiece = (TextPiece)iterator2.next();
                n5 = textPiece.getStart();
                n6 = textPiece.getEnd();
            }
            if (n8 < n6) {
                string2 = textPiece.substring(n7 - n5, n8 - n5);
                wordTextBuffer.append(string2);
                continue;
            }
            if (n8 > n6) {
                while (n8 > n6) {
                    string2 = textPiece.substring(n7 - n5, n6 - n5);
                    wordTextBuffer.append(string2);
                    if (iterator2.hasNext()) {
                        textPiece = (TextPiece)iterator2.next();
                        n7 = n5 = textPiece.getStart();
                        n6 = textPiece.getEnd();
                        continue;
                    }
                    return wordTextBuffer.toString();
                }
                string2 = textPiece.substring(0, n8 - n5);
                wordTextBuffer.append(string2);
                continue;
            }
            string2 = textPiece.substring(n7 - n5, n8 - n5);
            if (iterator2.hasNext()) {
                textPiece = (TextPiece)iterator2.next();
                n5 = textPiece.getStart();
                n6 = textPiece.getEnd();
            }
            wordTextBuffer.append(string2);
        }
        return wordTextBuffer.toString();
    }

    private boolean isDeleted(byte[] byArray) {
        SprmIterator sprmIterator = new SprmIterator(byArray);
        while (sprmIterator.hasNext()) {
            SprmOperation sprmOperation = sprmIterator.next();
            if (sprmOperation.getOperation() != 0 || sprmOperation.getOperand() == 0) continue;
            return true;
        }
        return false;
    }
}

