<?php
/**
 * This file is used to set configuration options to a default value that have 
 * not been set in the config.php.Each definition of a configuration value must 
 * be preceeded by "if(!defined('KEY'))"
 */

if(!defined('DEBUG_LOADER')) define('DEBUG_LOADER', LOAD_RELEASE);

if(!defined('UPLOADED_ATTACHMENT_MAX_LIFETIME')) define('UPLOADED_ATTACHMENT_MAX_LIFETIME', 6*60*60);
if(!defined('DISABLE_FULL_CONTACTLIST_THRESHOLD')) define('DISABLE_FULL_CONTACTLIST_THRESHOLD', -1);
if(!defined('ENABLE_PUBLIC_FOLDERS')) define('ENABLE_PUBLIC_FOLDERS', true);

/**
 * When set to true this disables the fitlering of the HTML body.
 */
if(!defined('DISABLE_HTMLBODY_FILTER')) define('DISABLE_HTMLBODY_FILTER', false);
/**
 * When set to true this disables the login with the REMOTE_USER set by apache.
 */
if(!defined('DISABLE_REMOTE_USER_LOGIN')) define('DISABLE_REMOTE_USER_LOGIN', false);

/**
 * By default we won't disable the FULL GAB, as it is a performance option
 * which, when enabled, prevents the full GAB to be loaded'
 */
if(!defined('DISABLE_FULL_GAB')) define('DISABLE_FULL_GAB', false);

/** 
 * Limit the amount of members shown in the addressbook details dialog for a distlist. If the list  
 * is too great the browser will hang loading and rendereing all the items. By default set to 0  
 * which means it loads all members. 
 */ 
if(!defined('ABITEMDETAILS_MAX_NUM_DISTLIST_MEMBERS')) define('ABITEMDETAILS_MAX_NUM_DISTLIST_MEMBERS', 0); 

/**
 * Use direct booking by default (books resources directly in the calendar instead of sending a meeting
 * request)
 */
if(!defined('ENABLE_DIRECT_BOOKING')) define('ENABLE_DIRECT_BOOKING', true);

if(!defined('ENABLED_LANGUAGES')) define("ENABLED_LANGUAGES", "de_DE;en_GB;en_US;es_ES;fi_FI;fr_FR;he_IL;hu_HU;it_IT;nb_NO;nl_NL;pl_PL;pt_BR;ru_RU;zh_CN");

if(!defined('ENABLE_PLUGINS')) define('ENABLE_PLUGINS', true);

?>
