/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IPending;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class LazySeq
extends Obj
implements ISeq,
Sequential,
List,
IPending,
IHashEq {
    private IFn fn;
    private Object sv;
    private ISeq s;

    public LazySeq(IFn fn2) {
        this.fn = fn2;
    }

    private LazySeq(IPersistentMap meta2, ISeq s) {
        super(meta2);
        this.fn = null;
        this.s = s;
    }

    public Obj withMeta(IPersistentMap meta2) {
        return new LazySeq(meta2, this.seq());
    }

    final synchronized Object sval() {
        if (this.fn != null) {
            try {
                this.sv = this.fn.invoke();
                this.fn = null;
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw Util.sneakyThrow(e3);
            }
        }
        if (this.sv != null) {
            return this.sv;
        }
        return this.s;
    }

    public final synchronized ISeq seq() {
        this.sval();
        if (this.sv != null) {
            Object ls = this.sv;
            this.sv = null;
            while (ls instanceof LazySeq) {
                ls = ((LazySeq)ls).sval();
            }
            this.s = RT.seq(ls);
        }
        return this.s;
    }

    public int count() {
        int c = 0;
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            ++c;
        }
        return c;
    }

    public Object first() {
        this.seq();
        if (this.s == null) {
            return null;
        }
        return this.s.first();
    }

    public ISeq next() {
        this.seq();
        if (this.s == null) {
            return null;
        }
        return this.s.next();
    }

    public ISeq more() {
        this.seq();
        if (this.s == null) {
            return PersistentList.EMPTY;
        }
        return this.s.more();
    }

    public ISeq cons(Object o) {
        return RT.cons(o, this.seq());
    }

    public IPersistentCollection empty() {
        return PersistentList.EMPTY;
    }

    public boolean equiv(Object o) {
        return this.equals(o);
    }

    public int hashCode() {
        ISeq s = this.seq();
        if (s == null) {
            return 1;
        }
        return Util.hash(this.seq());
    }

    public int hasheq() {
        ISeq s = this.seq();
        if (s == null) {
            return 1;
        }
        return Util.hasheq(this.seq());
    }

    public boolean equals(Object o) {
        ISeq s = this.seq();
        if (s != null) {
            return s.equiv(o);
        }
        return (o instanceof Sequential || o instanceof List) && RT.seq(o) == null;
    }

    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    public int size() {
        return this.count();
    }

    public boolean isEmpty() {
        return this.seq() == null;
    }

    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new SeqIterator(this.seq());
    }

    private List reify() {
        return new ArrayList(this);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.reify().subList(fromIndex, toIndex);
    }

    public Object set(int index2, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index2) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object o) {
        ISeq s = this.seq();
        int i = 0;
        while (s != null) {
            if (Util.equiv(s.first(), o)) {
                return i;
            }
            s = s.next();
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        return this.reify().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.reify().listIterator();
    }

    public ListIterator listIterator(int index2) {
        return this.reify().listIterator(index2);
    }

    public Object get(int index2) {
        return RT.nth(this, index2);
    }

    public void add(int index2, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index2, Collection c) {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean isRealized() {
        return this.fn == null;
    }
}

