/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchTagCommand
implements ISVNCommand {
    private IResource resource;
    private SVNUrl sourceUrl;
    private SVNUrl destinationUrl;
    private boolean createOnServer;
    private String message;
    private SVNRevision revision;
    private SVNWorkspaceRoot root;

    public BranchTagCommand(SVNWorkspaceRoot root, IResource resource, SVNUrl sourceUrl, SVNUrl destinationUrl, String message, boolean createOnServer, SVNRevision revision) {
        this.root = root;
        this.resource = resource;
        this.sourceUrl = sourceUrl;
        this.destinationUrl = destinationUrl;
        this.createOnServer = createOnServer;
        this.message = message;
        this.revision = revision;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws SVNException {
        try {
            try {
                monitor.beginTask(null, 100);
                ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                monitor.subTask(this.resource.getName());
                if (this.createOnServer) {
                    svnClient.copy(this.sourceUrl, this.destinationUrl, this.message, this.revision);
                } else {
                    File file = this.resource.getLocation().toFile();
                    svnClient.copy(file, this.destinationUrl, this.message);
                }
                monitor.worked(100);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            OperationManager.getInstance().endOperation();
            monitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
            OperationManager.getInstance().endOperation();
        }
        monitor.done();
    }
}

