/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.GetStatusCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.subscriber.RevertSynchronizeOperation;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class RevertSynchronizeAction
extends SynchronizeModelAction {
    private String url;

    public RevertSynchronizeAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                FastSyncInfoFilter.SyncInfoDirectionFilter outgoingFilter = new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 12});
                if (!outgoingFilter.select(info)) {
                    return false;
                }
                IStructuredSelection selection = RevertSynchronizeAction.this.getStructuredSelection();
                Iterator iter = selection.iterator();
                boolean removeUnAdded = SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_remove_unadded_resources_on_replace");
                while (iter.hasNext()) {
                    ISynchronizeModelElement element = (ISynchronizeModelElement)iter.next();
                    IResource resource = element.getResource();
                    if (resource == null) continue;
                    if (resource.isLinked()) {
                        return false;
                    }
                    if (removeUnAdded) continue;
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                    try {
                        if (svnResource.isManaged()) continue;
                        return false;
                    }
                    catch (SVNException sVNException) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        ISynchronizeModelElement element;
        IResource resource;
        this.url = null;
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.size() == 1 && (resource = (element = (ISynchronizeModelElement)selection.getFirstElement()).getResource()) != null) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            try {
                this.url = svnResource.getStatus().getUrlString();
                if (this.url == null || resource.getType() == 1) {
                    this.url = Util.getParentUrl((ISVNLocalResource)svnResource);
                }
            }
            catch (SVNException e) {
                e.printStackTrace();
            }
        }
        List<IResource> selectedElements = new ArrayList<IResource>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            ISynchronizeModelElement synchronizeModelElement = (ISynchronizeModelElement)iter.next();
            if (synchronizeModelElement instanceof ChangeSetDiffNode) {
                selectedElements.clear();
                ChangeSet set = ((ChangeSetDiffNode)synchronizeModelElement).getSet();
                selectedElements = Arrays.asList(set.getResources());
                break;
            }
            IResource resource2 = synchronizeModelElement.getResource();
            selectedElements.add(resource2);
        }
        IResource[] resources = new IResource[selectedElements.size()];
        selectedElements.toArray(resources);
        IResource[] modifiedResources = null;
        try {
            modifiedResources = this.getModifiedResources(resources, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SVNException sVNException) {}
        return new RevertSynchronizeOperation(configuration, elements, this.url, modifiedResources);
    }

    private IResource[] getModifiedResources(IResource[] resources, IProgressMonitor iProgressMonitor) throws SVNException {
        ArrayList<IResource> modified = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            if (resources.length == 1) {
                this.url = svnResource.getStatus().getUrlString();
                if (this.url == null || resource.getType() == 1) {
                    this.url = Util.getParentUrl((ISVNLocalResource)svnResource);
                }
            }
            GetStatusCommand command = new GetStatusCommand(svnResource, true, false);
            command.run(iProgressMonitor);
            ISVNStatus[] statuses = command.getStatuses();
            int j = 0;
            while (j < statuses.length) {
                IResource currentResource;
                if ((SVNStatusUtils.isReadyForRevert((ISVNStatus)statuses[j]) || !SVNStatusUtils.isManaged((ISVNStatus)statuses[j])) && (currentResource = SVNWorkspaceRoot.getResourceFor((ISVNStatus)statuses[j])) != null) {
                    modified.add(currentResource);
                }
                ++j;
            }
            ++i;
        }
        return modified.toArray(new IResource[modified.size()]);
    }
}

