/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.xsd;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class WSDLPartsToXSDTypeMapper {
    private final char POUND = (char)35;
    private Vector xsdSchemaList_ = new Vector();
    private Hashtable partToXSDCache_ = new Hashtable();

    public void addSchemas(Vector schemaList) {
        int i = 0;
        while (i < schemaList.size()) {
            Object schema = schemaList.elementAt(i);
            if (schema != null) {
                this.xsdSchemaList_.addElement(schema);
            }
            ++i;
        }
    }

    public XSDNamedComponent getXSDType(Part part, String id) {
        XSDNamedComponent component = this.getXSDTypeFromCache(id);
        if (component != null) {
            return component;
        }
        component = this.getXSDTypeFromSchema(part);
        if (component != null) {
            this.addToCache(id, component);
        }
        return component;
    }

    public XSDNamedComponent getXSDTypeFromCache(String id) {
        return (XSDNamedComponent)this.partToXSDCache_.get(id);
    }

    public XSDNamedComponent getXSDTypeFromSchema(Part part) {
        boolean isElementDeclaration = part.getTypeName() == null;
        QName qName = isElementDeclaration ? part.getElementName() : part.getTypeName();
        return this.getXSDTypeFromSchema(qName.getNamespaceURI(), qName.getLocalPart(), isElementDeclaration);
    }

    public XSDNamedComponent getXSDTypeFromSchema(String namespaceURI, String localName, boolean isElementDeclaration) {
        int i = 0;
        while (i < this.xsdSchemaList_.size()) {
            XSDSchema xsdSchema = (XSDSchema)this.xsdSchemaList_.elementAt(i);
            Vector components = new Vector();
            if (isElementDeclaration) {
                components.addAll(xsdSchema.getElementDeclarations());
            } else {
                components.addAll(xsdSchema.getTypeDefinitions());
            }
            Iterator it = components.iterator();
            while (it.hasNext()) {
                XSDNamedComponent component = (XSDNamedComponent)it.next();
                String compNSURI = component.getTargetNamespace();
                String compLocalname = component.getName();
                if (compNSURI == null || compLocalname == null || !compNSURI.equals(namespaceURI) || !compLocalname.equals(localName)) continue;
                return component;
            }
            ++i;
        }
        return null;
    }

    public XSDNamedComponent resolveXSDNamedComponent(XSDNamedComponent component) {
        if (component != null) {
            String uri = component.getURI();
            String qname = component.getQName();
            int i = 0;
            while (i < this.xsdSchemaList_.size()) {
                String targetNS;
                XSDSchema xsdSchema = (XSDSchema)this.xsdSchemaList_.elementAt(i);
                if (xsdSchema != null && (targetNS = xsdSchema.getTargetNamespace()) != null && targetNS.equals(this.trimQName(uri, qname))) {
                    XSDTypeDefinition resolvedComponent = null;
                    if (component instanceof XSDTypeDefinition) {
                        resolvedComponent = xsdSchema.resolveTypeDefinition(qname);
                    } else if (component instanceof XSDElementDeclaration) {
                        resolvedComponent = xsdSchema.resolveElementDeclaration(qname);
                    } else if (component instanceof XSDModelGroupDefinition) {
                        resolvedComponent = xsdSchema.resolveModelGroupDefinition(qname);
                    }
                    if (this.isComponentResolvable((XSDComponent)resolvedComponent)) {
                        return resolvedComponent;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private String trimQName(String uri, String qname) {
        int index = uri.indexOf(qname);
        if (index != -1) {
            String ns = uri.substring(0, index);
            if (ns.charAt(index - 1) == '#') {
                return ns.substring(0, index - 1);
            }
            return ns;
        }
        return uri;
    }

    private void addToCache(String id, XSDNamedComponent component) {
        this.partToXSDCache_.put(id, component);
    }

    protected boolean isComponentResolvable(XSDComponent component) {
        if (component == null) {
            return false;
        }
        XSDSchema schema = component.getSchema();
        if (schema == null) {
            return false;
        }
        return schema.getTargetNamespace() != null;
    }
}

