/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core;

import java.lang.reflect.InvocationTargetException;
import java.util.MissingResourceException;

public class WSIException
extends Exception {
    private static final long serialVersionUID = 5446823222767299308L;
    protected Throwable throwable = null;

    public WSIException() {
    }

    public WSIException(String msg) {
        super(msg);
    }

    public WSIException(String msg, Throwable throwable) {
        super(msg);
        this.throwable = throwable;
    }

    public String getMessage() {
        return super.getMessage();
    }

    public String toString() {
        String msg = super.getMessage();
        if (this.throwable != null) {
            msg = String.valueOf(msg) + "\n------------------------------------------------------------------------------\n  Nested exception is: \n\n  " + this.throwable.toString() + "\n";
            if (this.throwable instanceof MissingResourceException) {
                MissingResourceException mre = (MissingResourceException)this.throwable;
                msg = String.valueOf(msg) + " - " + mre.getKey() + "\n\t" + "[Class Name: " + mre.getClassName() + "]";
            } else if (this.throwable instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)this.throwable;
                msg = String.valueOf(msg) + " - " + ite.getTargetException().toString();
            }
        }
        return msg;
    }

    public Throwable getTargetException() {
        return this.throwable;
    }
}

