/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test.wssample;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.codegen.Generator;
import org.eclipse.jst.ws.internal.consumption.command.common.StartProjectCommand;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.InputFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.MethodFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.ResultFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.TestClientFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.command.GeneratePageCommand;
import org.eclipse.jst.ws.internal.consumption.sampleapp.command.JavaToModelCommand;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.CopyWebServiceUtilsJarCommand;
import org.eclipse.jst.ws.internal.ext.test.JavaProxyTestCommand;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.selection.BooleanSelection;
import org.eclipse.wst.command.internal.env.ui.eclipse.EnvironmentUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.ws.internal.datamodel.Model;

public class WSSampleFinishCommand
extends AbstractDataModelOperation
implements JavaProxyTestCommand {
    public static String INPUT = "Input.jsp";
    public static String TEST_CLIENT = "TestClient.jsp";
    public static String RESULT = "Result.jsp";
    public static String METHOD = "Method.jsp";
    private Model proxyModel;
    private String sampleServerTypeID;
    private IServer sampleExistingServer;
    private String clientProject;
    private String jspFolder;
    private boolean runClientTest;
    private String sampleProject;
    private BooleanSelection[] methods;
    private String proxyBean;
    private String setEndpointMethod;
    private List endpoints;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        CopyWebServiceUtilsJarCommand copy = new CopyWebServiceUtilsJarCommand();
        copy.setSampleProject(this.sampleProject);
        copy.setEnvironment(env);
        status = copy.execute(monitor, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        status = this.createModel(env, monitor);
        if (status.getSeverity() == 4) {
            return status;
        }
        status = this.generatePages(env, monitor);
        if (status.getSeverity() == 4) {
            return status;
        }
        status = this.launchSample(env, monitor);
        return status;
    }

    protected IStatus generatePages(IEnvironment env, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        Path fDestinationFolderPath = new Path(this.jspFolder);
        fDestinationFolderPath = fDestinationFolderPath.makeAbsolute();
        IWorkspaceRoot fWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IPath pathTest = fDestinationFolderPath.append(TEST_CLIENT);
        IFile fileTest = fWorkspace.getFile(pathTest);
        GeneratePageCommand gpcTest = new GeneratePageCommand(EnvironmentUtils.getResourceContext((IEnvironment)env), this.proxyModel, (Generator)new TestClientFileGenerator(INPUT, METHOD, RESULT), fileTest);
        gpcTest.setEnvironment(env);
        status = gpcTest.execute(monitor, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathInput = fDestinationFolderPath.append(INPUT);
        IFile fileInput = fWorkspace.getFile(pathInput);
        InputFileGenerator inputGenerator = new InputFileGenerator(RESULT);
        GeneratePageCommand gpcInput = new GeneratePageCommand(EnvironmentUtils.getResourceContext((IEnvironment)env), this.proxyModel, (Generator)inputGenerator, fileInput);
        gpcInput.setEnvironment(env);
        status = gpcInput.execute(monitor, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathMethod = fDestinationFolderPath.append(METHOD);
        IFile fileMethod = fWorkspace.getFile(pathMethod);
        MethodFileGenerator methodGenerator = new MethodFileGenerator(INPUT);
        methodGenerator.setClientFolderPath(this.jspFolder);
        GeneratePageCommand gpcMethod = new GeneratePageCommand(EnvironmentUtils.getResourceContext((IEnvironment)env), this.proxyModel, (Generator)methodGenerator, fileMethod);
        gpcMethod.setEnvironment(env);
        status = gpcMethod.execute(monitor, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathResult = fDestinationFolderPath.append(RESULT);
        IFile fileResult = fWorkspace.getFile(pathResult);
        ResultFileGenerator rfg = new ResultFileGenerator();
        rfg.setClientFolderPath(this.jspFolder);
        rfg.setSetEndpointMethod(this.setEndpointMethod);
        GeneratePageCommand gpcResult = new GeneratePageCommand(EnvironmentUtils.getResourceContext((IEnvironment)env), this.proxyModel, (Generator)rfg, fileResult);
        gpcResult.setEnvironment(env);
        status = gpcResult.execute(monitor, null);
        return status;
    }

    protected IStatus launchSample(IEnvironment env, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (!this.runClientTest) {
            return status;
        }
        Path fDestinationFolderPath = new Path(this.jspFolder);
        fDestinationFolderPath = fDestinationFolderPath.makeAbsolute();
        StartProjectCommand spc = new StartProjectCommand(false);
        spc.setServiceServerTypeID(this.sampleServerTypeID);
        spc.setSampleExistingServer(this.sampleExistingServer);
        IProject project = (IProject)ResourceUtils.findResource((String)this.sampleProject);
        spc.setSampleProject(project);
        spc.setIsWebProjectStartupRequested(true);
        spc.setEnvironment(env);
        status = spc.execute(monitor, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        Path newPath = new Path(ResourceUtils.getWebProjectURL((IProject)ResourceUtils.getProjectOf((IPath)fDestinationFolderPath), (String)this.sampleServerTypeID, (IServer)this.sampleExistingServer));
        newPath = newPath.append(fDestinationFolderPath.removeFirstSegments(2).makeAbsolute());
        StringBuffer urlString = new StringBuffer(newPath.append(TEST_CLIENT).toString());
        if (this.endpoints != null && !this.endpoints.isEmpty()) {
            urlString.append("?endpoint=");
            urlString.append(this.endpoints.get(0).toString());
        }
        try {
            URL url = new URL(urlString.toString());
            int retries = 0;
            while (retries < 10) {
                try {
                    new URL(newPath.append(RESULT).toString()).openStream();
                    new URL(newPath.append(METHOD).toString()).openStream();
                    new URL(newPath.append(INPUT).toString()).openStream();
                    new URL(newPath.append(TEST_CLIENT).toString()).openStream();
                    break;
                }
                catch (IOException iOException) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++retries;
                }
            }
            IWorkbenchBrowserSupport browserSupport = WebServiceConsumptionUIPlugin.getInstance().getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
            browser.openURL(url);
            return status;
        }
        catch (PartInitException exc) {
            env.getLog().log(2, 5048, (Object)this, "launchSample", (Throwable)exc);
            status = StatusUtils.warningStatus((String)ConsumptionUIMessages.MSG_ERROR_MALFORMED_URL, (Throwable)exc);
            try {
                env.getStatusHandler().report(status);
            }
            catch (StatusException e) {
                status = StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_MALFORMED_URL, (Throwable)e);
            }
            return status;
        }
        catch (MalformedURLException exc) {
            env.getLog().log(2, 5048, (Object)this, "launchSample", (Throwable)exc);
            status = StatusUtils.warningStatus((String)ConsumptionUIMessages.MSG_ERROR_MALFORMED_URL, (Throwable)exc);
            try {
                env.getStatusHandler().report(status);
            }
            catch (StatusException e) {
                status = StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_MALFORMED_URL, (Throwable)e);
            }
            return status;
        }
    }

    protected IStatus createModel(IEnvironment env, IProgressMonitor monitor) {
        JavaToModelCommand jtmc = new JavaToModelCommand();
        jtmc.setMethods(this.methods);
        jtmc.setClientProject(this.clientProject);
        jtmc.setProxyBean(this.proxyBean);
        jtmc.setEnvironment(env);
        IStatus status = jtmc.execute(monitor, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        this.proxyModel = jtmc.getJavaDataModel();
        return status;
    }

    public void setServerTypeID(String sampleServerTypeID) {
        this.sampleServerTypeID = sampleServerTypeID;
    }

    public void setExistingServer(IServer sampleExistingServer) {
        this.sampleExistingServer = sampleExistingServer;
    }

    public void setJspFolder(String jspFolder) {
        this.jspFolder = jspFolder;
    }

    public void setRunClientTest(boolean runClientTest) {
        this.runClientTest = runClientTest;
    }

    public void setSampleProject(String sampleProject) {
        this.sampleProject = sampleProject;
    }

    public void setClientProject(String clientProject) {
        this.clientProject = clientProject;
    }

    public void setMethods(BooleanSelection[] methods) {
        this.methods = methods;
    }

    public void setProxyBean(String proxyBean) {
        this.proxyBean = proxyBean;
    }

    public void setSetEndpointMethod(String setEndpointMethod) {
        this.setEndpointMethod = setEndpointMethod;
    }

    public void setEndpoint(List endpoints) {
        this.endpoints = endpoints;
    }
}

