/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.ui.BIListElementSorter;
import org.eclipse.jem.internal.beaninfo.ui.BPBeaninfoListElement;
import org.eclipse.jem.internal.beaninfo.ui.BPListElement;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.BeaninfoEntrySearchpathDialog;
import org.eclipse.jem.internal.beaninfo.ui.BeaninfoPathsBlock;
import org.eclipse.jem.internal.beaninfo.ui.IBuildSearchPage;
import org.eclipse.jem.internal.beaninfo.ui.IStatusChangeListener;
import org.eclipse.jem.internal.beaninfo.ui.SearchPathListLabelProvider;
import org.eclipse.jem.internal.beaninfo.ui.TypedElementSelectionValidator;
import org.eclipse.jem.internal.beaninfo.ui.TypedViewerFilter;
import org.eclipse.jem.internal.beaninfo.ui.VariableSelectionBlock;
import org.eclipse.jem.internal.ui.core.JEMUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BeaninfosWorkbookPage
implements IBuildSearchPage {
    private static final String DIALOGSTORE_LASTVARIABLE = "org.eclipse.jem.internal.beaninfo.ui.lastvar";
    private Composite javaProjectsComposite = null;
    private Label label = null;
    private Table table = null;
    private Composite buttonsBar = null;
    private Button addFoldersbutton = null;
    private Button addJarsButton = null;
    private Button addExtJarsButton = null;
    private Button addVariableButton = null;
    private Button addProjectButton = null;
    private Button modifyPathsButton = null;
    private Button removeButton = null;
    private Label spacer2 = null;
    private Label spacer1 = null;
    private TableViewer tableViewer;
    private BeaninfoPathsBlock beaninfoPathsBlock;
    private IJavaProject javaProject;
    private List beaninfosList;
    private IWorkspaceRoot workspaceRoot;
    private IClasspathEntry[] resolvedList;
    private IClasspathEntry[] rawList;
    private SearchPathListLabelProvider labelProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public BeaninfosWorkbookPage(IWorkspaceRoot workspaceRoot, BeaninfoPathsBlock beaninfoPathsBlock) {
        this.workspaceRoot = workspaceRoot;
        this.beaninfoPathsBlock = beaninfoPathsBlock;
        this.labelProvider = new SearchPathListLabelProvider();
        this.beaninfosList = new ArrayList();
        if (this.spacer1 != null) {
            // empty if block
        }
    }

    public Control createControl(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.javaProjectsComposite = new Composite(parent, 0);
        this.javaProjectsComposite.setLayout((Layout)gridLayout);
        this.label = new Label(this.javaProjectsComposite, 0);
        this.label.setText(BeanInfoUIMessages.BeanInfosWorkbookPage_List_Text);
        this.label.setLayoutData((Object)gridData);
        this.createTable();
        this.createButtonsBar();
        this.updateEnabledStates();
        return this.javaProjectsComposite;
    }

    private void createTable() {
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalAlignment = 4;
        this.table = new Table(this.javaProjectsComposite, 2818);
        this.table.setLayoutData((Object)gridData1);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BeaninfosWorkbookPage.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setSorter((ViewerSorter)new BIListElementSorter());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setInput((Object)this.beaninfosList);
    }

    private void createButtonsBar() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginLeft = 3;
        rowLayout.fill = true;
        GridData gridData2 = new GridData();
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 4;
        gridData2.horizontalAlignment = 1;
        this.buttonsBar = new Composite(this.javaProjectsComposite, 0);
        this.buttonsBar.setLayoutData((Object)gridData2);
        this.buttonsBar.setLayout((Layout)rowLayout);
        this.addFoldersbutton = new Button(this.buttonsBar, 0);
        this.addFoldersbutton.setText(BeanInfoUIMessages.BeanInfosWorkbookPage_AddFolders);
        this.addFoldersbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List beaninfoEntries = BeaninfosWorkbookPage.this.chooseClassContainers();
                BeaninfosWorkbookPage.this.addToBeaninfosList(beaninfoEntries);
            }
        });
        this.addJarsButton = new Button(this.buttonsBar, 0);
        this.addJarsButton.setText(BeanInfoUIMessages.BeanInfosWorkbookPage_AddJARs);
        this.addJarsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List beaninfoEntries = BeaninfosWorkbookPage.this.chooseJarFiles();
                BeaninfosWorkbookPage.this.addToBeaninfosList(beaninfoEntries);
            }
        });
        this.addExtJarsButton = new Button(this.buttonsBar, 0);
        this.addExtJarsButton.setText(BeanInfoUIMessages.BeanInfosWorkbookPage_AddExternalJAR);
        this.addExtJarsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List beaninfoEntries = BeaninfosWorkbookPage.this.chooseExtJarFiles();
                BeaninfosWorkbookPage.this.addToBeaninfosList(beaninfoEntries);
            }
        });
        this.addVariableButton = new Button(this.buttonsBar, 0);
        this.addVariableButton.setText(BeanInfoUIMessages.BeanInfosWorkbookPage_AddVariable);
        this.addVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List beaninfoEntries = BeaninfosWorkbookPage.this.chooseVariableEntries();
                BeaninfosWorkbookPage.this.addToBeaninfosList(beaninfoEntries);
            }
        });
        this.addProjectButton = new Button(this.buttonsBar, 0);
        this.addProjectButton.setText(BeanInfoUIMessages.BeanInfosWorkbookPage_AddProjects);
        this.addProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List beaninfoEntries = BeaninfosWorkbookPage.this.chooseProjects();
                BeaninfosWorkbookPage.this.addToBeaninfosList(beaninfoEntries);
            }
        });
        this.spacer1 = new Label(this.buttonsBar, 0);
        this.modifyPathsButton = new Button(this.buttonsBar, 0);
        this.modifyPathsButton.setText(BeanInfoUIMessages.BeanInfosWorkbookPage_ModifyPaths);
        this.modifyPathsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeaninfosWorkbookPage.this.modifySearchPaths();
            }
        });
        this.spacer2 = new Label(this.buttonsBar, 0);
        this.removeButton = new Button(this.buttonsBar, 0);
        this.removeButton.setText(BeanInfoUIMessages.BeanInfosWorkbookPage_Remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selected = BeaninfoPathsBlock.getSelectedList(BeaninfosWorkbookPage.this.tableViewer.getSelection());
                BeaninfosWorkbookPage.this.beaninfosList.removeAll(selected);
                BeaninfosWorkbookPage.this.tableViewer.refresh();
                BeaninfosWorkbookPage.this.pageChanged();
            }
        });
    }

    private List chooseVariableEntries() {
        ArrayList<IPath> existingPaths = new ArrayList<IPath>();
        int i = 0;
        while (i < this.rawList.length) {
            if (this.rawList[i].getEntryKind() == 4) {
                existingPaths.add(this.rawList[i].getPath());
            }
            ++i;
        }
        List ours = this.beaninfosList;
        int i2 = 0;
        while (i2 < ours.size()) {
            BPBeaninfoListElement bpb = (BPBeaninfoListElement)ours.get(i2);
            if (bpb.getEntry().getKind() == 4) {
                existingPaths.add(bpb.getEntry().getPath());
            }
            ++i2;
        }
        VariableSelectionDialog dialog = new VariableSelectionDialog(this.addVariableButton.getShell(), existingPaths);
        if (dialog.open() == 0) {
            IPath path = dialog.getVariable();
            IClasspathEntry cpe = JavaCore.newVariableEntry((IPath)path, null, null);
            IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)path);
            boolean isMissing = resolvedPath == null || !resolvedPath.toFile().isFile();
            return Collections.singletonList(new BPBeaninfoListElement(new BeaninfoEntry(cpe, null, true), null, isMissing));
        }
        return null;
    }

    private List chooseJarFiles() {
        IPath[] jarPaths = BuildPathDialogAccess.chooseJAREntries((Shell)this.addJarsButton.getShell(), (IPath)this.javaProject.getPath(), (IPath[])this.getUsedJARFiles());
        if (jarPaths != null) {
            ArrayList<BPBeaninfoListElement> res = new ArrayList<BPBeaninfoListElement>(jarPaths.length);
            int i = 0;
            while (i < jarPaths.length) {
                BPBeaninfoListElement newGuy = this.newBPBeaninfoListElementFromFullpath(jarPaths[i]);
                if (newGuy != null) {
                    res.add(newGuy);
                }
                ++i;
            }
            return res;
        }
        return null;
    }

    private List chooseExtJarFiles() {
        IPath[] extJARPaths = BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.addExtJarsButton.getShell());
        ArrayList<BPBeaninfoListElement> elems = null;
        if (extJARPaths != null) {
            elems = new ArrayList<BPBeaninfoListElement>(extJARPaths.length);
            int i = 0;
            while (i < extJARPaths.length) {
                BPBeaninfoListElement newGuy = this.newBPBeaninfoListElement(extJARPaths[i]);
                if (newGuy != null) {
                    elems.add(newGuy);
                }
                ++i;
            }
        }
        return elems;
    }

    private BPBeaninfoListElement newBPBeaninfoListElement(IPath path) {
        int i = 0;
        while (i < this.resolvedList.length) {
            IClasspathEntry cpe = this.resolvedList[i];
            if (cpe != null && cpe.getEntryKind() == 1 && cpe.getPath().equals((Object)path)) {
                return null;
            }
            ++i;
        }
        List ours = this.beaninfosList;
        int i2 = 0;
        while (i2 < ours.size()) {
            BPBeaninfoListElement bpb = (BPBeaninfoListElement)ours.get(i2);
            if (bpb.getEntry().getKind() == 1 && bpb.getEntry().getPath().equals((Object)path)) {
                return null;
            }
            ++i2;
        }
        IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)path, null, null);
        BeaninfoEntry bie = new BeaninfoEntry(cpe, null, true);
        return new BPBeaninfoListElement(bie, null, false);
    }

    private IPath[] getUsedJARFiles() {
        ArrayList<IPath> res = new ArrayList<IPath>();
        int i = 0;
        while (i < this.resolvedList.length) {
            IPath path;
            IResource resource;
            if (this.resolvedList[i] != null && this.resolvedList[i].getEntryKind() == 1 && (resource = this.workspaceRoot.findMember(path = this.resolvedList[i].getPath())) instanceof IFile) {
                res.add(path);
            }
            ++i;
        }
        List bilist = this.beaninfosList;
        int i2 = 0;
        while (i2 < bilist.size()) {
            IPath path;
            IResource resource;
            BPListElement elem = (BPListElement)bilist.get(i2);
            if (elem.getEntry().getKind() == 1 && (resource = this.workspaceRoot.findMember(path = elem.getEntry().getPath())) instanceof IFile) {
                res.add(path);
            }
            ++i2;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private BPBeaninfoListElement newBPBeaninfoListElement(IResource element) {
        if (element instanceof IContainer || element instanceof IFile) {
            return this.newBPBeaninfoListElementFromFullpath(element.getFullPath());
        }
        return null;
    }

    private BPBeaninfoListElement newBPBeaninfoListElementFromFullpath(IPath fullPath) {
        if (fullPath != null) {
            IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)fullPath, null, null);
            BeaninfoEntry bie = new BeaninfoEntry(cpe, null, true);
            return new BPBeaninfoListElement(bie, null, false);
        }
        return null;
    }

    private List chooseClassContainers() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        Class[] classArray2 = new Class[2];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz2;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz3;
        acceptedClasses = classArray2;
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, this.getUsedContainers());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.addFoldersbutton.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(BeanInfoUIMessages.BeanInfosWorkbookPage_SelectionDialog_Classes_Title);
        dialog.setMessage(BeanInfoUIMessages.BeanInfosWorkbookPage_SelectionDialog_Classes_Prompt);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.workspaceRoot);
        dialog.setInitialSelection((Object)this.javaProject.getProject());
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            ArrayList<BPBeaninfoListElement> res = new ArrayList<BPBeaninfoListElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                BPBeaninfoListElement newGuy = this.newBPBeaninfoListElement((IResource)elements[i]);
                if (newGuy != null) {
                    res.add(newGuy);
                }
                ++i;
            }
            return res;
        }
        return null;
    }

    private IContainer[] getUsedContainers() {
        IResource resource;
        ArrayList<IResource> res = new ArrayList<IResource>();
        try {
            IPath outputLocation = this.javaProject.getOutputLocation();
            if (outputLocation != null && (resource = this.workspaceRoot.findMember(outputLocation)) instanceof IContainer) {
                res.add(resource);
            }
        }
        catch (JavaModelException e) {
            JEMUIPlugin.getPlugin().getLogger().log((Object)e.getStatus());
        }
        int i = 0;
        while (i < this.resolvedList.length) {
            if (this.resolvedList[i] != null && this.resolvedList[i].getEntryKind() == 3 && (resource = this.workspaceRoot.findMember(this.resolvedList[i].getPath())) instanceof IContainer) {
                res.add(resource);
            }
            ++i;
        }
        List bilist = this.beaninfosList;
        int i2 = 0;
        while (i2 < bilist.size()) {
            BPListElement elem = (BPListElement)bilist.get(i2);
            if (elem.getEntry().getKind() == 3) {
                IResource resource2 = this.workspaceRoot.findMember(elem.getEntry().getPath());
                res.add(resource2);
            }
            ++i2;
        }
        return res.toArray(new IContainer[res.size()]);
    }

    protected void addToBeaninfosList(final List toAdd) {
        if (this.beaninfosList != null && toAdd != null) {
            this.beaninfosList.addAll(toAdd);
            this.tableViewer.refresh();
            this.table.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    BeaninfosWorkbookPage.this.tableViewer.setSelection((ISelection)new StructuredSelection(toAdd));
                }
            });
            this.pageChanged();
        }
    }

    private void pageChanged() {
        if (this.javaProject != null) {
            this.updateSearchpathList();
        }
    }

    private void updateSearchpathList() {
        List searchelements = this.beaninfoPathsBlock.getSearchpathOrderingPage().getElements();
        ArrayList beaninfoelements = new ArrayList(this.beaninfosList);
        boolean changeDone = false;
        ListIterator spitr = searchelements.listIterator(searchelements.size());
        while (spitr.hasPrevious()) {
            BPListElement element = (BPListElement)spitr.previous();
            if (!(element instanceof BPBeaninfoListElement) || beaninfoelements.remove(element)) continue;
            spitr.remove();
            changeDone = true;
        }
        searchelements.addAll(beaninfoelements);
        boolean bl = changeDone = changeDone || !beaninfoelements.isEmpty();
        if (changeDone) {
            this.beaninfoPathsBlock.setSearchOrderElements(searchelements);
        }
    }

    public void init(IJavaProject javaProject) {
        this.javaProject = javaProject;
        this.labelProvider.setJavaProject(this.javaProject);
        try {
            this.rawList = this.javaProject.getRawClasspath();
            this.resolvedList = new IClasspathEntry[this.rawList.length];
            int i = 0;
            while (i < this.rawList.length) {
                this.resolvedList[i] = JavaCore.getResolvedClasspathEntry((IClasspathEntry)this.rawList[i]);
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            this.resolvedList = new IClasspathEntry[0];
            this.rawList = this.resolvedList;
        }
        this.updateBeaninfosList();
    }

    private void updateBeaninfosList() {
        List spelements = this.beaninfoPathsBlock.getSearchpathOrderingPage().getElements();
        ArrayList<BPListElement> biElements = new ArrayList<BPListElement>(spelements.size());
        int i = 0;
        while (i < spelements.size()) {
            BPListElement spe = (BPListElement)spelements.get(i);
            if (spe instanceof BPBeaninfoListElement) {
                biElements.add(spe);
            }
            ++i;
        }
        this.beaninfosList.clear();
        this.beaninfosList.addAll(biElements);
        if (this.tableViewer != null && !this.table.isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    public List getSelection() {
        if (this.tableViewer != null) {
            return BeaninfoPathsBlock.getSelectedList(this.tableViewer.getSelection());
        }
        return null;
    }

    public void setSelection(List selection) {
        if (this.tableViewer != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(selection));
        }
    }

    protected void updateButtons() {
        List selected = BeaninfoPathsBlock.getSelectedList(this.tableViewer.getSelection());
        this.addExtJarsButton.setEnabled(this.beaninfoPathsBlock.isBeaninfoEnabled());
        this.addFoldersbutton.setEnabled(this.beaninfoPathsBlock.isBeaninfoEnabled());
        this.addJarsButton.setEnabled(this.beaninfoPathsBlock.isBeaninfoEnabled());
        this.addProjectButton.setEnabled(this.beaninfoPathsBlock.isBeaninfoEnabled());
        this.addVariableButton.setEnabled(this.beaninfoPathsBlock.isBeaninfoEnabled());
        this.removeButton.setEnabled(selected != null && selected.size() > 0 && this.beaninfoPathsBlock.isBeaninfoEnabled());
        this.modifyPathsButton.setEnabled(selected != null && selected.size() == 1 && this.beaninfoPathsBlock.isBeaninfoEnabled());
    }

    private List chooseProjects() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.IJavaProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        ArrayList<IJavaElement> allProjects = null;
        try {
            allProjects = new ArrayList<IJavaElement>(Arrays.asList(this.javaProject.getJavaModel().getChildren()));
        }
        catch (JavaModelException javaModelException) {
            allProjects = Collections.EMPTY_LIST;
        }
        allProjects.removeAll(this.getUsedProjects());
        JavaElementLabelProvider lp = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.addProjectButton.getShell(), (ILabelProvider)lp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(BeanInfoUIMessages.BeanInfosWorkbookPage_SelectionDialog_Projects_Title);
        dialog.setMessage(BeanInfoUIMessages.BeanInfosWorkbookPage_SelectionDialog_Projects_Prompt);
        dialog.setElements(allProjects.toArray());
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            ArrayList<BPBeaninfoListElement> res = new ArrayList<BPBeaninfoListElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                try {
                    IClasspathEntry cpe = JavaCore.newProjectEntry((IPath)((IJavaProject)elements[i]).getCorrespondingResource().getFullPath());
                    BeaninfoEntry bie = new BeaninfoEntry(cpe, null, true);
                    res.add(new BPBeaninfoListElement(bie, null, false));
                }
                catch (JavaModelException javaModelException) {}
                ++i;
            }
            return res;
        }
        return null;
    }

    private List getUsedProjects() {
        ArrayList<IJavaProject> res = new ArrayList<IJavaProject>();
        res.add(this.javaProject);
        IJavaModel jmodel = this.javaProject.getJavaModel();
        int i = 0;
        while (i < this.resolvedList.length) {
            if (this.resolvedList[i] != null && this.resolvedList[i].getEntryKind() == 2) {
                res.add(jmodel.getJavaProject(this.resolvedList[i].getPath().segment(0)));
            }
            ++i;
        }
        List bilist = this.beaninfosList;
        int i2 = 0;
        while (i2 < bilist.size()) {
            BPListElement elem = (BPListElement)bilist.get(i2);
            if (elem.getEntry().getKind() == 2) {
                res.add(jmodel.getJavaProject(elem.getEntry().getPath().segment(0)));
            }
            ++i2;
        }
        return res;
    }

    private void modifySearchPaths() {
        BPBeaninfoListElement elem = (BPBeaninfoListElement)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        BeaninfoEntrySearchpathDialog dialog = new BeaninfoEntrySearchpathDialog(this.modifyPathsButton.getShell(), elem, this.javaProject);
        dialog.open();
    }

    protected void updateEnabledStates() {
        this.updateButtons();
        this.table.setEnabled(this.beaninfoPathsBlock.isBeaninfoEnabled());
        this.label.setEnabled(this.beaninfoPathsBlock.isBeaninfoEnabled());
    }

    public void setBeaninfoEnabled(boolean enable) {
        if (this.javaProjectsComposite != null && !this.javaProjectsComposite.isDisposed()) {
            this.updateEnabledStates();
        }
    }

    private class VariableSelectionDialog
    extends StatusDialog
    implements IStatusChangeListener {
        private VariableSelectionBlock fVariableSelectionBlock;
        IDialogSettings dialogSettings = JEMUIPlugin.getPlugin().getDialogSettings();

        public VariableSelectionDialog(Shell parent, List existingPaths) {
            super(parent);
            this.setTitle("New Variable Classpath Entry");
            String initVar = this.dialogSettings.get(BeaninfosWorkbookPage.DIALOGSTORE_LASTVARIABLE);
            this.fVariableSelectionBlock = new VariableSelectionBlock(this, existingPaths, null, initVar, false);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label message = new Label(composite, 64);
            message.setText("New Variable Classpath Entry");
            message.setLayoutData((Object)new GridData());
            Control inner = this.fVariableSelectionBlock.createControl(composite);
            inner.setLayoutData((Object)new GridData(1808));
            return composite;
        }

        protected void okPressed() {
            this.dialogSettings.put(BeaninfosWorkbookPage.DIALOGSTORE_LASTVARIABLE, this.getVariable().segment(0));
            super.okPressed();
        }

        public void statusChanged(IStatus status) {
            this.updateStatus(status);
        }

        public IPath getVariable() {
            return this.fVariableSelectionBlock.getVariablePath();
        }
    }
}

