/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.rdb.data.internal.ui.DataUIPlugin;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

public class EditTableDataAction implements IViewActionDelegate {

    protected Table table = null; 
    protected IViewPart view = null;

    public EditTableDataAction() {
        super();
    }

    public void run(IAction action) {
        
        if (table==null)
            return;

        IWorkbenchPage workbenchPage = view.getSite().getWorkbenchWindow().getActivePage();

        try {
            workbenchPage.openEditor(new TableDataEditorInput(table), "org.eclipse.wst.rdb.data.internal.ui.editor.tableDataEditor"); //$NON-NLS-1$
        } catch (PartInitException e) {
            DataUIPlugin.getDefault().writeLog(IStatus.ERROR, 0, e.getMessage(), e);
        }

    }

    public void selectionChanged(IAction action, ISelection selection) {

        table = null;
        
        if (selection instanceof IStructuredSelection)
            if (  ((IStructuredSelection)selection).getFirstElement() instanceof Table )
                table = (Table) ((IStructuredSelection)selection).getFirstElement();
        
        boolean b = action.isEnabled();
        b &= table!=null && table.getColumns().size()>0;
        b &= DataUIPlugin.isGroupIDOK(table);
        action.setEnabled(b);
    }
    
    public void init(IViewPart view) {
        this.view = view;
    }


}
