/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.wst.rdb.server.internal.ui.wizards;

import java.util.List;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.NewCWJDBCPage;

/**
 * @author ledunnel
 */
public class NewConnectionJDBCConfigurationWizardPage extends NewCWJDBCPage {

    public NewConnectionJDBCConfigurationWizardPage(String name,
            int contentOptions, List existingConnectionNamesList) {
        super(name, contentOptions, existingConnectionNamesList);
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = null;
        performTestConnection(false, true);
        if (isFinalConnection()) {
            nextPage = super.getNextPage();
        }
        return nextPage;
    }

    public boolean canFlipToNextPage() {
        return isPageComplete();
    }

}