/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;

import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.models.sql.schema.impl.DatabaseImpl;


public class DerbyCatalogDatabase extends DatabaseImpl implements ICatalogObject {
	private static final long serialVersionUID = 3257562914901669687L;
	
	public DerbyCatalogDatabase(Connection connection) {
		if(connection == null) {
			System.err.println("null connection"); //$NON-NLS-1$
			throw new RuntimeException();
		}
		this.connection = connection;
	}

	public synchronized void refresh() {
		if(this.schemasLoaded) {
			this.schemasLoaded = false;
			this.schemas.clear();
		}
		RefreshManager.getInstance().referesh(this);
	}

	public EList getSchemas() {
		if(!this.schemasLoaded) this.loadSchemas();
		return this.schemas;
	}
	
	
	public boolean isSystemObject() {
		return false;
	}

	public Connection getConnection() {
		return this.connection;
	}
	
	public Database getCatalogDatabase() {
		return this;		
	}
	
	public boolean eIsSet(EStructuralFeature eFeature) {
		int id = eDerivedStructuralFeatureID(eFeature);
		if(id == SQLSchemaPackage.DATABASE__SCHEMAS) {
			this.getSchemas();
		}
		return super.eIsSet(eFeature);
	}	

	private synchronized void loadSchemas() {
		if(this.schemasLoaded) return;
		EList schemaList = super.getSchemas();
		boolean deliver = this.eDeliver();
		this.eSetDeliver(false);	
		try {
			ConnectionInfo connectionInfo = RDBCorePlugin.getDefault().getConnectionManager().getConnectionInfo(this);
			ConnectionFilter filter = connectionInfo.getFilter(this.getName()+"::"+ConnectionFilter.SCHEMA_FILTER); //$NON-NLS-1$
			if (filter == null) {  //if schema filter is null, then get default filter
				filter = connectionInfo.getFilter(ConnectionFilter.SCHEMA_FILTER);
			}
			
			String query = "SELECT SCHEMANAME FROM SYS.SYSSCHEMAS"; //$NON-NLS-1$
			if (filter != null) {
				query += " WHERE SCHEMANAME " + filter.getPredicate(); //$NON-NLS-1$
			}
			Statement s = this.connection.createStatement();
			ResultSet r = s.executeQuery(query);
			while (r.next()){
				final String schemaName = r.getString(1);
				Schema schema = new DerbyCatalogSchema();
				schema.setName(schemaName);
				schemaList.add(schema);
			}
			this.schemasLoaded = true;
			r.close();
			s.close();
		}
		catch (Exception e) {
			System.out.println(e.toString());
		}
		this.eSetDeliver(deliver);
	}

	
	
	private Connection connection;
	private boolean schemasLoaded = false;
	
}
