/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.services;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.rdb.core.internal.ui.explorer.helpers.ColumnHelper;
import org.eclipse.wst.rdb.core.internal.ui.explorer.helpers.ForeignKeyHelper;
import org.eclipse.wst.rdb.core.internal.ui.explorer.providers.content.virtual.VirtualNodeServiceFactory;
import org.eclipse.wst.rdb.core.internal.ui.explorer.providers.decorators.IBookmarkDecorationService;
import org.eclipse.wst.rdb.core.internal.ui.explorer.providers.decorators.IColumnDecorationService;
import org.eclipse.wst.rdb.core.internal.ui.explorer.services.IVirtualNodeServiceFactory;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.DataToolsUIConstants;


/**
 * @author ljulien
 */
public class DataToolsUIServiceManager implements IDataToolsUIServiceManager, IDecorationService
{
    private static final ForeignKeyHelper foreignKeyHelper = new ForeignKeyHelper();
	/**
	 * Model Explorer Interaction service
	 */
	private LabelService labelService;
	private IMarkerNavigationService markerNavigationService;
	private IExplorerSorterService explorerSorter;
	
	/**
	 * Initialize our provider
	 */
	public DataToolsUIServiceManager ()
	{
		this.markerNavigationService = new MarkerNavigationService ();
		this.explorerSorter = new ExplorerSorterProvider ();
	}
	
	/**
	 * @see org.eclipse.wst.rdb.core.internal.ui.services.IDecorationService#getColumnDecorationService()
	 */
	public IColumnDecorationService getColumnDecorationService ()
	{
		IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
		return (IColumnDecorationService) decoratorManager.getBaseLabelProvider(
			DataToolsUIConstants.COLUMN_DECORATION_SERVICE); 
	}

	public IBookmarkDecorationService getBookmarkDecorationService ()
	{
	    IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
	    return (IBookmarkDecorationService) decoratorManager.getBaseLabelProvider(
	            DataToolsUIConstants.BOOKMARK_DECORATION_SERVICE);
	}

    public IMarkerNavigationService getMarkerNavigationService()
    {
        return this.markerNavigationService;
    }

	public void refreshColumnDecorationService ()
	{
	    IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
	    decoratorManager.update(DataToolsUIConstants.COLUMN_DECORATION_SERVICE);
	}
	
	/**
	 * Will provide some column related helper
	 * @return
	 */
	public IColumnHelperService getColumnHelperService ()
	{
		return new ColumnHelper();
	}

	/**
	 * @see org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager#getForeignKeyHelperService()
	 */
	public IForeignKeyHelperService getForeignKeyHelperService()
	{
		return foreignKeyHelper;
	}

	/**
	 * @see org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager#getDecorationService()
	 */
	public IDecorationService getDecorationService()
	{
		return this;
	}

	/**
	 * @see org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager#getVirtualNodeServiceFactory()
	 */
	public IVirtualNodeServiceFactory getVirtualNodeServiceFactory()
	{
		return VirtualNodeServiceFactory.INSTANCE;
	}

    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager#getImageService(java.lang.Object)
     */
    public Image getImageService(Object element)
    {
        return getLabelService(element).getIcon();
    }

    public ILabelService getLabelService(Object element)
    {
        if (labelService == null)
        {
            labelService = new LabelService ();
        }
        labelService.setElement (element);
        return labelService;
    }

    public IExplorerSorterService getExplorerSorterService ()
    {
        return explorerSorter;
    }
}
