/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private static final long serialVersionUID = 919286545866124006L;
    static final int RED = -1;
    static final int BLACK = 1;
    static final Node nil;
    private transient Node root;
    transient int size;
    private transient Set entries;
    transient int modCount;
    final Comparator comparator;

    public TreeMap() {
        this((Comparator)null);
    }

    public TreeMap(Comparator comparator) {
        this.comparator = comparator;
        this.fabricateTree(0);
    }

    public TreeMap(Map map) {
        this((Comparator)null);
        this.putAll(map);
    }

    public TreeMap(SortedMap sortedMap) {
        this(sortedMap.comparator());
        int n = sortedMap.size();
        Iterator iterator = sortedMap.entrySet().iterator();
        this.fabricateTree(n);
        Node node2 = this.firstNode();
        while (--n >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            node2.key = entry.getKey();
            node2.value = entry.getValue();
            node2 = this.successor(node2);
        }
    }

    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            this.root = nil;
            this.size = 0;
        }
    }

    public Object clone() {
        TreeMap treeMap = null;
        try {
            treeMap = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        treeMap.entries = null;
        treeMap.fabricateTree(this.size);
        Node node2 = this.firstNode();
        Node node3 = treeMap.firstNode();
        while (node2 != nil) {
            node3.key = node2.key;
            node3.value = node2.value;
            node2 = this.successor(node2);
            node3 = treeMap.successor(node3);
        }
        return treeMap;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public boolean containsKey(Object object) {
        return this.getNode(object) != nil;
    }

    public boolean containsValue(Object object) {
        Node node2 = this.firstNode();
        while (node2 != nil) {
            if (AbstractMap.equals(object, node2.value)) {
                return true;
            }
            node2 = this.successor(node2);
        }
        return false;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(this){
                private /* synthetic */ TreeMap this$0;
                {
                    this.this$0 = treeMap;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new TreeIterator(this.this$0, 2);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Node node2 = this.this$0.getNode(entry.getKey());
                    return node2 != nil && AbstractCollection.equals(entry.getValue(), node2.value);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Node node2 = this.this$0.getNode(entry.getKey());
                    if (node2 != nil && AbstractCollection.equals(entry.getValue(), node2.value)) {
                        this.this$0.removeNode(node2);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    public Object firstKey() {
        if (this.root == nil) {
            throw new NoSuchElementException();
        }
        return this.firstNode().key;
    }

    public Object get(Object object) {
        return this.getNode((Object)object).value;
    }

    public SortedMap headMap(Object object) {
        return new SubMap(this, nil, object);
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(this){
                private /* synthetic */ TreeMap this$0;
                {
                    this.this$0 = treeMap;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new TreeIterator(this.this$0, 0);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }

                public boolean remove(Object object) {
                    Node node2 = this.this$0.getNode(object);
                    if (node2 == nil) {
                        return false;
                    }
                    this.this$0.removeNode(node2);
                    return true;
                }
            };
        }
        return this.keys;
    }

    public Object lastKey() {
        if (this.root == nil) {
            throw new NoSuchElementException("empty");
        }
        return this.lastNode().key;
    }

    public Object put(Object object, Object object2) {
        Node node2 = this.root;
        Node node3 = nil;
        int n = 0;
        while (node2 != nil) {
            node3 = node2;
            n = this.compare(object, node2.key);
            if (n > 0) {
                node2 = node2.right;
                continue;
            }
            if (n < 0) {
                node2 = node2.left;
                continue;
            }
            return node2.setValue(object2);
        }
        Node node4 = new Node(object, object2, -1);
        node4.parent = node3;
        ++this.modCount;
        ++this.size;
        if (node3 == nil) {
            this.root = node4;
            return null;
        }
        if (n > 0) {
            node3.right = node4;
        } else {
            node3.left = node4;
        }
        this.insertFixup(node4);
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        int n = map.size();
        while (--n >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Node node2 = this.getNode(object);
        if (node2 == nil) {
            return null;
        }
        Object object2 = node2.value;
        this.removeNode(node2);
        return object2;
    }

    public int size() {
        return this.size;
    }

    public SortedMap subMap(Object object, Object object2) {
        return new SubMap(this, object, object2);
    }

    public SortedMap tailMap(Object object) {
        return new SubMap(this, object, nil);
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(this){
                private /* synthetic */ TreeMap this$0;
                {
                    this.this$0 = treeMap;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new TreeIterator(this.this$0, 1);
                }

                public void clear() {
                    this.this$0.clear();
                }
            };
        }
        return this.values;
    }

    final int compare(Object object, Object object2) {
        if (this.comparator == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return this.comparator.compare(object, object2);
    }

    private void deleteFixup(Node node2, Node node3) {
        while (node2 != this.root && node2.color == 1) {
            Node node4;
            if (node2 == node3.left) {
                node4 = node3.right;
                if (node4.color == -1) {
                    node4.color = 1;
                    node3.color = -1;
                    this.rotateLeft(node3);
                    node4 = node3.right;
                }
                if (node4.left.color == 1 && node4.right.color == 1) {
                    node4.color = -1;
                    node2 = node3;
                    node3 = node3.parent;
                    continue;
                }
                if (node4.right.color == 1) {
                    node4.left.color = 1;
                    node4.color = -1;
                    this.rotateRight(node4);
                    node4 = node3.right;
                }
                node4.color = node3.color;
                node3.color = 1;
                node4.right.color = 1;
                this.rotateLeft(node3);
                node2 = this.root;
                continue;
            }
            node4 = node3.left;
            if (node4.color == -1) {
                node4.color = 1;
                node3.color = -1;
                this.rotateRight(node3);
                node4 = node3.left;
            }
            if (node4.right.color == 1 && node4.left.color == 1) {
                node4.color = -1;
                node2 = node3;
                node3 = node3.parent;
                continue;
            }
            if (node4.left.color == 1) {
                node4.right.color = 1;
                node4.color = -1;
                this.rotateLeft(node4);
                node4 = node3.left;
            }
            node4.color = node3.color;
            node3.color = 1;
            node4.left.color = 1;
            this.rotateRight(node3);
            node2 = this.root;
        }
        node2.color = 1;
    }

    private void fabricateTree(int n) {
        Node node2;
        Node node3;
        Node node4;
        int n2;
        Node node5;
        if (n == 0) {
            this.root = nil;
            this.size = 0;
            return;
        }
        this.root = new Node(null, null, 1);
        this.size = n;
        Node node6 = this.root;
        int n3 = 2;
        while (true) {
            int n4 = n3;
            if (n4 + n4 > n) break;
            Node node7 = node6;
            node5 = null;
            for (n2 = 0; n2 < n3; n2 += 2) {
                node4 = new Node(null, null, 1);
                node3 = new Node(null, null, 1);
                node4.parent = node7;
                node4.right = node3;
                node3.parent = node7;
                node7.left = node4;
                node2 = node7.right;
                node7.right = node3;
                node7 = node2;
                if (node5 != null) {
                    node5.right = node4;
                }
                node5 = node3;
            }
            node6 = node6.left;
            n3 <<= 1;
        }
        int n5 = n - n3;
        node5 = node6;
        for (n2 = 0; n2 < n5; n2 += 2) {
            node4 = new Node(null, null, -1);
            node3 = new Node(null, null, -1);
            node4.parent = node5;
            node3.parent = node5;
            node5.left = node4;
            node2 = node5.right;
            node5.right = node3;
            node5 = node2;
        }
        if (n2 - n5 == 0) {
            node4 = new Node(null, null, -1);
            node4.parent = node5;
            node5.left = node4;
            node5 = node5.right;
            node4.parent.right = nil;
        }
        while (node5 != nil) {
            node4 = node5.right;
            node5.right = nil;
            node5 = node4;
        }
    }

    final Node firstNode() {
        Node node2 = this.root;
        while (node2.left != nil) {
            node2 = node2.left;
        }
        return node2;
    }

    final Node getNode(Object object) {
        Node node2 = this.root;
        while (node2 != nil) {
            int n = this.compare(object, node2.key);
            if (n > 0) {
                node2 = node2.right;
                continue;
            }
            if (n < 0) {
                node2 = node2.left;
                continue;
            }
            return node2;
        }
        return node2;
    }

    final Node highestLessThan(Object object) {
        if (object == nil) {
            return this.lastNode();
        }
        Node node2 = nil;
        Node node3 = this.root;
        int n = 0;
        while (node3 != nil) {
            node2 = node3;
            n = this.compare(object, node3.key);
            if (n > 0) {
                node3 = node3.right;
                continue;
            }
            if (n < 0) {
                node3 = node3.left;
                continue;
            }
            return this.predecessor(node2);
        }
        if (n <= 0) {
            return this.predecessor(node2);
        }
        return node2;
    }

    private void insertFixup(Node node2) {
        while (node2.parent.color == -1 && node2.parent.parent != nil) {
            Node node3;
            if (node2.parent == node2.parent.parent.left) {
                node3 = node2.parent.parent.right;
                if (node3.color == -1) {
                    node2.parent.color = 1;
                    node3.color = 1;
                    node3.parent.color = -1;
                    node2 = node3.parent;
                    continue;
                }
                if (node2 == node2.parent.right) {
                    node2 = node2.parent;
                    this.rotateLeft(node2);
                }
                node2.parent.color = 1;
                node2.parent.parent.color = -1;
                this.rotateRight(node2.parent.parent);
                continue;
            }
            node3 = node2.parent.parent.left;
            if (node3.color == -1) {
                node2.parent.color = 1;
                node3.color = 1;
                node3.parent.color = -1;
                node2 = node3.parent;
                continue;
            }
            if (node2 == node2.parent.left) {
                node2 = node2.parent;
                this.rotateRight(node2);
            }
            node2.parent.color = 1;
            node2.parent.parent.color = -1;
            this.rotateLeft(node2.parent.parent);
        }
        this.root.color = 1;
    }

    private Node lastNode() {
        Node node2 = this.root;
        while (node2.right != nil) {
            node2 = node2.right;
        }
        return node2;
    }

    final Node lowestGreaterThan(Object object, boolean bl) {
        if (object == nil) {
            if (bl) {
                return this.firstNode();
            }
            return nil;
        }
        Node node2 = nil;
        Node node3 = this.root;
        int n = 0;
        while (node3 != nil) {
            node2 = node3;
            n = this.compare(object, node3.key);
            if (n > 0) {
                node3 = node3.right;
                continue;
            }
            if (n < 0) {
                node3 = node3.left;
                continue;
            }
            return node3;
        }
        if (n > 0) {
            return this.successor(node2);
        }
        return node2;
    }

    private Node predecessor(Node node2) {
        if (node2.left != nil) {
            node2 = node2.left;
            while (node2.right != nil) {
                node2 = node2.right;
            }
            return node2;
        }
        Node node3 = node2.parent;
        while (node2 == node3.left) {
            node2 = node3;
            node3 = node2.parent;
        }
        return node3;
    }

    final void putFromObjStream(ObjectInputStream objectInputStream, int n, boolean bl) throws IOException, ClassNotFoundException {
        this.fabricateTree(n);
        Node node2 = this.firstNode();
        while (--n >= 0) {
            node2.key = objectInputStream.readObject();
            node2.value = bl ? objectInputStream.readObject() : "";
            node2 = this.successor(node2);
        }
    }

    final void putKeysLinear(Iterator iterator, int n) {
        this.fabricateTree(n);
        Node node2 = this.firstNode();
        while (--n >= 0) {
            node2.key = iterator.next();
            node2.value = "";
            node2 = this.successor(node2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.putFromObjStream(objectInputStream, n, true);
    }

    final void removeNode(Node node2) {
        Node node3;
        Node node4;
        ++this.modCount;
        --this.size;
        if (node2.left == nil) {
            node4 = node2;
            node3 = node2.right;
        } else if (node2.right == nil) {
            node4 = node2;
            node3 = node2.left;
        } else {
            node4 = node2.left;
            while (node4.right != nil) {
                node4 = node4.right;
            }
            node3 = node4.left;
            node2.key = node4.key;
            node2.value = node4.value;
        }
        Node node5 = node4.parent;
        if (node3 != nil) {
            node3.parent = node5;
        }
        if (node5 == nil) {
            this.root = node3;
            return;
        }
        if (node4 == node5.left) {
            node5.left = node3;
        } else {
            node5.right = node3;
        }
        if (node4.color == 1) {
            this.deleteFixup(node3, node5);
        }
    }

    private void rotateLeft(Node node2) {
        Node node3 = node2.right;
        node2.right = node3.left;
        if (node3.left != nil) {
            node3.left.parent = node2;
        }
        node3.parent = node2.parent;
        if (node2.parent != nil) {
            if (node2 == node2.parent.left) {
                node2.parent.left = node3;
            } else {
                node2.parent.right = node3;
            }
        } else {
            this.root = node3;
        }
        node3.left = node2;
        node2.parent = node3;
    }

    private void rotateRight(Node node2) {
        Node node3 = node2.left;
        node2.left = node3.right;
        if (node3.right != nil) {
            node3.right.parent = node2;
        }
        node3.parent = node2.parent;
        if (node2.parent != nil) {
            if (node2 == node2.parent.right) {
                node2.parent.right = node3;
            } else {
                node2.parent.left = node3;
            }
        } else {
            this.root = node3;
        }
        node3.right = node2;
        node2.parent = node3;
    }

    final Node successor(Node node2) {
        if (node2.right != nil) {
            node2 = node2.right;
            while (node2.left != nil) {
                node2 = node2.left;
            }
            return node2;
        }
        Node node3 = node2.parent;
        while (node2 == node3.right) {
            node2 = node3;
            node3 = node3.parent;
        }
        return node3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Node node2 = this.firstNode();
        objectOutputStream.writeInt(this.size);
        while (node2 != nil) {
            objectOutputStream.writeObject(node2.key);
            objectOutputStream.writeObject(node2.value);
            node2 = this.successor(node2);
        }
    }

    static {
        TreeMap.nil.parent = nil = new Node(null, null, 1);
        TreeMap.nil.left = nil;
        TreeMap.nil.right = nil;
    }

    private final class SubMap
    extends AbstractMap
    implements SortedMap {
        private /* synthetic */ TreeMap this$0;
        final Object minKey;
        final Object maxKey;
        private Set entries;

        static /* synthetic */ TreeMap access$2(SubMap subMap, TreeMap treeMap) {
            subMap.this$0 = treeMap;
            return subMap.this$0;
        }

        static TreeMap access$0(SubMap subMap) {
            return subMap.this$0;
        }

        SubMap(TreeMap treeMap, Object object, Object object2) {
            this.this$0 = treeMap;
            if (object != nil && object2 != nil && treeMap.compare(object, object2) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.minKey = object;
            this.maxKey = object2;
        }

        boolean keyInRange(Object object) {
            return !(this.minKey != nil && this.this$0.compare(object, this.minKey) < 0 || this.maxKey != nil && this.this$0.compare(object, this.maxKey) >= 0);
        }

        public void clear() {
            Node node2 = this.this$0.lowestGreaterThan(this.minKey, true);
            Node node3 = this.this$0.lowestGreaterThan(this.maxKey, false);
            while (node2 != node3) {
                Node node4 = node2;
                node2 = this.this$0.successor(node4);
                this.this$0.removeNode(node4);
            }
        }

        public Comparator comparator() {
            return this.this$0.comparator;
        }

        public boolean containsKey(Object object) {
            return this.keyInRange(object) && this.this$0.containsKey(object);
        }

        public boolean containsValue(Object object) {
            Node node2 = this.this$0.lowestGreaterThan(this.minKey, true);
            Node node3 = this.this$0.lowestGreaterThan(this.maxKey, false);
            while (node2 != node3) {
                if (AbstractMap.equals(object, node2.getValue())) {
                    return true;
                }
                node2 = this.this$0.successor(node2);
            }
            return false;
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new AbstractSet(this){
                    private /* synthetic */ SubMap this$1;
                    {
                        this.this$1 = subMap;
                    }

                    public int size() {
                        return this.this$1.size();
                    }

                    public Iterator iterator() {
                        Node node2 = this.this$1.this$0.lowestGreaterThan(this.this$1.minKey, true);
                        Node node3 = this.this$1.this$0.lowestGreaterThan(this.this$1.maxKey, false);
                        return new TreeIterator(SubMap.access$0(this.this$1), 2, node2, node3);
                    }

                    public void clear() {
                        this.this$1.clear();
                    }

                    public boolean contains(Object object) {
                        if (!(object instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry entry = (Map.Entry)object;
                        Object object2 = entry.getKey();
                        if (!this.this$1.keyInRange(object2)) {
                            return false;
                        }
                        Node node2 = this.this$1.this$0.getNode(object2);
                        return node2 != nil && AbstractCollection.equals(entry.getValue(), node2.value);
                    }

                    public boolean remove(Object object) {
                        if (!(object instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry entry = (Map.Entry)object;
                        Object object2 = entry.getKey();
                        if (!this.this$1.keyInRange(object2)) {
                            return false;
                        }
                        Node node2 = this.this$1.this$0.getNode(object2);
                        if (node2 != nil && AbstractCollection.equals(entry.getValue(), node2.value)) {
                            this.this$1.this$0.removeNode(node2);
                            return true;
                        }
                        return false;
                    }
                };
            }
            return this.entries;
        }

        public Object firstKey() {
            Node node2 = this.this$0.lowestGreaterThan(this.minKey, true);
            if (node2 == nil || !this.keyInRange(node2.key)) {
                throw new NoSuchElementException();
            }
            return node2.key;
        }

        public Object get(Object object) {
            if (this.keyInRange(object)) {
                return this.this$0.get(object);
            }
            return null;
        }

        public SortedMap headMap(Object object) {
            if (!this.keyInRange(object)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(this.this$0, this.minKey, object);
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = new AbstractSet(this){
                    private /* synthetic */ SubMap this$1;
                    {
                        this.this$1 = subMap;
                    }

                    public int size() {
                        return this.this$1.size();
                    }

                    public Iterator iterator() {
                        Node node2 = this.this$1.this$0.lowestGreaterThan(this.this$1.minKey, true);
                        Node node3 = this.this$1.this$0.lowestGreaterThan(this.this$1.maxKey, false);
                        return new TreeIterator(SubMap.access$0(this.this$1), 0, node2, node3);
                    }

                    public void clear() {
                        this.this$1.clear();
                    }

                    public boolean contains(Object object) {
                        if (!this.this$1.keyInRange(object)) {
                            return false;
                        }
                        return this.this$1.this$0.getNode(object) != nil;
                    }

                    public boolean remove(Object object) {
                        if (!this.this$1.keyInRange(object)) {
                            return false;
                        }
                        Node node2 = this.this$1.this$0.getNode(object);
                        if (node2 != nil) {
                            this.this$1.this$0.removeNode(node2);
                            return true;
                        }
                        return false;
                    }
                };
            }
            return this.keys;
        }

        public Object lastKey() {
            Node node2 = this.this$0.highestLessThan(this.maxKey);
            if (node2 == nil || !this.keyInRange(node2.key)) {
                throw new NoSuchElementException();
            }
            return node2.key;
        }

        public Object put(Object object, Object object2) {
            if (!this.keyInRange(object)) {
                throw new IllegalArgumentException("Key outside range");
            }
            return this.this$0.put(object, object2);
        }

        public Object remove(Object object) {
            if (this.keyInRange(object)) {
                return this.this$0.remove(object);
            }
            return null;
        }

        public int size() {
            Node node2 = this.this$0.lowestGreaterThan(this.minKey, true);
            Node node3 = this.this$0.lowestGreaterThan(this.maxKey, false);
            int n = 0;
            while (node2 != node3) {
                ++n;
                node2 = this.this$0.successor(node2);
            }
            return n;
        }

        public SortedMap subMap(Object object, Object object2) {
            if (!this.keyInRange(object) || !this.keyInRange(object2)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(this.this$0, object, object2);
        }

        public SortedMap tailMap(Object object) {
            if (!this.keyInRange(object)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(this.this$0, object, this.maxKey);
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new AbstractCollection(this){
                    private /* synthetic */ SubMap this$1;
                    {
                        this.this$1 = subMap;
                    }

                    public int size() {
                        return this.this$1.size();
                    }

                    public Iterator iterator() {
                        Node node2 = this.this$1.this$0.lowestGreaterThan(this.this$1.minKey, true);
                        Node node3 = this.this$1.this$0.lowestGreaterThan(this.this$1.maxKey, false);
                        return new TreeIterator(SubMap.access$0(this.this$1), 1, node2, node3);
                    }

                    public void clear() {
                        this.this$1.clear();
                    }
                };
            }
            return this.values;
        }
    }

    private final class TreeIterator
    implements Iterator {
        private /* synthetic */ TreeMap this$0;
        private final int type;
        private int knownMod;
        private Node last;
        private Node next;
        private final Node max;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
        }

        TreeIterator(TreeMap treeMap, int n) {
            this.this$0 = treeMap;
            this.finit$();
            this.type = n;
            this.next = treeMap.firstNode();
            this.max = nil;
        }

        TreeIterator(TreeMap treeMap, int n, Node node2, Node node3) {
            this.this$0 = treeMap;
            this.finit$();
            this.type = n;
            this.next = node2;
            this.max = node3;
        }

        public boolean hasNext() {
            return this.next != this.max;
        }

        public Object next() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == this.max) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = this.this$0.successor(this.last);
            if (this.type == 1) {
                return this.last.value;
            }
            if (this.type == 0) {
                return this.last.key;
            }
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            this.this$0.removeNode(this.last);
            this.last = null;
            ++this.knownMod;
        }
    }

    private static final class Node
    extends AbstractMap.BasicMapEntry {
        int color;
        Node left;
        Node right;
        Node parent;

        private /* synthetic */ void finit$() {
            this.left = nil;
            this.right = nil;
            this.parent = nil;
        }

        Node(Object object, Object object2, int n) {
            super(object, object2);
            this.finit$();
            this.color = n;
        }
    }
}

