/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.RootDoc;
import gnu.classpath.tools.FileSystemClassLoader;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.Debug;
import gnu.classpath.tools.gjdoc.ErrorReporter;
import gnu.classpath.tools.gjdoc.PackageDocImpl;
import gnu.classpath.tools.gjdoc.ParseException;
import gnu.classpath.tools.gjdoc.RootDocImpl;
import gnu.classpath.tools.gjdoc.TemporaryStore;
import gnu.classpath.tools.gjdoc.Timer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class Main {
    static final boolean DESCEND_SUPERCLASS = true;
    static final boolean DESCEND_INTERFACES = false;
    static final boolean DESCEND_IMPORTED = true;
    static final int COVERAGE_PUBLIC = 0;
    static final int COVERAGE_PROTECTED = 1;
    static final int COVERAGE_PACKAGE = 2;
    static final int COVERAGE_PRIVATE = 3;
    private static final String STRING_TRY_GJDOC_HELP = "Try `gjdoc --help' for more information.";
    static final boolean[][] coverageTemplates;
    private static Main instance;
    private static RootDocImpl rootDoc;
    private ErrorReporter reporter;
    private String gjdocVersion;
    boolean docletRunning = false;
    private String option_doclet = "gnu.classpath.tools.doclets.htmldoclet.HtmlDoclet";
    private String option_overview;
    private int option_coverage = 1;
    private boolean option_help;
    private String option_docletpath;
    private String option_classpath;
    private List option_sourcepath = new ArrayList();
    private String option_extdirs;
    private boolean option_verbose;
    private boolean option_nowarn;
    private Locale option_locale = new Locale("en", "us");
    private String option_encoding;
    private List option_java_flags = new LinkedList();
    private String option_source = "1.2";
    private List option_subpackages = new ArrayList();
    private List option_exclude = new ArrayList();
    private boolean option_breakiterator;
    private boolean option_licensetext;
    private Collator collator;
    private boolean option_showVersion;
    private boolean option_bootclasspath_specified;
    private boolean option_all;
    private boolean option_reflection;
    private static Map options;

    static {
        boolean[][] blArrayArray = new boolean[4][];
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArray2[1] = true;
        blArrayArray[1] = blArray2;
        boolean[] blArray3 = new boolean[4];
        blArray3[0] = true;
        blArray3[1] = true;
        blArray3[2] = true;
        blArrayArray[2] = blArray3;
        blArrayArray[3] = new boolean[]{true, true, true, true};
        coverageTemplates = blArrayArray;
        instance = new Main();
        options = null;
    }

    private Main() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean startDoclet(List allOptions) {
        try {
            Class docletClass;
            Debug.log(1, "loading doclet class...");
            if (this.option_docletpath != null) {
                try {
                    FileSystemClassLoader docletPathClassLoader = new FileSystemClassLoader(this.option_docletpath);
                    System.err.println("trying to load class  " + this.option_doclet + " from path " + this.option_docletpath);
                    docletClass = docletPathClassLoader.findClass(this.option_doclet);
                }
                catch (Exception exception) {
                    docletClass = Class.forName(this.option_doclet);
                }
            } else {
                docletClass = Class.forName(this.option_doclet);
            }
            Debug.log(1, "doclet class loaded...");
            Method startTempMethod = null;
            Method startMethod = null;
            Method optionLenMethod = null;
            Method validOptionsMethod = null;
            try {
                optionLenMethod = docletClass.getMethod("optionLength", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                validOptionsMethod = docletClass.getMethod("validOptions", String[][].class, DocErrorReporter.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                startTempMethod = docletClass.getMethod("start", TemporaryStore.class);
            }
            catch (Exception exception) {}
            startMethod = docletClass.getMethod("start", RootDoc.class);
            LinkedList<String[]> options = new LinkedList<String[]>();
            LinkedList<String> packageAndClasses = new LinkedList<String>();
            Iterator it = allOptions.iterator();
            while (it.hasNext()) {
                String option = (String)it.next();
                Debug.log(9, "parsing option '" + option + "'");
                if (option.startsWith("-")) {
                    int optlen = Main.optionLength(option);
                    if (optlen <= 0 && optionLenMethod != null) {
                        optionLenMethod.invoke(null, option);
                        Debug.log(3, "invoking optionLen method");
                        optlen = (Integer)optionLenMethod.invoke(null, option);
                        Debug.log(3, "done");
                    }
                    if (optlen <= 0) {
                        if (option.startsWith("-JD")) {
                            String propertyValue = option.substring(3);
                            int ndx = propertyValue.indexOf(61);
                            if (ndx <= 0) {
                                this.reporter.printError("Illegal format in option " + option + ": use -JDproperty=value");
                                return false;
                            }
                            String property = propertyValue.substring(0, ndx);
                            String value = propertyValue.substring(ndx + 1);
                            System.setProperty(property, value);
                            continue;
                        }
                        if (option.startsWith("-J")) {
                            this.reporter.printWarning("Ignored option " + option + ". Pass this option to the VM if required.");
                            continue;
                        }
                        this.reporter.printError("Unknown option " + option);
                        this.reporter.printNotice(STRING_TRY_GJDOC_HELP);
                        return false;
                    }
                    String[] optionAndValues = new String[optlen];
                    optionAndValues[0] = option;
                    int i = 1;
                    while (i < optlen) {
                        if (!it.hasNext()) {
                            this.reporter.printError("Missing value for option " + option);
                            return false;
                        }
                        optionAndValues[i] = (String)it.next();
                        ++i;
                    }
                    options.add(optionAndValues);
                    continue;
                }
                if (option.length() <= 0) continue;
                packageAndClasses.add(option);
            }
            Debug.log(9, "options parsed...");
            for (String subpackage : this.option_subpackages) {
                LinkedHashSet foundPackages = new LinkedHashSet();
                for (File sourceDir : this.option_sourcepath) {
                    File packageDir = new File(sourceDir, subpackage.replace('.', File.separatorChar));
                    this.findPackages(subpackage, packageDir, foundPackages);
                }
                this.addFoundPackages(subpackage, foundPackages);
            }
            if (this.option_all) {
                LinkedHashSet foundPackages = new LinkedHashSet();
                for (File sourceDir : this.option_sourcepath) {
                    this.findPackages("", sourceDir, foundPackages);
                }
                this.addFoundPackages(null, foundPackages);
                for (String packageName : foundPackages) {
                    if (packageName == null) {
                        packageName = "";
                    }
                    rootDoc.addSpecifiedPackageName(packageName);
                }
            }
            for (String classOrPackage : packageAndClasses) {
                boolean sourceFileExists;
                boolean foundSourceFile = false;
                if (classOrPackage.endsWith(".java")) {
                    File sourceFile;
                    Iterator pit = this.option_sourcepath.iterator();
                    while (pit.hasNext() && !foundSourceFile) {
                        File sourceDir = (File)pit.next();
                        File sourceFile2 = new File(sourceDir, classOrPackage);
                        if (!sourceFile2.exists() || sourceFile2.isDirectory()) continue;
                        rootDoc.addSpecifiedSourceFile(sourceFile2);
                        foundSourceFile = true;
                        break;
                    }
                    if (!foundSourceFile && (sourceFile = new File(classOrPackage)).exists() && !sourceFile.isDirectory()) {
                        rootDoc.addSpecifiedSourceFile(sourceFile);
                        foundSourceFile = true;
                    }
                }
                if (foundSourceFile) continue;
                if (classOrPackage.startsWith(".") || classOrPackage.endsWith(".") || classOrPackage.indexOf("..") > 0 || !Main.checkCharSet(classOrPackage, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.")) {
                    throw new ParseException("Illegal class or package name '" + classOrPackage + "'");
                }
                String classOrPackageRelPath = classOrPackage.replace('.', File.separatorChar);
                List packageDirs = rootDoc.findSourceFiles(classOrPackageRelPath);
                List sourceFiles = rootDoc.findSourceFiles(String.valueOf(classOrPackageRelPath) + ".java");
                boolean packageDirExists = !packageDirs.isEmpty();
                boolean bl = sourceFileExists = !sourceFiles.isEmpty();
                if (!packageDirExists && !sourceFileExists) {
                    this.reporter.printError("Class or package " + classOrPackage + " not found.");
                    return false;
                }
                if (packageDirExists && sourceFileExists) {
                    this.reporter.printError("Ambigious class/package name " + classOrPackage + ".");
                    return false;
                }
                if (packageDirExists) {
                    Iterator packageDirIt = packageDirs.iterator();
                    boolean packageDirFound = false;
                    while (packageDirIt.hasNext()) {
                        File packageDir = (File)packageDirIt.next();
                        if (!packageDir.isDirectory()) continue;
                        rootDoc.addSpecifiedPackageName(classOrPackage);
                        packageDirFound = true;
                        break;
                    }
                    if (packageDirFound) continue;
                    this.reporter.printError("No suitable file or directory found for" + classOrPackage);
                    return false;
                }
                this.reporter.printError("No sources files found for package " + classOrPackage);
            }
            if (this.option_help) {
                Main.usage();
                return true;
            }
            String[][] customOptionArr = (String[][])options.toArray((T[])new String[0][0]);
            if (validOptionsMethod != null && !((Boolean)validOptionsMethod.invoke(null, new Object[]{customOptionArr, this.reporter})).booleanValue()) {
                this.reporter.printNotice(STRING_TRY_GJDOC_HELP);
                return false;
            }
            if (!rootDoc.hasSpecifiedPackagesOrClasses()) {
                this.reporter.printError("No packages or classes specified.");
                this.reporter.printNotice(STRING_TRY_GJDOC_HELP);
                return false;
            }
            rootDoc.setOptions(customOptionArr);
            rootDoc.build();
            if (rootDoc.classes().length == 0 && rootDoc.specifiedPackages().length == 0 && rootDoc.specifiedClasses().length == 0) {
                this.reporter.printError("No packages or classes found(!).");
                return false;
            }
            System.gc();
            System.gc();
            this.docletRunning = true;
            this.reporter.printNotice("Running doclet...");
            TemporaryStore tstore = new TemporaryStore(rootDoc);
            Thread.currentThread().setContextClassLoader(docletClass.getClassLoader());
            if (startTempMethod != null) {
                startTempMethod.invoke(null, tstore);
            } else {
                startMethod.invoke(null, tstore.getAndClear());
            }
            if (this.reporter.getWarningCount() > 0) {
                this.reporter.printNotice(String.valueOf(this.reporter.getWarningCount()) + " warnings");
            }
            if (this.reporter.getErrorCount() > 0) {
                this.reporter.printNotice(String.valueOf(this.reporter.getErrorCount()) + " errors");
            }
            System.gc();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void addFoundPackages(String subpackage, Set foundPackages) {
        if (foundPackages.isEmpty()) {
            this.reporter.printWarning("No classes found under subpackage " + subpackage);
        } else {
            boolean onePackageAdded = false;
            for (String foundPackage : foundPackages) {
                boolean excludeThisPackage = false;
                for (String excludePackage : this.option_exclude) {
                    if (!foundPackage.equals(excludePackage) && !foundPackage.startsWith(String.valueOf(excludePackage) + ":")) continue;
                    excludeThisPackage = true;
                    break;
                }
                if (excludeThisPackage) continue;
                rootDoc.addSpecifiedPackageName(foundPackage);
                onePackageAdded = true;
            }
            if (!onePackageAdded) {
                if (subpackage != null) {
                    this.reporter.printWarning("No non-excluded classes found under subpackage " + subpackage);
                } else {
                    this.reporter.printWarning("No non-excluded classes found.");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidJavaFile(File file, String expectedPackage) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            int prevChar = 0;
            int state = 0;
            StringBuffer word = new StringBuffer();
            int wordIndex = 0;
            while (true) {
                int ch;
                if ((ch = ((InputStream)in).read()) < 0) {
                    ((InputStream)in).close();
                    return false;
                }
                String completeWord = null;
                switch (state) {
                    case 1: {
                        if (prevChar != 42 || ch != 47) break;
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (ch != 10) break;
                        state = 0;
                        break;
                    }
                    case 0: {
                        if (prevChar == 47 && ch == 42) {
                            word.deleteCharAt(word.length() - 1);
                            if (word.length() > 0) {
                                completeWord = word.toString();
                                word.setLength(0);
                            }
                            state = 1;
                            break;
                        }
                        if (prevChar == 47 && ch == 47) {
                            word.deleteCharAt(word.length() - 1);
                            if (word.length() > 0) {
                                completeWord = word.toString();
                                word.setLength(0);
                            }
                            state = 2;
                            break;
                        }
                        if (" \t\r\n".indexOf(ch) >= 0) {
                            if (word.length() <= 0) break;
                            completeWord = word.toString();
                            word.setLength(0);
                            break;
                        }
                        if (1 == wordIndex && 59 == ch) {
                            if (word.length() <= 0) {
                                ((InputStream)in).close();
                                return false;
                            }
                            completeWord = word.toString();
                            word.setLength(0);
                            break;
                        }
                        word.append((char)ch);
                        break;
                    }
                }
                if (completeWord != null) {
                    if (wordIndex == 0 && !"package".equals(completeWord)) {
                        ((InputStream)in).close();
                        return "".equals(expectedPackage);
                    }
                    if (1 == wordIndex) {
                        ((InputStream)in).close();
                        return expectedPackage.equals(completeWord);
                    }
                    ++wordIndex;
                }
                prevChar = ch;
            }
        }
        catch (IOException e) {
            this.reporter.printWarning("Could not examine file " + file + ": " + e);
            return false;
        }
    }

    private void findPackages(String subpackage, File packageDir, Set result) {
        File[] files = packageDir.listFiles();
        if (files != null) {
            File file;
            int i = 0;
            while (i < files.length) {
                file = files[i];
                if (!file.isDirectory() && file.getName().endsWith(".java") && this.isValidJavaFile(file, subpackage)) {
                    if ("".equals(subpackage)) {
                        result.add(null);
                        break;
                    }
                    result.add(subpackage);
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < files.length) {
                file = files[i];
                if (file.isDirectory()) {
                    String newSubpackage = subpackage != null && subpackage.length() > 0 ? String.valueOf(subpackage) + "." + file.getName() : file.getName();
                    this.findPackages(newSubpackage, file, result);
                }
                ++i;
            }
        }
    }

    private static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        boolean foundDocletOption = false;
        int i = 0;
        while (i < options.length) {
            String[] opt = options[i];
            if (opt[0].equalsIgnoreCase("-doclet")) {
                if (foundDocletOption) {
                    reporter.printError("Only one -doclet option allowed.");
                    return false;
                }
                foundDocletOption = true;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            Timer.setStartTime();
            int result = instance.start(args);
            if (result < 0) {
                System.exit(5);
            } else if (result > 0) {
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static int execute(String[] args) {
        int result;
        block4: {
            try {
                result = instance.start(args);
                if (result >= 0) break block4;
                return 5;
            }
            catch (Exception exception) {
                return 1;
            }
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public static int execute(String programName, String[] args) {
        return Main.execute(args);
    }

    public int start(String[] args) throws ParseException, IOException {
        ArrayList<String> arguments = new ArrayList<String>(args.length);
        int i = 0;
        while (i < args.length) {
            if (!args[i].startsWith("@")) {
                arguments.add(args[i]);
            } else {
                FileReader reader = new FileReader(args[i].substring(1));
                StreamTokenizer st = new StreamTokenizer(reader);
                st.resetSyntax();
                st.wordChars(0, 65535);
                st.quoteChar(34);
                st.quoteChar(39);
                st.whitespaceChars(32, 32);
                st.whitespaceChars(9, 9);
                st.whitespaceChars(13, 13);
                st.whitespaceChars(10, 10);
                while (st.nextToken() != -1) {
                    arguments.add(st.sval);
                }
            }
            ++i;
        }
        this.initOptions();
        LinkedList<String[]> options = new LinkedList<String[]>();
        new LinkedList();
        rootDoc = new RootDocImpl();
        this.reporter = rootDoc.getReporter();
        Iterator it = arguments.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            int optlen = Main.optionLength(arg);
            if (optlen <= 0) continue;
            String[] option = new String[optlen];
            option[0] = arg;
            boolean optargs_ok = true;
            int j = 1;
            while (j < optlen && optargs_ok) {
                if (it.hasNext()) {
                    option[j] = (String)it.next();
                    if (option[j].startsWith("-")) {
                        optargs_ok = false;
                    }
                } else {
                    optargs_ok = false;
                }
                ++j;
            }
            if (optargs_ok) {
                options.add(option);
                continue;
            }
            this.reporter.printFatal("Missing value for option " + arg + ".");
        }
        String[][] optionArr = (String[][])options.toArray((T[])new String[options.size()][0]);
        if (Main.validOptions(optionArr, rootDoc)) {
            this.readOptions(optionArr);
            if (this.option_showVersion) {
                System.out.println("gjdoc " + this.getGjdocVersion());
                System.exit(0);
            }
            if (this.option_bootclasspath_specified) {
                this.reporter.printWarning("-bootclasspath ignored: not supported by gjdoc wrapper script, or no wrapper script in use.");
            }
            if (this.option_sourcepath.size() == 0) {
                this.option_sourcepath.add(new File("."));
            }
            if (this.option_encoding != null) {
                rootDoc.setSourceEncoding(this.option_encoding);
            } else {
                rootDoc.setSourceEncoding(System.getProperty("file.encoding"));
            }
            rootDoc.setSourcePath(this.option_sourcepath);
            if (!this.startDoclet(arguments)) {
                return -1;
            }
        }
        return this.reporter.getErrorCount();
    }

    private void addJavaLangClasses() throws IOException {
        String line;
        String resourceName = "/java.lang-classes-" + this.option_source + ".txt";
        InputStream in = this.getClass().getResourceAsStream(resourceName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((line = reader.readLine()) != null) {
            String className = line.trim();
            if (className.length() <= 0) continue;
            ClassDocImpl classDoc = new ClassDocImpl(null, new PackageDocImpl("java.lang"), 0, false, false, null);
            classDoc.setClass(className);
            rootDoc.addClassDoc(classDoc);
        }
    }

    private void initOptions() {
        options = new HashMap();
        options.put("-overview", new OptionProcessor(2){

            void process(String[] args) {
                Main.this.option_overview = args[0];
            }
        });
        options.put("-public", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_coverage = 0;
            }
        });
        options.put("-protected", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_coverage = 1;
            }
        });
        options.put("-package", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_coverage = 2;
            }
        });
        options.put("-private", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_coverage = 3;
            }
        });
        OptionProcessor helpProcessor = new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_help = true;
            }
        };
        options.put("-help", helpProcessor);
        options.put("--help", helpProcessor);
        options.put("-doclet", new OptionProcessor(2){

            void process(String[] args) {
                Main.this.option_doclet = args[0];
            }
        });
        options.put("-docletpath", new OptionProcessor(2){

            void process(String[] args) {
                Main.this.option_docletpath = args[0];
            }
        });
        options.put("-nowarn", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_nowarn = true;
            }
        });
        options.put("-source", new OptionProcessor(2){

            void process(String[] args) {
                Main.this.option_source = args[0];
                if (!("1.2".equals(Main.this.option_source) || "1.3".equals(Main.this.option_source) || "1.4".equals(Main.this.option_source))) {
                    throw new RuntimeException("Only he following values are currently supported for option -source: 1.2, 1.3, 1.4.");
                }
            }
        });
        OptionProcessor sourcePathProcessor = new OptionProcessor(2){

            void process(String[] args) {
                Debug.log(1, "-sourcepath is '" + args[0] + "'");
                StringTokenizer st = new StringTokenizer(args[0], File.pathSeparator);
                while (st.hasMoreTokens()) {
                    String path = st.nextToken();
                    File file = new File(path);
                    if (!file.exists()) {
                        throw new RuntimeException("The source path " + path + " does not exist.");
                    }
                    Main.this.option_sourcepath.add(file);
                }
            }
        };
        options.put("-s", sourcePathProcessor);
        options.put("-sourcepath", sourcePathProcessor);
        options.put("-subpackages", new OptionProcessor(2){

            void process(String[] args) {
                StringTokenizer st = new StringTokenizer(args[0], ":");
                while (st.hasMoreTokens()) {
                    String packageName = st.nextToken();
                    if (packageName.startsWith(".") || packageName.endsWith(".") || packageName.indexOf("..") > 0 || !Main.checkCharSet(packageName, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.")) {
                        throw new RuntimeException("Illegal package name '" + packageName + "'");
                    }
                    Main.this.option_subpackages.add(packageName);
                }
            }
        });
        options.put("-exclude", new OptionProcessor(2){

            void process(String[] args) {
                StringTokenizer st = new StringTokenizer(args[0], ":");
                while (st.hasMoreTokens()) {
                    String packageName = st.nextToken();
                    if (packageName.startsWith(".") || packageName.endsWith(".") || packageName.indexOf("..") > 0 || !Main.checkCharSet(packageName, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.")) {
                        throw new RuntimeException("Illegal package name '" + packageName + "'");
                    }
                    Main.this.option_exclude.add(packageName);
                }
            }
        });
        options.put("-verbose", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_verbose = true;
                System.err.println("WARNING: Unsupported option -verbose ignored");
            }
        });
        options.put("-quiet", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.reporter.setQuiet(true);
            }
        });
        options.put("-locale", new OptionProcessor(2){

            void process(String[] args) {
                String localeName = args[0];
                String language = null;
                String country = null;
                String variant = null;
                StringTokenizer st = new StringTokenizer(localeName, "_");
                if (st.hasMoreTokens()) {
                    language = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    country = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    variant = st.nextToken();
                }
                if (variant != null) {
                    Main.this.option_locale = new Locale(language, country, variant);
                } else if (country != null) {
                    Main.this.option_locale = new Locale(language, country);
                } else if (language != null) {
                    Main.this.option_locale = new Locale(language);
                } else {
                    throw new RuntimeException("Illegal locale specification '" + localeName + "'");
                }
            }
        });
        options.put("-encoding", new OptionProcessor(2){

            void process(String[] args) {
                Main.this.option_encoding = args[0];
            }
        });
        options.put("-breakiterator", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_breakiterator = true;
            }
        });
        options.put("-licensetext", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_licensetext = true;
            }
        });
        options.put("-overview", new OptionProcessor(2){

            void process(String[] args) {
                try {
                    Main.getRootDoc().setRawCommentText(RootDocImpl.readHtmlBody(new File(args[0])));
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot read file specified in option -overview: " + e.getMessage());
                }
            }
        });
        options.put("-classpath", new OptionProcessor(2){

            void process(String[] args) {
                Main.this.reporter.printWarning("-classpath option could not be passed to the VM.  Faking it with ");
                Main.this.reporter.printWarning("    System.setProperty(\"java.class.path\", \"" + args[0] + "\");");
                System.setProperty("java.class.path", args[0]);
            }
        });
        options.put("--version", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_showVersion = true;
            }
        });
        options.put("-bootclasspath", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_bootclasspath_specified = true;
            }
        });
        options.put("-all", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_all = true;
            }
        });
        options.put("-reflection", new OptionProcessor(1){

            void process(String[] args) {
                Main.this.option_reflection = true;
            }
        });
    }

    private static int optionLength(String option) {
        OptionProcessor op = (OptionProcessor)options.get(option.toLowerCase());
        if (op != null) {
            return op.argCount;
        }
        return 0;
    }

    private void readOptions(String[][] optionArr) {
        int i = 0;
        while (i < optionArr.length) {
            String[] opt = optionArr[i];
            String[] args = new String[opt.length - 1];
            System.arraycopy(opt, 1, args, 0, opt.length - 1);
            OptionProcessor op = (OptionProcessor)options.get(opt[0].toLowerCase());
            op.process(args);
            ++i;
        }
    }

    private static void usage() {
        System.out.print("\nUSAGE: gjdoc [options] [packagenames] [sourcefiles] [@files]\n\n  --version                Show version information and exit\n  -all                     Process all source files found in the source path\n  -overview <file>         Read overview documentation from HTML file\n  -public                  Include only public classes and members\n  -protected               Include protected and public classes and members\n                           This is the default\n  -package                 Include package/protected/public classes and members\n  -private                 Include all classes and members\n  -help, --help            Show this information\n  -doclet <class>          Doclet class to use for generating output\n  -docletpath <classpath>  Specifies the search path for the doclet and\n                           dependencies\n  -source <release>        Provide source compatibility with specified\n                           release (1.4 to handle assertion)\n  -sourcepath <pathlist>   Where to look for source files\n  -s <pathlist>            Alias for -sourcepath\n  -subpackages <spkglist>  List of subpackages to recursively load\n  -exclude <pkglist>       List of packages to exclude\n  -verbose                 Output messages about what Gjdoc is doing [ignored]\n  -quiet                   Do not print non-error and non-warning messages\n  -locale <name>           Locale to be used, e.g. en_US or en_US_WIN\n  -encoding <name>         Source file encoding name\n  -breakiterator           Compute first sentence with BreakIterator\n  -classpath <pathlist>    Set the path used for loading auxilliary classes\n\nStandard doclet options:\n  -d                      Set target directory\n  -use                    Includes the 'Use' page for each documented class\n                          and package\n  -version                Includes the '@version' tag\n  -author                 Includes the '@author' tag\n  -splitindex             Splits the index file into multiple files\n  -windowtitle <text>     Browser window title\n  -doctitle <text>        Title near the top of the overview summary file\n                          (HTML allowed)\n  -title <text>           Title for this set of API documentation\n                          (deprecated, -doctitle should be used instead)\n  -header <text>          Text to include in the top navigation bar\n                          (HTML allowed)\n  -footer <text>          Text to include in the bottom navigation bar\n                          (HTML allowed)\n  -bottom <text>          Text to include at the bottom of each output file\n                          (HTML allowed)\n  -link <extdoc URL>      Link to external generated documentation at URL\n  -linkoffline <extdoc URL> <packagelistLoc>\n                          Link to external generated documentation for\n                          the specified package-list\n  -linksource             Creates an HTML version of each source file\n  -group <groupheading> <packagepattern:packagepattern:...>\n                          Separates packages on the overview page into groups\n  -nodeprecated           Prevents the generation of any deprecated API\n  -nodeprecatedlist       Prevents the generation of the file containing\n                          the list of deprecated APIs and the link to the\n                          navigation bar to that page\n  -nosince                Omit the '@since' tag\n  -notree                 Do not generate the class/interface hierarchy page\n  -noindex                Do not generate the index file\n  -nohelp                 Do not generate the help link\n  -nonavbar               Do not generate the navbar, header and footer\n  -helpfile <filen>       Path to an alternate help file\n  -stylesheetfile <file>  Path to an alternate CSS stylesheet\n  -addstylesheet <file>   Path to an additional CSS stylesheet\n  -serialwarn             Complain about missing '@serial' tags [ignored]\n  -charset <IANACharset>  Specifies the HTML charset\n  -docencoding <IANACharset>\n                          Specifies the encoding of the generated HTML files\n  -tag <tagname>:Xaoptcmf:\"<taghead>\"\n                          Enables gjdoc to interpret a custom tag\n  -taglet                 Adds a Taglet class to the map of taglets\n  -tagletpath             Sets the CLASSPATH to load subsequent Taglets from\n  -docfilessubdirs        Enables deep copy of 'doc-files' directories\n  -excludedocfilessubdir <name1:name2:...>\n                          Excludes 'doc-files' subdirectories with a give name\n  -noqualifier all|<packagename1:packagename2:...>\n                          Do never fully qualify given package names\n  -nocomment              Suppress the entire comment body including the main\n                          description and all tags, only generate declarations\n\nGjdoc extension options:\n  -reflection             Use reflection for resolving unqualified class names\n  -licensetext            Include license text from source files\n  -validhtml              Use valid HTML/XML names (breaks compatibility)\n  -baseurl <url>          Hardwire the given base URL into generated pages\n");
    }

    public static RootDocImpl getRootDoc() {
        return rootDoc;
    }

    public static Main getInstance() {
        return instance;
    }

    public boolean includeAccessLevel(int accessLevel) {
        return coverageTemplates[this.option_coverage][accessLevel];
    }

    public boolean isDocletRunning() {
        return this.docletRunning;
    }

    public static boolean checkCharSet(String toCheck, String charSet) {
        int i = 0;
        while (i < toCheck.length()) {
            if (charSet.indexOf(toCheck.charAt(i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void releaseRootDoc() {
        rootDoc.flush();
    }

    public boolean isUseBreakIterator() {
        return this.option_breakiterator || !this.getLocale().getLanguage().equals(Locale.ENGLISH.getLanguage());
    }

    public boolean isCopyLicenseText() {
        return this.option_licensetext;
    }

    public Locale getLocale() {
        return this.option_locale;
    }

    public Collator getCollator() {
        if (this.collator == null) {
            Locale locale = this.getLocale();
            this.collator = Collator.getInstance(locale);
            Locale defaultLocale = Locale.getDefault();
            if (this.collator == null && !defaultLocale.equals(locale)) {
                this.collator = Collator.getInstance(defaultLocale);
                if (this.collator != null) {
                    this.reporter.printWarning("No collator found for locale " + locale.getDisplayName() + "; using collator for default locale " + defaultLocale.getDisplayName() + ".");
                } else {
                    this.collator = Collator.getInstance();
                    this.reporter.printWarning("No collator found for specified locale " + locale.getDisplayName() + " or default locale " + defaultLocale.getDisplayName() + ": using default collator.");
                }
            }
            if (this.collator == null) {
                this.collator = Collator.getInstance();
                this.reporter.printWarning("No collator found for locale " + locale.getDisplayName() + ": using default collator.");
            }
        }
        return this.collator;
    }

    public boolean isCacheRawComments() {
        return true;
    }

    public String getGjdocVersion() {
        if (this.gjdocVersion == null) {
            this.gjdocVersion = "0.98";
        }
        return this.gjdocVersion;
    }

    public boolean isReflectionEnabled() {
        return this.option_reflection;
    }

    private abstract class OptionProcessor {
        private int argCount;

        public OptionProcessor(int argCount) {
            this.argCount = argCount;
        }

        abstract void process(String[] var1);
    }
}

