/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.beans.encoder.ScanEngine;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.Statement;
import java.io.OutputStream;

public class XMLEncoder
extends Encoder {
    Object owner;
    Exception exception;
    ScanEngine scanEngine;
    private int accessCounter = 0;

    public XMLEncoder(OutputStream os) {
        this.scanEngine = new ScanEngine(os);
    }

    public void close() {
        if (this.scanEngine != null) {
            this.scanEngine.close();
            this.scanEngine = null;
        }
    }

    public void flush() {
        this.scanEngine.flush();
    }

    public void writeExpression(Expression expr) {
        if (this.accessCounter <= 0) {
            return;
        }
        this.scanEngine.writeExpression(expr);
        Object target = expr.getTarget();
        Object value = null;
        Object newValue = null;
        try {
            value = expr.getValue();
        }
        catch (Exception e) {
            this.getExceptionListener().exceptionThrown(e);
            return;
        }
        newValue = this.get(value);
        if (newValue == null) {
            Object newTarget = this.get(target);
            if (newTarget == null) {
                this.writeObject(target);
                newTarget = this.get(target);
                if (newTarget == null) {
                    return;
                }
            }
            Object[] args = expr.getArguments();
            Object[] newArgs = new Object[args.length];
            int i = 0;
            while (i < args.length) {
                newArgs[i] = this.get(args[i]);
                if (newArgs[i] == null || this.isImmutableType(args[i].getClass())) {
                    this.writeObject(args[i]);
                    newArgs[i] = this.get(args[i]);
                }
                ++i;
            }
            Expression newExpr = new Expression(newTarget, expr.getMethodName(), newArgs);
            if (value instanceof Class && ((Class)value).isPrimitive()) {
                newExpr.setValue(value);
            }
            try {
                newValue = newExpr.getValue();
                this.putCandidate(value, newValue);
            }
            catch (Exception e) {
                this.getExceptionListener().exceptionThrown(e);
                this.scanEngine.revoke();
                return;
            }
            this.writeObject(value);
        } else if (value.getClass() == String.class || value.getClass() == Class.class) {
            this.writeObject(value);
        }
        this.scanEngine.end();
    }

    public void writeStatement(Statement stmt) {
        this.scanEngine.writeStatement(stmt);
        if (this.accessCounter <= 0) {
            return;
        }
        Object target = stmt.getTarget();
        Object newTarget = this.get(target);
        if (newTarget == null) {
            this.writeObject(target);
            newTarget = this.get(target);
        }
        Object[] args = stmt.getArguments();
        Object[] newArgs = new Object[args.length];
        int i = 0;
        while (i < args.length) {
            newArgs[i] = this.get(args[i]);
            if (newArgs[i] == null || this.isImmutableType(args[i].getClass())) {
                this.writeObject(args[i]);
                newArgs[i] = this.get(args[i]);
            } else {
                this.scanEngine.writeObject(args[i]);
            }
            ++i;
        }
        Statement newStmt = new Statement(newTarget, stmt.getMethodName(), newArgs);
        try {
            newStmt.execute();
        }
        catch (Exception e) {
            this.getExceptionListener().exceptionThrown(e);
            this.scanEngine.revoke();
            return;
        }
        this.scanEngine.end();
    }

    public void writeObject(Object o) {
        ++this.accessCounter;
        this.scanEngine.writeObject(o);
        if (this.get(o) == null) {
            super.writeObject(o);
        }
        --this.accessCounter;
    }

    public void setOwner(Object o) {
        this.owner = o;
    }

    public Object getOwner() {
        return this.owner;
    }
}

