/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Integer
extends Number
implements Comparable<Integer> {
    private static final long serialVersionUID = 1360826667806852920L;
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class<Integer> TYPE = VMClassLoader.getPrimitiveClass('I');
    public static final int SIZE = 32;
    private static final int MIN_CACHE = -128;
    private static final int MAX_CACHE = 127;
    private static final Integer[] intCache = new Integer[256];
    private final int value;

    static {
        int i = -128;
        while (i <= 127) {
            Integer.intCache[i - -128] = new Integer(i);
            ++i;
        }
    }

    public Integer(int value) {
        this.value = value;
    }

    public Integer(String s) {
        this.value = Integer.parseInt(s, 10, false);
    }

    private static int stringSize(int num, int radix) {
        int exp = radix < 4 ? 1 : (radix < 8 ? 2 : (radix < 16 ? 3 : (radix < 32 ? 4 : 5)));
        int size = 0;
        do {
            ++size;
        } while ((num >>>= exp) != 0);
        return size;
    }

    public static String toString(int num, int radix) {
        char[] buffer;
        int i;
        int size;
        boolean isNeg;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        boolean bl = isNeg = num < 0;
        if (!isNeg && num < radix) {
            return new String(digits, num, 1, true);
        }
        if (isNeg) {
            if ((num = -num) < 0) {
                i = size = Integer.stringSize(Integer.MAX_VALUE, radix) + 2;
                buffer = new char[size];
                buffer[--i] = digits[-(num + radix) % radix];
                num = -(num / radix);
            } else {
                i = size = Integer.stringSize(num, radix) + 1;
                buffer = new char[size];
            }
        } else {
            i = size = Integer.stringSize(num, radix);
            buffer = new char[size];
        }
        do {
            buffer[--i] = digits[num % radix];
        } while ((num /= radix) > 0);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return new String(buffer, i, size - i, true);
    }

    public static String toHexString(int i) {
        return Integer.toUnsignedString(i, 4);
    }

    public static String toOctalString(int i) {
        return Integer.toUnsignedString(i, 3);
    }

    public static String toBinaryString(int i) {
        return Integer.toUnsignedString(i, 1);
    }

    public static String toString(int i) {
        return String.valueOf(i);
    }

    public static int parseInt(String str, int radix) {
        return Integer.parseInt(str, radix, false);
    }

    public static int parseInt(String s) {
        return Integer.parseInt(s, 10, false);
    }

    public static Integer valueOf(String s, int radix) {
        return Integer.parseInt(s, radix, false);
    }

    public static Integer valueOf(String s) {
        return Integer.parseInt(s, 10, false);
    }

    public static Integer valueOf(int val) {
        if (val < -128 || val > 127) {
            return new Integer(val);
        }
        return intCache[val - -128];
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Integer && this.value == ((Integer)obj).value;
    }

    public static Integer getInteger(String nm) {
        return Integer.getInteger(nm, null);
    }

    public static Integer getInteger(String nm, int val) {
        Integer result = Integer.getInteger(nm, null);
        return result == null ? Integer.valueOf(val) : result;
    }

    public static Integer getInteger(String nm, Integer def) {
        if (nm == null || "".equals(nm)) {
            return def;
        }
        if ((nm = System.getProperty(nm)) == null) {
            return def;
        }
        try {
            return Integer.decode(nm);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static Integer decode(String str) {
        return Integer.parseInt(str, 10, true);
    }

    @Override
    public int compareTo(Integer i) {
        if (this.value == i.value) {
            return 0;
        }
        return this.value > i.value ? 1 : -1;
    }

    public static int bitCount(int x) {
        x = (x >> 1 & 0x55555555) + (x & 0x55555555);
        x = (x >> 2 & 0x33333333) + (x & 0x33333333);
        x = (x >> 4 & 0xF0F0F0F) + (x & 0xF0F0F0F);
        x = (x >> 8 & 0xFF00FF) + (x & 0xFF00FF);
        return (x >> 16 & 0xFFFF) + (x & 0xFFFF);
    }

    public static int rotateLeft(int x, int distance) {
        return x << distance | x >>> -distance;
    }

    public static int rotateRight(int x, int distance) {
        return x << -distance | x >>> distance;
    }

    public static int highestOneBit(int value) {
        value |= value >>> 1;
        value |= value >>> 2;
        value |= value >>> 4;
        value |= value >>> 8;
        value |= value >>> 16;
        return value ^ value >>> 1;
    }

    public static int numberOfLeadingZeros(int value) {
        value |= value >>> 1;
        value |= value >>> 2;
        value |= value >>> 4;
        value |= value >>> 8;
        value |= value >>> 16;
        return Integer.bitCount(~value);
    }

    public static int lowestOneBit(int value) {
        return value & -value;
    }

    public static int numberOfTrailingZeros(int value) {
        return Integer.bitCount((value & -value) - 1);
    }

    public static int signum(int x) {
        return x >> 31 | -x >>> 31;
    }

    public static int reverseBytes(int val) {
        return val >> 24 & 0xFF | val >> 8 & 0xFF00 | val << 8 & 0xFF0000 | val << 24 & 0xFF000000;
    }

    public static int reverse(int val) {
        val = (val >> 1 & 0x55555555) + (val << 1 & 0xAAAAAAAA);
        val = (val >> 2 & 0x33333333) + (val << 2 & 0xCCCCCCCC);
        val = (val >> 4 & 0xF0F0F0F) + (val << 4 & 0xF0F0F0F0);
        val = (val >> 8 & 0xFF00FF) + (val << 8 & 0xFF00FF00);
        return (val >> 16 & 0xFFFF) + (val << 16 & 0xFFFF0000);
    }

    static String toUnsignedString(int num, int exp) {
        int size = 1;
        int copy = num >>> exp;
        while (copy != 0) {
            ++size;
            copy >>>= exp;
        }
        if (size == 1) {
            return new String(digits, num, 1, true);
        }
        int mask = (1 << exp) - 1;
        char[] buffer = new char[size];
        int i = size;
        do {
            buffer[--i] = digits[num & mask];
        } while ((num >>>= exp) != 0);
        return new String(buffer, i, size - i, true);
    }

    static int parseInt(String str, int radix, boolean decode) {
        if (!decode && str == null) {
            throw new NumberFormatException();
        }
        int index = 0;
        int len = str.length();
        boolean isNeg = false;
        if (len == 0) {
            throw new NumberFormatException("string length is null");
        }
        int ch = str.charAt(index);
        if (ch == 45) {
            if (len == 1) {
                throw new NumberFormatException("pure '-'");
            }
            isNeg = true;
            ch = str.charAt(++index);
        } else if (ch == 43) {
            if (len == 1) {
                throw new NumberFormatException("pure '+'");
            }
            ch = str.charAt(++index);
        }
        if (decode) {
            if (ch == 48) {
                if (++index == len) {
                    return 0;
                }
                if ((str.charAt(index) & 0xFFFFFFDF) == 88) {
                    radix = 16;
                    ++index;
                } else {
                    radix = 8;
                }
            } else if (ch == 35) {
                radix = 16;
                ++index;
            }
        }
        if (index == len) {
            throw new NumberFormatException("non terminated number: " + str);
        }
        int max = Integer.MAX_VALUE / radix;
        if (isNeg && Integer.MAX_VALUE % radix == radix - 1) {
            ++max;
        }
        int val = 0;
        while (index < len) {
            if (val < 0 || val > max) {
                throw new NumberFormatException("number overflow (pos=" + index + ") : " + str);
            }
            ch = Character.digit(str.charAt(index++), radix);
            val = val * radix + ch;
            if (ch >= 0 && (val >= 0 || isNeg && val == Integer.MIN_VALUE)) continue;
            throw new NumberFormatException("invalid character at position " + index + " in " + str);
        }
        return isNeg ? -val : val;
    }
}

