/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollButton;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.metal.MetalUtils;
import javax.swing.plaf.metal.OceanTheme;

public class MetalScrollBarUI
extends BasicScrollBarUI {
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    private static final Dimension MIN_THUMB_SIZE = new Dimension(15, 15);
    private static final Dimension MIN_THUMB_SIZE_FREE_STANDING = new Dimension(17, 17);
    protected MetalScrollButton increaseButton;
    protected MetalScrollButton decreaseButton;
    protected int scrollBarWidth;
    protected boolean isFreeStanding = true;
    Color scrollBarShadowColor;

    public static ComponentUI createUI(JComponent component) {
        return new MetalScrollBarUI();
    }

    protected void installDefaults() {
        Boolean prop = (Boolean)this.scrollbar.getClientProperty(FREE_STANDING_PROP);
        this.isFreeStanding = prop == null ? true : prop;
        this.scrollBarShadowColor = UIManager.getColor("ScrollBar.shadow");
        this.scrollBarWidth = UIManager.getInt("ScrollBar.width");
        super.installDefaults();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new MetalScrollBarPropertyChangeHandler();
    }

    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new MetalScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new MetalScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(MetalLookAndFeel.getControl());
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        if (this.scrollbar.getOrientation() == 0) {
            this.paintTrackHorizontal(g, c, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        } else {
            this.paintTrackVertical(g, c, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        }
    }

    private void paintTrackHorizontal(Graphics g, JComponent c, int x, int y, int w, int h) {
        if (c.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(x, y, x, y + h - 1);
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            g.setColor(this.scrollBarShadowColor);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 1);
            g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
            if (this.isFreeStanding) {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawLine(x, y + h - 2, x + w - 1, y + h - 2);
                g.setColor(this.scrollBarShadowColor);
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            if (this.isFreeStanding) {
                g.drawRect(x, y, w - 1, h - 1);
            } else {
                g.drawLine(x, y, x + w - 1, y);
                g.drawLine(x, y, x, y + h - 1);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
        }
    }

    private void paintTrackVertical(Graphics g, JComponent c, int x, int y, int w, int h) {
        if (c.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(x, y, x, y + h - 1);
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(this.scrollBarShadowColor);
            g.drawLine(x + 1, y + 1, x + w - 1, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
            if (this.isFreeStanding) {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawLine(x + w - 2, y, x + w - 2, y + h - 1);
                g.setColor(MetalLookAndFeel.getControlHighlight());
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
        } else {
            g.setColor(MetalLookAndFeel.getControlDisabled());
            if (this.isFreeStanding) {
                g.drawRect(x, y, w - 1, h - 1);
            } else {
                g.drawLine(x, y, x + w - 1, y);
                g.drawLine(x, y, x, y + h - 1);
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        if (this.scrollbar.getOrientation() == 0) {
            this.paintThumbHorizontal(g, c, thumbBounds);
        } else {
            this.paintThumbVertical(g, c, thumbBounds);
        }
        if (!(MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme)) {
            MetalUtils.fillMetalPattern(c, g, thumbBounds.x + 3, thumbBounds.y + 3, thumbBounds.width - 6, thumbBounds.height - 6, this.thumbHighlightColor, this.thumbLightShadowColor);
        }
    }

    private void paintThumbHorizontal(Graphics g, JComponent c, Rectangle thumbBounds) {
        int x = thumbBounds.x;
        int y = thumbBounds.y;
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        MetalTheme theme = MetalLookAndFeel.getCurrentTheme();
        if (theme instanceof OceanTheme && UIManager.get("ScrollBar.gradient") != null) {
            MetalUtils.paintGradient(g, x + 2, y + 2, w - 4, h - 2, 1, "ScrollBar.gradient");
        } else {
            g.setColor(this.thumbColor);
            if (this.isFreeStanding) {
                g.fillRect(x, y, w, h - 1);
            } else {
                g.fillRect(x, y, w, h);
            }
        }
        g.setColor(this.thumbLightShadowColor);
        if (this.isFreeStanding) {
            g.drawRect(x, y, w - 1, h - 2);
        } else {
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y, x, y + h - 1);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        }
        g.setColor(this.thumbHighlightColor);
        if (this.isFreeStanding) {
            g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 3);
        } else {
            g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 1);
        }
        g.setColor(UIManager.getColor("ScrollBar.shadow"));
        g.drawLine(x + w, y + 1, x + w, y + h - 1);
        if (theme instanceof OceanTheme) {
            g.setColor(this.thumbLightShadowColor);
            int middle = x + w / 2;
            g.drawLine(middle - 2, y + 4, middle - 2, y + h - 5);
            g.drawLine(middle, y + 4, middle, y + h - 5);
            g.drawLine(middle + 2, y + 4, middle + 2, y + h - 5);
            g.setColor(UIManager.getColor("ScrollBar.highlight"));
            g.drawLine(middle - 1, y + 5, middle - 1, y + h - 4);
            g.drawLine(middle + 1, y + 5, middle + 1, y + h - 4);
            g.drawLine(middle + 3, y + 5, middle + 3, y + h - 4);
        }
    }

    private void paintThumbVertical(Graphics g, JComponent c, Rectangle thumbBounds) {
        int x = thumbBounds.x;
        int y = thumbBounds.y;
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        MetalTheme theme = MetalLookAndFeel.getCurrentTheme();
        if (theme instanceof OceanTheme && UIManager.get("ScrollBar.gradient") != null) {
            MetalUtils.paintGradient(g, x + 2, y + 2, w - 2, h - 4, 0, "ScrollBar.gradient");
        } else {
            g.setColor(this.thumbColor);
            if (this.isFreeStanding) {
                g.fillRect(x, y, w - 1, h);
            } else {
                g.fillRect(x, y, w, h);
            }
        }
        g.setColor(this.thumbLightShadowColor);
        if (this.isFreeStanding) {
            g.drawRect(x, y, w - 2, h - 1);
        } else {
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y, x, y + h - 1);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        }
        g.setColor(this.thumbHighlightColor);
        if (this.isFreeStanding) {
            g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 3);
        } else {
            g.drawLine(x + 1, y + 1, x + w - 1, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 3);
        }
        g.setColor(UIManager.getColor("ScrollBar.shadow"));
        g.drawLine(x + 1, y + h, x + w - 2, y + h);
        if (theme instanceof OceanTheme) {
            g.setColor(this.thumbLightShadowColor);
            int middle = y + h / 2;
            g.drawLine(x + 4, middle - 2, x + w - 5, middle - 2);
            g.drawLine(x + 4, middle, x + w - 5, middle);
            g.drawLine(x + 4, middle + 2, x + w - 5, middle + 2);
            g.setColor(UIManager.getColor("ScrollBar.highlight"));
            g.drawLine(x + 5, middle - 1, x + w - 4, middle - 1);
            g.drawLine(x + 5, middle + 1, x + w - 4, middle + 1);
            g.drawLine(x + 5, middle + 3, x + w - 4, middle + 3);
        }
    }

    protected Dimension getMinimumThumbSize() {
        Dimension retVal = this.scrollbar != null ? (this.isFreeStanding ? MIN_THUMB_SIZE_FREE_STANDING : MIN_THUMB_SIZE) : new Dimension(0, 0);
        return retVal;
    }

    public Dimension getPreferredSize(JComponent c) {
        int width = 0;
        int height = 0;
        if (this.scrollbar.getOrientation() == 0) {
            width = (int)((double)width + this.incrButton.getPreferredSize().getWidth());
            width = (int)((double)width + this.decrButton.getPreferredSize().getWidth());
            width += 30;
            height = UIManager.getInt("ScrollBar.width");
        } else {
            height = (int)((double)height + this.incrButton.getPreferredSize().getHeight());
            height = (int)((double)height + this.decrButton.getPreferredSize().getHeight());
            height += 30;
            width = UIManager.getInt("ScrollBar.width");
        }
        Insets insets = this.scrollbar.getInsets();
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    class MetalScrollBarPropertyChangeHandler
    extends BasicScrollBarUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals(MetalScrollBarUI.FREE_STANDING_PROP)) {
                Boolean prop = (Boolean)e.getNewValue();
                boolean bl = MetalScrollBarUI.this.isFreeStanding = prop == null ? true : prop;
                if (MetalScrollBarUI.this.increaseButton != null) {
                    MetalScrollBarUI.this.increaseButton.setFreeStanding(MetalScrollBarUI.this.isFreeStanding);
                }
                if (MetalScrollBarUI.this.decreaseButton != null) {
                    MetalScrollBarUI.this.decreaseButton.setFreeStanding(MetalScrollBarUI.this.isFreeStanding);
                }
            } else {
                super.propertyChange(e);
            }
        }
    }
}

