/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom.bootstrap;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.DOMImplementationSource;

public final class DOMImplementationRegistry {
    public static final String PROPERTY = "org.w3c.dom.DOMImplementationSourceList";
    private static final int DEFAULT_LINE_LENGTH = 80;
    private Vector sources;

    private DOMImplementationRegistry(Vector srcs) {
        this.sources = srcs;
    }

    public static DOMImplementationRegistry newInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        Vector<DOMImplementationSource> sources = new Vector<DOMImplementationSource>();
        ClassLoader classLoader = DOMImplementationRegistry.getClassLoader();
        String p = DOMImplementationRegistry.getSystemProperty(PROPERTY);
        if (p == null) {
            p = DOMImplementationRegistry.getServiceValue(classLoader);
        }
        if (p == null) {
            p = "gnu.xml.dom.ImplementationSource";
        }
        if (p != null) {
            StringTokenizer st = new StringTokenizer(p);
            while (st.hasMoreTokens()) {
                String sourceName = st.nextToken();
                Class<?> sourceClass = null;
                sourceClass = classLoader != null ? classLoader.loadClass(sourceName) : Class.forName(sourceName);
                DOMImplementationSource source = (DOMImplementationSource)sourceClass.newInstance();
                sources.addElement(source);
            }
        }
        return new DOMImplementationRegistry(sources);
    }

    public DOMImplementation getDOMImplementation(String features) {
        int size = this.sources.size();
        int i = 0;
        while (i < size) {
            DOMImplementationSource source = (DOMImplementationSource)this.sources.elementAt(i);
            DOMImplementation impl = source.getDOMImplementation(features);
            if (impl != null) {
                return impl;
            }
            ++i;
        }
        return null;
    }

    public DOMImplementationList getDOMImplementationList(String features) {
        final Vector<DOMImplementation> implementations = new Vector<DOMImplementation>();
        int size = this.sources.size();
        int i = 0;
        while (i < size) {
            DOMImplementationSource source = (DOMImplementationSource)this.sources.elementAt(i);
            DOMImplementationList impls = source.getDOMImplementationList(features);
            int j = 0;
            while (j < impls.getLength()) {
                DOMImplementation impl = impls.item(j);
                implementations.addElement(impl);
                ++j;
            }
            ++i;
        }
        return new DOMImplementationList(){

            public DOMImplementation item(int index) {
                if (index >= 0 && index < implementations.size()) {
                    try {
                        return (DOMImplementation)implementations.elementAt(index);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return null;
                    }
                }
                return null;
            }

            public int getLength() {
                return implementations.size();
            }
        };
    }

    public void addSource(DOMImplementationSource s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (!this.sources.contains(s)) {
            this.sources.addElement(s);
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader contextClassLoader = DOMImplementationRegistry.getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader;
            }
        }
        catch (Exception exception) {
            return DOMImplementationRegistry.class.getClassLoader();
        }
        return DOMImplementationRegistry.class.getClassLoader();
    }

    private static String getServiceValue(ClassLoader classLoader) {
        block5: {
            String serviceId = "META-INF/services/org.w3c.dom.DOMImplementationSourceList";
            try {
                BufferedReader rd;
                InputStream is = DOMImplementationRegistry.getResourceAsStream(classLoader, serviceId);
                if (is == null) break block5;
                try {
                    rd = new BufferedReader(new InputStreamReader(is, "UTF-8"), 80);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    rd = new BufferedReader(new InputStreamReader(is), 80);
                }
                String serviceValue = rd.readLine();
                rd.close();
                if (serviceValue != null && serviceValue.length() > 0) {
                    return serviceValue;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static boolean isJRE11() {
        try {
            Class.forName("java.security.AccessController");
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static ClassLoader getContextClassLoader() {
        return DOMImplementationRegistry.isJRE11() ? null : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {}
                return classLoader;
            }
        });
    }

    private static String getSystemProperty(final String name) {
        return DOMImplementationRegistry.isJRE11() ? System.getProperty(name) : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    private static InputStream getResourceAsStream(final ClassLoader classLoader, final String name) {
        if (DOMImplementationRegistry.isJRE11()) {
            InputStream ris = classLoader == null ? ClassLoader.getSystemResourceAsStream(name) : classLoader.getResourceAsStream(name);
            return ris;
        }
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InputStream ris = classLoader == null ? ClassLoader.getSystemResourceAsStream(name) : classLoader.getResourceAsStream(name);
                return ris;
            }
        });
    }
}

