/*
 * Nibbled XEVIOUS
 * -- GMC-4 で動く 4bit ゼビウス --
 *
 * 6番のLEDを上にして縦に置きます．
 * 0番のLEDの下にあるネジがソルバルウです．
 * 4,5,6番のLEDはトーロイドです．
 * 何かキーを押すとザッパーを発射します．
 * スコアが数字LEDに表示されます．
 *
 * コードが4F番地を越えていますが，正常に動作します．
 * 
 */

void main(void) {
    int score = 0;
    int screen = 0;
    int enemy = 0x7;

    while(1) {
	screen = screen + screen;

	if(inputKey(0))
	    screen = 1;

	setLedBinary(enemy, screen);
	setNumberLed(score);

	if(screen == 8) {
	    beepShortSound();
	    enemy = enemy + enemy;

	    if(enemy == 0) {
		enemy = 0x7;
	    } else {
		score++;
	    }
	}
	sleep(0);
    }
}
