#!/bin/sh
echo 'name: convertible
version: 1.0.11.1
id: convertible-1.0.11.1-7977f1714e1906d369ab9f369968c666

license: BSD3
copyright: Copyright (c) 2009-2011 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/convertible
package-url:
description: convertible provides a typeclass with a single function
             that is designed to help convert between different types: numeric
             values, dates and times, and the like.  The conversions perform bounds
             checking and return a pure Either value.  This means that you need
             not remember which specific function performs the conversion you
             desire.
             .
             Also included in the package are optional instances that provide
             conversion for various numeric and time types, as well as utilities
             for writing your own instances.
             .
             Finally, there is a function that will raise an exception on
             bounds-checking violation, or return a bare value otherwise,
             implemented in terms of the safer function described above.
             .
             Convertible is also used by HDBC 2.0 for handling marshalling of
             data to and from databases.
             .
             Convertible is backed by an extensive test suite and passes tests
             on GHC and Hugs.
category: Data
author: John Goerzen
pkgpath: devel/hs-convertible
exposed: True
exposed-modules: Data.Convertible Data.Convertible.Base
                 Data.Convertible.Utils Data.Convertible.Instances
                 Data.Convertible.Instances.C Data.Convertible.Instances.Map
                 Data.Convertible.Instances.Num Data.Convertible.Instances.Text
                 Data.Convertible.Instances.Time
hidden-modules:
import-dirs: /usr/local/lib/ghc/convertible-1.0.11.1
library-dirs: /usr/local/lib/ghc/convertible-1.0.11.1
hs-libraries: HSconvertible-1.0.11.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         bytestring-0.9.1.10-d11caeadd9605139e1a59850ce083826
         containers-0.4.0.0-b4885363abca642443ccd842502a3b7e
         mtl-2.0.1.0-5b7a9cce5565d8cc8721ba4f95becf1b
         old-locale-1.0.0.2-161f79060c89cc16ca11576ceb440486
         old-time-1.0.0.6-088ba18f14be11f5303a5ce07fd2f643
         text-0.11.1.5-24dbc1ca0a1252804bf8bef893d5cf9c
         time-1.2.0.3-3493203919ef238f1a58223fa55b1ceb
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.0.11.1/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.0.11.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
