#!/bin/sh
echo 'name: hashed-storage
version: 0.5.9
id: hashed-storage-0.5.9-6d9be43b4f80ac9368be6a7957bb767d

license: BSD3
copyright: 2009 Petr Rockai <me@mornfall.net>
maintainer: Petr Rockai <me@mornfall.net>
stability:
homepage:
package-url:
description: Support code for reading and manipulating hashed file storage
             (where each file and directory is associated with a
             cryptographic hash, for corruption-resistant storage and fast
             comparisons).
             .
             The supported storage formats include darcs hashed pristine, a
             plain filesystem tree and an indexed plain tree (where the index
             maintains hashes of the plain files and directories).
category: System
author: Petr Rockai <me@mornfall.net>
pkgpath: devel/hs-hashed-storage
exposed: True
exposed-modules: Storage.Hashed Storage.Hashed.AnchoredPath
                 Storage.Hashed.Index Storage.Hashed.Monad Storage.Hashed.Tree
                 Storage.Hashed.Hash Storage.Hashed.Packed Storage.Hashed.Plain
                 Storage.Hashed.Darcs
hidden-modules: Bundled.Posix Bundled.SHA256 Storage.Hashed.Utils
import-dirs: /usr/local/lib/ghc/hashed-storage-0.5.9
library-dirs: /usr/local/lib/ghc/hashed-storage-0.5.9
hs-libraries: HShashed-storage-0.5.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         binary-0.5.0.2-6eebab9f2e28e2aceb2e2ddd3b4b1ca1
         bytestring-0.9.1.10-d11caeadd9605139e1a59850ce083826
         containers-0.4.0.0-b4885363abca642443ccd842502a3b7e
         dataenc-0.13.0.4-35faf9ef6ab96b77e6a414944a7a49d8
         directory-1.1.0.0-0764d4838863123df574e64d163bd619
         extensible-exceptions-0.1.1.2-d8c5b906654260efd7249f497d17a831
         filepath-1.2.0.0-b4f4cf7e95546b00f075372f0ccb0653
         mmap-0.5.6-f199a500783f538fc3fedb95c42c3a4c
         mtl-2.0.1.0-5b7a9cce5565d8cc8721ba4f95becf1b
         zlib-0.5.3.1-7e19941cbd00147a79723e25160ffc8b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hashed-storage-0.5.9/html/hashed-storage.haddock
haddock-html: /usr/local/share/doc/hs-hashed-storage-0.5.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
