#!/bin/sh
echo 'name: transformers
version: 0.2.2.0
id: transformers-0.2.2.0-4bbbfde1fb5c4eb17cdb1963dda698f3

license: BSD3
copyright:
maintainer: Ross Paterson <ross@soi.city.ac.uk>
stability:
homepage:
package-url:
description: Haskell 98 part of a monad transformer library, inspired by the paper
             \"Functional Programming with Overloading and Higher-Order Polymorphism\",
             by Mark P Jones, in /Advanced School of Functional Programming/, 1995
             (<http://web.cecs.pdx.edu/~mpj/pubs/springschool.html>).
             .
             This part contains the monad transformer class, the concrete monad
             transformers, operations and liftings.  It can be used on its own
             in Haskell 98 code, or with the monad classes in the @monads-fd@ or
             @monads-tf@ packages, which automatically lift operations introduced
             by monad transformers through other transformers.
category: Control
author: Andy Gill, Ross Paterson
pkgpath: devel/hs-transformers
exposed: True
exposed-modules: Control.Monad.IO.Class Control.Monad.Trans.Class
                 Control.Monad.Trans.Cont Control.Monad.Trans.Error
                 Control.Monad.Trans.Identity Control.Monad.Trans.List
                 Control.Monad.Trans.Maybe Control.Monad.Trans.Reader
                 Control.Monad.Trans.RWS Control.Monad.Trans.RWS.Lazy
                 Control.Monad.Trans.RWS.Strict Control.Monad.Trans.State
                 Control.Monad.Trans.State.Lazy Control.Monad.Trans.State.Strict
                 Control.Monad.Trans.Writer Control.Monad.Trans.Writer.Lazy
                 Control.Monad.Trans.Writer.Strict Data.Functor.Compose
                 Data.Functor.Constant Data.Functor.Identity Data.Functor.Product
hidden-modules:
import-dirs: /usr/local/lib/ghc/transformers-0.2.2.0
library-dirs: /usr/local/lib/ghc/transformers-0.2.2.0
hs-libraries: HStransformers-0.2.2.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-transformers-0.2.2.0/html/transformers.haddock
haddock-html: /usr/local/share/doc/hs-transformers-0.2.2.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
