/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.util.Reflect;

public class LaunchException
extends Exception {
    private Throwable cause = null;
    private JNLPFile file;
    private String category;
    private String summary;
    private String description;
    private String severity;

    public LaunchException(JNLPFile file, Exception cause, String severity, String category, String summary, String description) {
        super(severity + ": " + category + ": " + summary + " " + (description == null ? "" : description));
        this.file = file;
        this.category = category;
        this.summary = summary;
        this.description = description;
        this.severity = severity;
        this.cause = cause;
    }

    public LaunchException(Throwable cause) {
        this(cause.getMessage());
        this.cause = cause;
    }

    public LaunchException(String message, Throwable cause) {
        this(message + ": " + cause.getMessage());
        this.cause = cause;
    }

    public LaunchException(String message) {
        super(message);
    }

    public JNLPFile getFile() {
        return this.file;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSeverity() {
        return this.severity;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public Throwable[] getCauses() {
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        Reflect r = new Reflect();
        Throwable cause = this.cause;
        while (cause != null) {
            result.add(cause);
            cause = (Throwable)r.invoke(cause, "getCause");
        }
        return result.toArray(new Throwable[0]);
    }

    @Override
    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        if (this.cause != null) {
            stream.println("Caused by: ");
            this.cause.printStackTrace(stream);
        }
    }

    @Override
    public void printStackTrace(PrintWriter stream) {
        super.printStackTrace(stream);
        if (this.cause != null) {
            stream.println("Caused by: ");
            this.cause.printStackTrace(stream);
        }
    }
}

