/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.util.HashMap;
import java.util.Map;
import sun.applet.PluginDebug;

enum PluginObjectStore {
    INSTANCE;

    private HashMap<Integer, Object> objects = new HashMap();
    private HashMap<Integer, Integer> counts = new HashMap();
    private HashMap<Object, Integer> identifiers = new HashMap();
    private final Object lock = new Object();
    private boolean wrapped = false;
    private int nextUniqueIdentifier = 1;

    public static PluginObjectStore getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Integer identifier) {
        Object object = this.lock;
        synchronized (object) {
            return this.objects.get(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getIdentifier(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (object == null) {
                return 0;
            }
            return this.identifiers.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (object == null) {
                return this.identifiers.containsKey(object);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int identifier) {
        Object object = this.lock;
        synchronized (object) {
            return this.objects.containsKey(identifier);
        }
    }

    private boolean checkNeg() {
        if (this.nextUniqueIdentifier < 1) {
            this.wrapped = true;
            this.nextUniqueIdentifier = 1;
        }
        return this.wrapped;
    }

    private int getNextID() {
        while (this.checkNeg() && this.objects.containsKey(this.nextUniqueIdentifier)) {
            ++this.nextUniqueIdentifier;
        }
        return this.nextUniqueIdentifier++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reference(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            Integer identifier = this.identifiers.get(object);
            if (identifier == null) {
                int next = this.getNextID();
                this.objects.put(next, object);
                this.counts.put(next, 1);
                this.identifiers.put(object, next);
            } else {
                this.counts.put(identifier, this.counts.get(identifier) + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unreference(int identifier) {
        Object object = this.lock;
        synchronized (object) {
            Integer currentCount = this.counts.get(identifier);
            if (currentCount == null) {
                return;
            }
            if (currentCount == 1) {
                Object object2 = this.objects.get(identifier);
                this.objects.remove(identifier);
                this.counts.remove(identifier);
                this.identifiers.remove(object2);
            } else {
                this.counts.put(identifier, currentCount - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        Object object = this.lock;
        synchronized (object) {
            if (PluginDebug.DEBUG) {
                for (Map.Entry<Integer, Object> e : this.objects.entrySet()) {
                    PluginDebug.debug(e.getKey(), "::", e.getValue());
                }
            }
        }
    }
}

