/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupElementBuilder
extends LookupElement {
    @NotNull
    private final String myLookupString;
    @NotNull
    private final Object myObject;
    private final boolean myCaseSensitive;
    @Nullable
    private final InsertHandler<LookupElement> myInsertHandler;
    @Nullable
    private final LookupElementRenderer<LookupElement> myRenderer;
    @Nullable
    private final LookupElementPresentation myHardcodedPresentation;
    @NotNull
    private final Set<String> myAllLookupStrings;

    private LookupElementBuilder(String lookupString, Object object, InsertHandler<LookupElement> insertHandler, LookupElementRenderer<LookupElement> renderer, LookupElementPresentation hardcodedPresentation, Set<String> allLookupStrings, boolean caseSensitive) {
        this.myLookupString = lookupString;
        this.myObject = object;
        this.myInsertHandler = insertHandler;
        this.myRenderer = renderer;
        this.myHardcodedPresentation = hardcodedPresentation;
        this.myAllLookupStrings = allLookupStrings;
        this.myCaseSensitive = caseSensitive;
    }

    private LookupElementBuilder(@NotNull String lookupString, @NotNull Object object) {
        if (lookupString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementBuilder.<init> must not be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementBuilder.<init> must not be null");
        }
        this(lookupString, object, null, null, null, Collections.singleton(lookupString), true);
    }

    public static LookupElementBuilder create(@NotNull String lookupString) {
        if (lookupString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementBuilder.create must not be null");
        }
        return new LookupElementBuilder(lookupString, lookupString);
    }

    public static LookupElementBuilder create(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementBuilder.create must not be null");
        }
        return new LookupElementBuilder((String)ObjectUtils.assertNotNull((Object)element.getName()), element);
    }

    public static LookupElementBuilder create(@NotNull Object lookupObject, @NotNull String lookupString) {
        if (lookupObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementBuilder.create must not be null");
        }
        if (lookupString == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementBuilder.create must not be null");
        }
        return new LookupElementBuilder(lookupString, lookupObject);
    }

    public LookupElementBuilder setInsertHandler(@Nullable InsertHandler<LookupElement> insertHandler) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, insertHandler, this.myRenderer, this.myHardcodedPresentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setRenderer(@Nullable LookupElementRenderer<LookupElement> renderer) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, renderer, this.myHardcodedPresentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Override
    @NotNull
    public Set<String> getAllLookupStrings() {
        Set<String> set = this.myAllLookupStrings;
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupElementBuilder.getAllLookupStrings must not return null");
        }
        return set;
    }

    public LookupElementBuilder setIcon(@Nullable Icon icon) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setIcon(icon);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @NotNull
    private LookupElementPresentation copyPresentation() {
        LookupElementPresentation presentation = new LookupElementPresentation();
        if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
        LookupElementPresentation lookupElementPresentation = presentation;
        if (lookupElementPresentation == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupElementBuilder.copyPresentation must not return null");
        }
        return lookupElementPresentation;
    }

    public LookupElementBuilder addLookupString(@NotNull String another) {
        if (another == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementBuilder.addLookupString must not be null");
        }
        THashSet set = new THashSet(this.myAllLookupStrings);
        set.add((Object)another);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myHardcodedPresentation, Collections.unmodifiableSet(set), this.myCaseSensitive);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public LookupElementBuilder setCaseSensitive(boolean caseSensitive) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myHardcodedPresentation, this.myAllLookupStrings, caseSensitive);
    }

    public LookupElementBuilder setTypeText(@Nullable String typeText) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTypeText(typeText);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setPresentableText(@NotNull String presentableText) {
        if (presentableText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupElementBuilder.setPresentableText must not be null");
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemText(presentableText);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setBold() {
        return this.setBold(true);
    }

    public LookupElementBuilder setBold(boolean bold) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextBold(bold);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setStrikeout() {
        return this.setStrikeout(true);
    }

    public LookupElementBuilder setStrikeout(boolean strikeout) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setStrikeout(strikeout);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setTailText(@Nullable String tailText) {
        return this.setTailText(tailText, false);
    }

    public LookupElementBuilder setTailText(@Nullable String tailText, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTailText(tailText, grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupElementBuilder.getLookupString must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public Object getObject() {
        Object object = this.myObject;
        if (object == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/LookupElementBuilder.getObject must not return null");
        }
        return object;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        if (!this.myCaseSensitive) {
            CompletionService.getCompletionService().correctCaseInsensitiveString(this, context);
        }
        if (this.myInsertHandler != null) {
            this.myInsertHandler.handleInsert(context, this);
        }
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        if (this.myRenderer != null) {
            this.myRenderer.renderElement(this, presentation);
        } else if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LookupElementBuilder that = (LookupElementBuilder)((Object)o);
        InsertHandler<LookupElement> insertHandler = that.myInsertHandler;
        if (this.myInsertHandler != null && insertHandler != null ? !this.myInsertHandler.getClass().equals(insertHandler.getClass()) : this.myInsertHandler != insertHandler) {
            return false;
        }
        if (!this.myLookupString.equals(that.myLookupString)) {
            return false;
        }
        if (!this.myObject.equals(that.myObject)) {
            return false;
        }
        LookupElementRenderer<LookupElement> renderer = that.myRenderer;
        return !(this.myRenderer != null && renderer != null ? !this.myRenderer.getClass().equals(renderer.getClass()) : this.myRenderer != renderer);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.myInsertHandler != null ? this.myInsertHandler.getClass().hashCode() : 0);
        result = 31 * result + this.myLookupString.hashCode();
        result = 31 * result + this.myObject.hashCode();
        result = 31 * result + (this.myRenderer != null ? this.myRenderer.getClass().hashCode() : 0);
        return result;
    }
}

