/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.CommonBundle;
import com.intellij.execution.configurations.RemoteConnection;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.PropertyKey;

public class DebuggerBundle {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    private static final String BUNDLE = "messages.DebuggerBundle";

    private DebuggerBundle() {
    }

    public static String getAddressDisplayName(RemoteConnection connection) {
        return connection.isUseSockets() ? connection.getHostName() + ":" + connection.getAddress() : connection.getAddress();
    }

    public static String getTransportName(RemoteConnection connection) {
        return connection.isUseSockets() ? DebuggerBundle.message("transport.name.socket", new Object[0]) : DebuggerBundle.message("transport.name.shared.memory", new Object[0]);
    }

    public static String message(@PropertyKey(resourceBundle="messages.DebuggerBundle") String key, Object ... params) {
        return CommonBundle.message((ResourceBundle)DebuggerBundle.getBundle(), (String)key, (Object[])params);
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = null;
        if (ourBundle != null) {
            bundle = ourBundle.get();
        }
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }
}

