/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.wizard;

import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.ide.wizard.StepListener;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWizardStepEx
implements Step,
Disposable {
    private String myTitle;
    private final EventDispatcher<Listener> myEventDispatcher = EventDispatcher.create(Listener.class);

    public AbstractWizardStepEx(String title) {
        this.myTitle = title;
    }

    @Override
    public void _init() {
    }

    public final void _commitPrev() throws CommitStepException {
        this.commit(CommitType.Prev);
    }

    @Override
    public final void _commit(boolean finishChosen) throws CommitStepException {
        this.commit(finishChosen ? CommitType.Finish : CommitType.Next);
    }

    public void addStepListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    protected void setTitle(String title) {
        this.myTitle = title;
    }

    protected void fireStateChanged() {
        ((Listener)this.myEventDispatcher.getMulticaster()).stateChanged();
    }

    protected void fireGoNext() {
        ((Listener)this.myEventDispatcher.getMulticaster()).doNextAction();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public abstract Object getStepId();

    @Nullable
    public abstract Object getNextStepId();

    @Nullable
    public abstract Object getPreviousStepId();

    public abstract boolean isComplete();

    public abstract void commit(CommitType var1) throws CommitStepException;

    public String getTitle() {
        return this.myTitle;
    }

    public void dispose() {
    }

    @Nullable
    public abstract JComponent getPreferredFocusedComponent();

    public String getHelpId() {
        return null;
    }

    public static interface Listener
    extends StepListener {
        public void doNextAction();
    }

    protected static enum CommitType {
        Prev,
        Next,
        Finish;

    }
}

