/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;

public class FileIndexImplUtil {
    private FileIndexImplUtil() {
    }

    public static boolean iterateRecursively(VirtualFile root, VirtualFileFilter filter, ContentIterator iterator) {
        if (!root.isValid() || !filter.accept(root)) {
            return true;
        }
        if (!iterator.processFile(root)) {
            return false;
        }
        if (root.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile child : children = root.getChildren()) {
                if (FileIndexImplUtil.iterateRecursively(child, filter, iterator)) continue;
                return false;
            }
        }
        return true;
    }
}

