/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class Banner
extends NonOpaquePanel
implements PropertyChangeListener {
    private int myBannerMinHeight;
    private final JComponent myText = new MyText();
    private final NonOpaquePanel myActionsPanel = new NonOpaquePanel(new FlowLayout(2, 2, 2));
    private final Map<Action, LinkLabel> myActions = new HashMap();

    public Banner() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 6, 2, 4));
        this.add((Component)this.myText, "Center");
        this.add((Component)this.myActionsPanel, "East");
    }

    public void addAction(final Action action) {
        action.addPropertyChangeListener(this);
        LinkLabel label = new LinkLabel(null, null, new LinkListener(){

            @Override
            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                action.actionPerformed(new ActionEvent(Banner.this, 1001, "ActionCommandKey"));
            }
        });
        this.myActions.put(action, label);
        this.myActionsPanel.add(label);
        this.updateAction(action);
    }

    void updateAction(Action action) {
        LinkLabel label = this.myActions.get(action);
        label.setVisible(action.isEnabled());
        label.setText((String)action.getValue("Name"));
        label.setToolTipText((String)action.getValue("ShortDescription"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Action) {
            this.updateAction((Action)source);
        }
    }

    public void clearActions() {
        Set<Action> actions = this.myActions.keySet();
        for (Action each : actions) {
            each.removePropertyChangeListener(this);
        }
        this.myActions.clear();
        this.myActionsPanel.removeAll();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.height = this.myBannerMinHeight > 0 ? this.myBannerMinHeight : size.height;
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = this.getMinimumSize().height;
        return size;
    }

    public void setMinHeight(int height) {
        this.myBannerMinHeight = height;
        this.revalidate();
        this.repaint();
    }

    public void setText(String ... text) {
        this.myText.removeAll();
        if (text == null) {
            return;
        }
        for (int i = 0; i < text.length; ++i) {
            JLabel eachLabel = new JLabel(text[i], 0);
            int gap = eachLabel.getIconTextGap();
            eachLabel.setBorder(new EmptyBorder(0, 0, 0, gap));
            eachLabel.setVerticalTextPosition(1);
            eachLabel.setFont(eachLabel.getFont().deriveFont(1, eachLabel.getFont().getSize()));
            this.myText.add(eachLabel);
            if (i >= text.length - 1) continue;
            JLabel eachIcon = new JLabel(IconLoader.getIcon((String)"/general/comboArrowRight.png"), 0);
            eachIcon.setBorder(new EmptyBorder(0, 0, 0, gap));
            this.myText.add(eachIcon);
        }
    }

    public void updateActions() {
        Set<Action> actions = this.myActions.keySet();
        Iterator<Action> iterator = actions.iterator();
        while (iterator.hasNext()) {
            this.updateAction(iterator.next());
        }
    }

    private static class MyText
    extends NonOpaquePanel {
        private MyText() {
        }

        @Override
        public void doLayout() {
            int x = 0;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component each = this.getComponent(i);
                Dimension eachSize = each.getPreferredSize();
                each.setBounds(x, 0, eachSize.width, this.getHeight());
                x += each.getBounds().width;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = new Dimension();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component each = this.getComponent(i);
                Dimension eachSize = each.getPreferredSize();
                size.width += eachSize.width;
                size.height = Math.max(size.height, eachSize.height);
            }
            return size;
        }
    }
}

