/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SimpleToolWindowPanel
extends JPanel {
    private JComponent myToolbar;
    private JComponent myContent;
    private boolean myBorderless;
    private boolean myVertical;

    public SimpleToolWindowPanel(boolean vertical) {
        this(vertical, false);
    }

    public SimpleToolWindowPanel(boolean vertical, boolean borderless) {
        this.setLayout(new BorderLayout(vertical ? 0 : 1, vertical ? 1 : 0));
        this.myBorderless = borderless;
        this.myVertical = vertical;
    }

    public void setToolbar(JComponent c) {
        this.myToolbar = c;
        if (this.myVertical) {
            this.add((Component)c, "North");
        } else {
            this.add((Component)c, "West");
        }
        if (this.myBorderless) {
            UIUtil.removeScrollBorder((Component)c);
        }
        this.revalidate();
        this.repaint();
    }

    public void setContent(JComponent c) {
        this.myContent = c;
        this.add((Component)c, "Center");
        if (this.myBorderless) {
            UIUtil.removeScrollBorder((Component)c);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myToolbar != null && this.myToolbar.getParent() == this && this.myContent != null && this.myContent.getParent() == this) {
            g.setColor(UIUtil.getBorderSeparatorColor());
            if (this.myVertical) {
                int y = (int)this.myToolbar.getBounds().getMaxY();
                g.drawLine(0, y, this.getWidth(), y);
            } else {
                int x = (int)this.myToolbar.getBounds().getMaxX();
                g.drawLine(x, 0, x, this.getHeight());
            }
        }
    }
}

