/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.FilterDescendantVirtualFileConvertible;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.RevisionChangesNotSupportedException;
import com.intellij.openapi.vcs.StartedActivated;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsRootSettings;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.ChangeListEditHandler;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.VcsAppendableDirtyScope;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Convertor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcs
extends StartedActivated {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.AbstractVcs");
    @NonNls
    protected static final String ourIntegerPattern = "\\d+";
    protected final Project myProject;
    private final String myName;
    private final VcsKey myKey;
    private VcsShowSettingOption myUpdateOption;
    private VcsShowSettingOption myStatusOption;

    public AbstractVcs(Project project, String name) {
        super(project);
        this.myProject = project;
        this.myName = name;
        this.myKey = new VcsKey(this.myName);
    }

    @Override
    protected void start() throws VcsException {
    }

    @Override
    protected void shutdown() throws VcsException {
    }

    @Override
    protected void activate() {
    }

    @Override
    protected void deactivate() {
    }

    @NonNls
    public final String getName() {
        return this.myName;
    }

    @NonNls
    public abstract String getDisplayName();

    public abstract Configurable getConfigurable();

    @Nullable
    public TransactionProvider getTransactionProvider() {
        return null;
    }

    @Nullable
    public ChangeProvider getChangeProvider() {
        return null;
    }

    public final VcsConfiguration getConfiguration() {
        return VcsConfiguration.getInstance(this.myProject);
    }

    @Nullable
    public EditFileProvider getEditFileProvider() {
        return null;
    }

    public void directoryMappingChanged() {
    }

    public boolean markExternalChangesAsUpToDate() {
        return false;
    }

    @Nullable
    public CheckinEnvironment getCheckinEnvironment() {
        return null;
    }

    @Nullable
    public RollbackEnvironment getRollbackEnvironment() {
        return null;
    }

    @Nullable
    public VcsHistoryProvider getVcsHistoryProvider() {
        return null;
    }

    @Nullable
    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return null;
    }

    public String getMenuItemText() {
        return this.getDisplayName();
    }

    @Nullable
    public UpdateEnvironment getUpdateEnvironment() {
        return null;
    }

    public boolean fileIsUnderVcs(FilePath filePath) {
        return true;
    }

    public boolean fileExistsInVcs(FilePath path) {
        VirtualFile virtualFile = path.getVirtualFile();
        if (virtualFile != null) {
            FileStatus fileStatus = FileStatusManager.getInstance(this.myProject).getStatus(virtualFile);
            return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED;
        }
        return true;
    }

    public static boolean fileInVcsByFileStatus(Project project, FilePath path) {
        VirtualFile virtualFile = path.getVirtualFile();
        if (virtualFile != null) {
            FileStatus fileStatus = FileStatusManager.getInstance(project).getStatus(virtualFile);
            return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED && fileStatus != FileStatus.IGNORED;
        }
        return true;
    }

    @Nullable
    public UpdateEnvironment getStatusEnvironment() {
        return null;
    }

    @Nullable
    public AnnotationProvider getAnnotationProvider() {
        return null;
    }

    @Nullable
    public DiffProvider getDiffProvider() {
        return null;
    }

    public VcsShowSettingOption getUpdateOptions() {
        return this.myUpdateOption;
    }

    public VcsShowSettingOption getStatusOptions() {
        return this.myStatusOption;
    }

    public void loadSettings() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(this.myProject);
        if (this.getUpdateEnvironment() != null) {
            this.myUpdateOption = vcsManager.getStandardOption(VcsConfiguration.StandardOption.UPDATE, this);
        }
        if (this.getStatusEnvironment() != null) {
            this.myStatusOption = vcsManager.getStandardOption(VcsConfiguration.StandardOption.STATUS, this);
        }
    }

    public FileStatus[] getProvidedStatuses() {
        return null;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return null;
    }

    @Nullable
    public UpdateEnvironment getIntegrateEnvironment() {
        return null;
    }

    @Nullable
    public CommittedChangesProvider getCommittedChangesProvider() {
        return null;
    }

    @Nullable
    public final CachingCommittedChangesProvider getCachingCommittedChangesProvider() {
        CommittedChangesProvider provider = this.getCommittedChangesProvider();
        if (provider instanceof CachingCommittedChangesProvider) {
            return (CachingCommittedChangesProvider)provider;
        }
        return null;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString, FilePath path) {
        return this.parseRevisionNumber(revisionNumberString);
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        return null;
    }

    @Nullable
    public String getRevisionPattern() {
        return null;
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return false;
    }

    public boolean supportsVersionedStateDetection() {
        return true;
    }

    @Nullable
    public UnnamedConfigurable getRootConfigurable(VcsDirectoryMapping mapping) {
        return null;
    }

    @Nullable
    public VcsRootSettings createEmptyVcsRootSettings() {
        return null;
    }

    @Nullable
    public RootsConvertor getCustomConvertor() {
        return null;
    }

    @Nullable
    public MergeProvider getMergeProvider() {
        return null;
    }

    @Nullable
    public List<AnAction> getAdditionalActionsForLocalChange() {
        return null;
    }

    @Nullable
    public ChangeListEditHandler getEditHandler() {
        return null;
    }

    public boolean allowsNestedRoots() {
        return false;
    }

    public <S> List<S> filterUniqueRoots(List<S> in, Convertor<S, VirtualFile> convertor) {
        new FilterDescendantVirtualFileConvertible<S>(convertor, FilePathComparator.getInstance()).doFilter(in);
        return in;
    }

    public static <S> List<S> filterUniqueRootsDefault(List<S> in, Convertor<S, VirtualFile> convertor) {
        new FilterDescendantVirtualFileConvertible<S>(convertor, FilePathComparator.getInstance()).doFilter(in);
        return in;
    }

    @Nullable
    public VcsExceptionsHotFixer getVcsExceptionsHotFixer() {
        return null;
    }

    public VcsAppendableDirtyScope adjustDirtyScope(VcsAppendableDirtyScope scope) {
        return scope;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected static VcsKey createKey(String name) {
        return new VcsKey(name);
    }

    public final VcsKey getKeyInstanceMethod() {
        return this.myKey;
    }

    public VcsType getType() {
        return VcsType.centralized;
    }

    public boolean checkImmediateParentsBeforeCommit() {
        return false;
    }

    @Nullable
    protected VcsOutgoingChangesProvider getOutgoingProviderImpl() {
        return null;
    }

    @Nullable
    public final VcsOutgoingChangesProvider getOutgoingChangesProvider() {
        return VcsType.centralized.equals((Object)this.getType()) ? null : this.getOutgoingProviderImpl();
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_LATEST_REVISION;
    }

    @Nullable
    protected TreeDiffProvider getTreeDiffProviderImpl() {
        return null;
    }

    @Nullable
    public TreeDiffProvider getTreeDiffProvider() {
        RemoteDifferenceStrategy strategy = this.getRemoteDifferenceStrategy();
        return RemoteDifferenceStrategy.ASK_LATEST_REVISION.equals((Object)strategy) ? null : this.getTreeDiffProviderImpl();
    }

    public List<CommitExecutor> getCommitExecutors() {
        return Collections.emptyList();
    }

    public boolean isVcsBackgroundOperationsAllowed(VirtualFile root) {
        return true;
    }

    @Nullable
    public CommittedChangeList getRevisionChanges(VcsFileRevision revision, VirtualFile file) throws VcsException {
        throw new RevisionChangesNotSupportedException();
    }

    public void generalPreConfigurationStep() {
    }

    public static interface RootsConvertor {
        public List<VirtualFile> convertRoots(List<VirtualFile> var1);
    }
}

