/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public class DelegatePsiTarget
implements PsiTarget {
    private final PsiElement myElement;

    public DelegatePsiTarget(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/DelegatePsiTarget.<init> must not be null");
        }
        this.myElement = element.getNavigationElement();
    }

    public int getTextOffset() {
        TextRange range;
        if (this instanceof PsiDeclaredTarget && (range = ((PsiDeclaredTarget)((Object)this)).getNameIdentifierRange()) != null) {
            return range.getStartOffset() + this.myElement.getTextRange().getStartOffset();
        }
        return this.myElement.getTextOffset();
    }

    @Override
    public void navigate(boolean requestFocus) {
        int offset = this.getTextOffset();
        VirtualFile virtualFile = PsiUtilBase.getVirtualFile(this.myElement);
        if (virtualFile != null && virtualFile.isValid()) {
            new OpenFileDescriptor(this.myElement.getProject(), virtualFile, offset).navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return EditSourceUtil.canNavigate(this.myElement);
    }

    @Override
    public boolean canNavigateToSource() {
        return EditSourceUtil.canNavigate(this.myElement);
    }

    @Override
    @NotNull
    public final PsiElement getNavigationElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/DelegatePsiTarget.getNavigationElement must not return null");
        }
        return psiElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatePsiTarget psiTarget = (DelegatePsiTarget)o;
        return this.myElement.equals(psiTarget.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    @Override
    public boolean isValid() {
        return this.getNavigationElement().isValid();
    }
}

