/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;

public class IdentitySmartPointer<T extends PsiElement>
implements SmartPsiElementPointer<T> {
    private T myElement;
    private final PsiFile myFile;

    public IdentitySmartPointer(T element, PsiFile file) {
        this.myElement = element;
        this.myFile = file;
    }

    public IdentitySmartPointer(T element) {
        this(element, element.getContainingFile());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myFile.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/IdentitySmartPointer.getProject must not return null");
        }
        return project;
    }

    @Override
    public T getElement() {
        if (this.myElement != null && !this.myElement.isValid()) {
            this.myElement = null;
        }
        return this.myElement;
    }

    public int hashCode() {
        T elt = this.getElement();
        return elt == null ? 0 : elt.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SmartPsiElementPointer && Comparing.equal(this.getElement(), ((SmartPsiElementPointer)obj).getElement());
    }

    @Override
    public PsiFile getContainingFile() {
        return this.myFile;
    }
}

