/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.psi.PsiModifierList;
import com.intellij.ui.RowIcon;
import com.intellij.util.Icons;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;

public class VisibilityIcons {
    private VisibilityIcons() {
    }

    public static void setVisibilityIcon(PsiModifierList modifierList, RowIcon baseIcon) {
        if (modifierList != null) {
            if (modifierList.hasModifierProperty("public")) {
                VisibilityIcons.setVisibilityIcon(4, baseIcon);
            } else if (modifierList.hasModifierProperty("private")) {
                VisibilityIcons.setVisibilityIcon(1, baseIcon);
            } else if (modifierList.hasModifierProperty("protected")) {
                VisibilityIcons.setVisibilityIcon(3, baseIcon);
            } else if (modifierList.hasModifierProperty("packageLocal")) {
                VisibilityIcons.setVisibilityIcon(2, baseIcon);
            } else {
                EmptyIcon emptyIcon = new EmptyIcon(Icons.PUBLIC_ICON.getIconWidth(), Icons.PUBLIC_ICON.getIconHeight());
                baseIcon.setIcon((Icon)emptyIcon, 1);
            }
        } else if (Icons.PUBLIC_ICON != null) {
            EmptyIcon emptyIcon = new EmptyIcon(Icons.PUBLIC_ICON.getIconWidth(), Icons.PUBLIC_ICON.getIconHeight());
            baseIcon.setIcon((Icon)emptyIcon, 1);
        }
    }

    public static void setVisibilityIcon(int accessLevel, RowIcon baseIcon) {
        Icon icon;
        switch (accessLevel) {
            case 4: {
                icon = Icons.PUBLIC_ICON;
                break;
            }
            case 3: {
                icon = Icons.PROTECTED_ICON;
                break;
            }
            case 2: {
                icon = Icons.PACKAGE_LOCAL_ICON;
                break;
            }
            case 1: {
                icon = Icons.PRIVATE_ICON;
                break;
            }
            default: {
                if (Icons.PUBLIC_ICON != null) {
                    icon = new EmptyIcon(Icons.PUBLIC_ICON.getIconWidth(), Icons.PUBLIC_ICON.getIconHeight());
                    break;
                }
                return;
            }
        }
        baseIcon.setIcon(icon, 1);
    }
}

