/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

class TestTableRenderer
implements TableCellRenderer {
    private final TableCellRenderer[] myRenderers;
    private final TableCellRenderer myLeftTopRenderer = new DefaultTableCellRenderer();

    public TestTableRenderer(ColumnInfo[] columns) {
        this.myRenderers = new TableCellRenderer[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            ColumnInfo column = columns[i];
            this.myRenderers[i] = column.getRenderer(null);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int modelColumn = table.convertColumnIndexToModel(column);
        TableCellRenderer renderer = this.myRenderers[modelColumn];
        if (row == 0) {
            Component component = (modelColumn == 0 ? this.myLeftTopRenderer : renderer).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setFont(component.getFont().deriveFont(1));
            return component;
        }
        return renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

