/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class UpgradeFormatDialog
extends DialogWrapper {
    private JRadioButton myUpgradeNoneButton;
    private JRadioButton myUpgradeAutoButton;
    private JRadioButton myUpgradeAuto15Button;
    private JRadioButton myUpgradeAuto16Button;
    protected File myPath;

    public UpgradeFormatDialog(Project project, File path, boolean canBeParent) {
        this(project, path, canBeParent, true);
    }

    protected UpgradeFormatDialog(Project project, File path, boolean canBeParent, boolean initHere) {
        super(project, canBeParent);
        this.myPath = path;
        this.setResizable(false);
        this.setTitle(SvnBundle.message("dialog.upgrade.wcopy.format.title", new Object[0]));
        if (initHere) {
            this.init();
        }
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn.upgradeDialog";
    }

    public void setData(boolean display13format, String selectedFormat) {
        if ("auto1.6".equals(selectedFormat)) {
            this.myUpgradeAuto16Button.setSelected(true);
        } else if ("auto".equals(selectedFormat)) {
            this.myUpgradeAutoButton.setSelected(true);
        } else if ("auto1.5".equals(selectedFormat)) {
            this.myUpgradeAuto15Button.setSelected(true);
        } else {
            this.myUpgradeNoneButton.setSelected(true);
        }
        this.myUpgradeNoneButton.setVisible(display13format);
        if (this.myUpgradeNoneButton.isSelected() && !display13format) {
            this.myUpgradeAutoButton.setSelected(true);
        }
    }

    protected String getTopMessage(String label) {
        return SvnBundle.message("label.configure." + label + ".label", ApplicationNamesInfo.getInstance().getFullProductName());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = new Insets(2, 2, 2, 2);
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridwidth = 2;
        gb.gridheight = 1;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.anchor = 17;
        gb.fill = 2;
        File adminPath = new File(this.myPath, SVNFileUtil.getAdminDirectoryName());
        boolean adminPathIsDirectory = adminPath.isDirectory();
        String label = this.getMiddlePartOfResourceKey(adminPathIsDirectory);
        JLabel topLabel = new JLabel(this.getTopMessage(label));
        topLabel.setUI((LabelUI)new MultiLineLabelUI());
        panel.add((Component)topLabel, gb);
        ++gb.gridy;
        this.myUpgradeNoneButton = new JRadioButton(SvnBundle.message("radio.configure." + label + ".none", new Object[0]));
        this.myUpgradeAutoButton = new JRadioButton(SvnBundle.message("radio.configure." + label + ".auto", new Object[0]));
        this.myUpgradeAuto15Button = new JRadioButton(SvnBundle.message("radio.configure." + label + ".auto.15format", new Object[0]));
        this.myUpgradeAuto16Button = new JRadioButton(SvnBundle.message("radio.configure." + label + ".auto.16format", new Object[0]));
        ButtonGroup group = new ButtonGroup();
        group.add(this.myUpgradeNoneButton);
        group.add(this.myUpgradeAutoButton);
        group.add(this.myUpgradeAuto15Button);
        group.add(this.myUpgradeAuto16Button);
        panel.add((Component)this.myUpgradeNoneButton, gb);
        ++gb.gridy;
        panel.add((Component)this.myUpgradeAutoButton, gb);
        ++gb.gridy;
        panel.add((Component)this.myUpgradeAuto15Button, gb);
        ++gb.gridy;
        panel.add((Component)this.myUpgradeAuto16Button, gb);
        ++gb.gridy;
        this.myUpgradeNoneButton.setSelected(true);
        JPanel auxiliaryPanel = this.getBottomAuxiliaryPanel();
        if (auxiliaryPanel != null) {
            panel.add((Component)auxiliaryPanel, gb);
            ++gb.gridy;
        }
        return panel;
    }

    @Nullable
    protected JPanel getBottomAuxiliaryPanel() {
        return null;
    }

    protected String getMiddlePartOfResourceKey(boolean adminPathIsDirectory) {
        return !adminPathIsDirectory ? "create" : "upgrade";
    }

    protected boolean showHints() {
        return true;
    }

    @Nullable
    public String getUpgradeMode() {
        if (this.myUpgradeNoneButton.isSelected()) {
            return "none";
        }
        if (this.myUpgradeAutoButton.isSelected()) {
            return "auto";
        }
        if (this.myUpgradeAuto15Button.isSelected()) {
            return "auto1.5";
        }
        if (this.myUpgradeAuto16Button.isSelected()) {
            return "auto1.6";
        }
        return null;
    }
}

