/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class LocationDetector {
    private final Map<String, File> myMap = new HashMap<String, File>();

    public LocationDetector(SvnVcs vcs) {
        VirtualFile[] roots;
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        for (VirtualFile root : roots = ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).getRootsUnderVcs((AbstractVcs)vcs)) {
            this.myMap.putAll(SvnUtil.getLocationInfoForModule(vcs, new File(root.getPath()), progress));
        }
    }

    @Nullable
    public FilePath crawlForPath(String fullPath, NotNullFunction<File, Boolean> detector) {
        for (Map.Entry<String, File> entry : this.myMap.entrySet()) {
            String url = entry.getKey();
            if (!SVNPathUtil.isAncestor((String)url, (String)fullPath)) continue;
            return LocationDetector.filePathByUrlAndPath(fullPath, url, entry.getValue().getAbsolutePath(), detector);
        }
        return null;
    }

    static FilePath filePathByUrlAndPath(String longPath, String parentUrl, String parentPath, NotNullFunction<File, Boolean> detector) {
        String relPath = longPath.substring(parentUrl.length());
        File localFile = new File(parentPath, relPath);
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(localFile, detector);
    }
}

