/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWCRootCrawler;
import org.jetbrains.idea.svn.update.SvnStatusWorker;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public abstract class AbstractUpdateIntegrateCrawler
implements SvnWCRootCrawler {
    protected final SvnVcs myVcs;
    protected final ISVNEventHandler myHandler;
    protected final Collection<VcsException> myExceptions;
    protected final UpdatedFiles myPostUpdateFiles;
    protected final boolean myIsTotalUpdate;

    protected AbstractUpdateIntegrateCrawler(boolean isTotalUpdate, UpdatedFiles postUpdateFiles, Collection<VcsException> exceptions, ISVNEventHandler handler, SvnVcs vcs) {
        this.myIsTotalUpdate = isTotalUpdate;
        this.myPostUpdateFiles = postUpdateFiles;
        this.myExceptions = exceptions;
        this.myHandler = handler;
        this.myVcs = vcs;
    }

    @Override
    public Collection<File> handleWorkingCopyRoot(File root, ProgressIndicator progress) {
        HashSet<File> result = new HashSet<File>();
        if (progress != null) {
            this.showProgressMessage(progress, root);
        }
        try {
            SVNUpdateClient client = this.myVcs.createUpdateClient();
            client.setEventHandler(this.myHandler);
            long rev = this.doUpdate(root, client);
            if (rev < 0L && !this.isMerge()) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)SvnBundle.message("exception.text.root.was.not.properly.updated", root)));
            }
        }
        catch (SVNException e) {
            this.myExceptions.add(new VcsException((Throwable)e));
        }
        if (!SvnConfiguration.getInstanceChecked((Project)this.myVcs.getProject()).UPDATE_RUN_STATUS) {
            return result;
        }
        SvnStatusWorker statusWorker = new SvnStatusWorker(this.myVcs, result, root, this.myPostUpdateFiles, this.myIsTotalUpdate, this.myExceptions);
        statusWorker.doStatus();
        return result;
    }

    protected abstract void showProgressMessage(ProgressIndicator var1, File var2);

    protected abstract long doUpdate(File var1, SVNUpdateClient var2) throws SVNException;

    protected abstract boolean isMerge();
}

