/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.update.AbstractSvnUpdateIntegrateEnvironment;
import org.jetbrains.idea.svn.update.AbstractSvnUpdatePanel;
import org.jetbrains.idea.svn.update.AbstractUpdateIntegrateCrawler;
import org.jetbrains.idea.svn.update.SvnUpdateConfigurable;
import org.jetbrains.idea.svn.update.SvnUpdatePanel;
import org.jetbrains.idea.svn.update.UpdateRootInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnUpdateEnvironment
extends AbstractSvnUpdateIntegrateEnvironment {
    public SvnUpdateEnvironment(SvnVcs vcs) {
        super(vcs);
    }

    @Override
    protected AbstractUpdateIntegrateCrawler createCrawler(ISVNEventHandler eventHandler, boolean totalUpdate, ArrayList<VcsException> exceptions, UpdatedFiles updatedFiles) {
        return new UpdateCrawler(this.myVcs, eventHandler, totalUpdate, exceptions, updatedFiles);
    }

    @Override
    public Configurable createConfigurable(final Collection<FilePath> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        return new SvnUpdateConfigurable(this.myVcs.getProject()){

            public String getDisplayName() {
                return SvnBundle.message("update.switch.configurable.name", new Object[0]);
            }

            @Override
            protected AbstractSvnUpdatePanel createPanel() {
                return new SvnUpdatePanel(SvnUpdateEnvironment.this.myVcs, collection);
            }
        };
    }

    @Nullable
    private static SVNURL getSourceUrl(SvnVcs vcs, File root) {
        try {
            SVNWCClient wcClient = vcs.createWCClient();
            SVNInfo svnInfo = wcClient.doInfo(root, SVNRevision.WORKING);
            if (svnInfo != null) {
                return svnInfo.getURL();
            }
            return null;
        }
        catch (SVNException e) {
            return null;
        }
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        SvnConfiguration configuration = SvnConfiguration.getInstanceChecked(this.myVcs.getProject());
        Map<File, UpdateRootInfo> map = configuration.getUpdateInfosMap();
        try {
            for (FilePath root : roots) {
                SVNURL url;
                File ioFile = root.getIOFile();
                UpdateRootInfo value = map.get(ioFile);
                if (value == null || (url = value.getUrl()) == null || url.equals((Object)SvnUpdateEnvironment.getSourceUrl(this.myVcs, root.getIOFile()))) continue;
                SVNRevision updateRevision = this.correctRevision(value, url, value.getRevision());
                return true;
            }
        }
        catch (SVNException e) {
            Messages.showErrorDialog((Project)this.myVcs.getProject(), (String)e.getMessage(), (String)SvnBundle.message("switch.target.problem.title", new Object[0]));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNRevision correctRevision(UpdateRootInfo value, SVNURL url, SVNRevision updateRevision) throws SVNException {
        if (SVNRevision.HEAD.equals((Object)value.getRevision())) {
            SVNRepository repository = null;
            try {
                repository = this.myVcs.createRepository(url);
                long longRevision = repository.getLatestRevision();
                SVNRevision newRevision = SVNRevision.create((long)longRevision);
                value.setRevision(newRevision);
                SVNRevision sVNRevision = newRevision;
                return sVNRevision;
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }
        return updateRevision;
    }

    private boolean checkAncestry(File sourceFile, SVNURL targetUrl, SVNRevision targetRevision) throws SVNException {
        SVNWCClient client = this.myVcs.createWCClient();
        SVNInfo sourceSvnInfo = client.doInfo(sourceFile, SVNRevision.WORKING);
        SVNInfo targetSvnInfo = client.doInfo(targetUrl, SVNRevision.UNDEFINED, targetRevision);
        if (sourceSvnInfo == null || targetSvnInfo == null) {
            return true;
        }
        SVNURL copyFromTarget = targetSvnInfo.getCopyFromURL();
        SVNURL copyFromSource = sourceSvnInfo.getCopyFromURL();
        if ((copyFromSource != null || copyFromTarget != null) && (sourceSvnInfo.getURL().equals((Object)copyFromTarget) || targetUrl.equals((Object)copyFromSource))) {
            return true;
        }
        int result = Messages.showYesNoDialog((Project)this.myVcs.getProject(), (String)SvnBundle.message("switch.target.not.copy.current", new Object[0]), (String)SvnBundle.message("switch.target.problem.title", new Object[0]), (Icon)Messages.getWarningIcon());
        return 0 == result;
    }

    protected static class UpdateCrawler
    extends AbstractUpdateIntegrateCrawler {
        public UpdateCrawler(SvnVcs vcs, ISVNEventHandler handler, boolean totalUpdate, Collection<VcsException> exceptions, UpdatedFiles postUpdateFiles) {
            super(totalUpdate, postUpdateFiles, exceptions, handler, vcs);
        }

        @Override
        protected void showProgressMessage(ProgressIndicator progress, File root) {
            progress.setText(SvnBundle.message("progress.text.updating", root.getAbsolutePath()));
        }

        @Override
        protected long doUpdate(File root, SVNUpdateClient client) throws SVNException {
            SVNURL url;
            SvnConfiguration configuration = SvnConfiguration.getInstanceChecked(this.myVcs.getProject());
            UpdateRootInfo rootInfo = configuration.getUpdateRootInfo(root, this.myVcs);
            SVNUpdateClient updateClient = this.myVcs.createUpdateClient();
            updateClient.setEventHandler(this.myHandler);
            updateClient.setUpdateLocksOnDemand(configuration.UPDATE_LOCK_ON_DEMAND);
            long rev = rootInfo != null ? ((url = rootInfo.getUrl()) != null && url.equals((Object)SvnUpdateEnvironment.getSourceUrl(this.myVcs, root)) ? (rootInfo.isUpdateToRevision() ? updateClient.doUpdate(root, rootInfo.getRevision(), configuration.UPDATE_DEPTH, false, false) : updateClient.doUpdate(root, SVNRevision.HEAD, configuration.UPDATE_DEPTH, false, false)) : (url != null ? updateClient.doSwitch(root, url, SVNRevision.UNDEFINED, rootInfo.getRevision(), configuration.UPDATE_DEPTH, false, false) : updateClient.doUpdate(root, SVNRevision.HEAD, configuration.UPDATE_DEPTH, false, false))) : updateClient.doUpdate(root, SVNRevision.HEAD, configuration.UPDATE_DEPTH, false, false);
            this.myPostUpdateFiles.setRevisions(root.getAbsolutePath(), (AbstractVcs)this.myVcs, (VcsRevisionNumber)new SvnRevisionNumber(SVNRevision.create((long)rev)));
            return rev;
        }

        @Override
        protected boolean isMerge() {
            return false;
        }
    }
}

